/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions.plotsquaredv4;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.IQueueChunk;
import com.boydti.fawe.beta.IQueueExtent;
import com.github.intellectualsites.plotsquared.plot.util.block.LocalBlockQueue;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;

public class FaweLocalBlockQueue
extends LocalBlockQueue {
    public final IQueueExtent<IQueueChunk> instance;
    private final World world;
    private BlockVector3 mutable = new MutableBlockVector3();

    public FaweLocalBlockQueue(String worldName) {
        super(worldName);
        this.world = FaweAPI.getWorld(worldName);
        this.instance = Fawe.get().getQueueHandler().getQueue(this.world);
        Fawe.get().getQueueHandler().unCache();
    }

    public boolean next() {
        if (!this.instance.isEmpty()) {
            this.instance.flush();
        }
        return false;
    }

    public void startSet(boolean parallel) {
        Fawe.get().getQueueHandler().startSet(parallel);
    }

    public void endSet(boolean parallel) {
        Fawe.get().getQueueHandler().endSet(parallel);
    }

    public int size() {
        return this.instance.isEmpty() ? 0 : 1;
    }

    public void optimize() {
    }

    public void setModified(long l) {
    }

    public long getModified() {
        return this.instance.size();
    }

    public boolean setBlock(int x, int y, int z, BlockState id) {
        return this.instance.setBlock(x, y, z, id);
    }

    public boolean setBlock(int x, int y, int z, Pattern pattern) {
        this.mutable.setComponents(x, y, z);
        return pattern.apply(this.instance, this.mutable, this.mutable);
    }

    public boolean setBlock(int x, int y, int z, BaseBlock id) {
        return this.instance.setBlock(x, y, z, id);
    }

    public BlockState getBlock(int x, int y, int z) {
        return this.instance.getBlock(x, y, z);
    }

    public boolean setBiome(int x, int z, BiomeType biomeType) {
        return this.instance.setBiome(x, 0, z, biomeType);
    }

    public String getWorld() {
        return this.world.getId();
    }

    public void flush() {
        this.instance.flush();
    }

    public boolean enqueue() {
        boolean val = super.enqueue();
        this.instance.enableQueue();
        return val;
    }

    public void refreshChunk(int x, int z) {
        this.world.refreshChunk(x, z);
    }

    public void fixChunkLighting(int x, int z) {
    }

    public void regenChunk(int x, int z) {
        this.instance.regenerateChunk(x, z, null, null);
    }

    public boolean setTile(int x, int y, int z, CompoundTag tag) {
        this.instance.setTile(x, y, z, (CompoundTag)FaweCache.IMP.asTag((Object)tag));
        return true;
    }
}

