/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions.plotsquaredv4;

import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.bukkit.regions.plotsquaredv4.FaweChunkManager;
import com.boydti.fawe.bukkit.regions.plotsquaredv4.FaweSchematicHandler;
import com.boydti.fawe.bukkit.regions.plotsquaredv4.FaweTrim;
import com.boydti.fawe.bukkit.regions.plotsquaredv4.PlotRegionFilter;
import com.boydti.fawe.bukkit.regions.plotsquaredv4.PlotSetBiome;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.regions.general.RegionFilter;
import com.github.intellectualsites.plotsquared.plot.PlotSquared;
import com.github.intellectualsites.plotsquared.plot.commands.MainCommand;
import com.github.intellectualsites.plotsquared.plot.config.Settings;
import com.github.intellectualsites.plotsquared.plot.database.DBFunc;
import com.github.intellectualsites.plotsquared.plot.flag.Flags;
import com.github.intellectualsites.plotsquared.plot.listener.WEManager;
import com.github.intellectualsites.plotsquared.plot.object.Plot;
import com.github.intellectualsites.plotsquared.plot.object.PlotArea;
import com.github.intellectualsites.plotsquared.plot.object.PlotPlayer;
import com.github.intellectualsites.plotsquared.plot.util.ChunkManager;
import com.github.intellectualsites.plotsquared.plot.util.SchematicHandler;
import com.github.intellectualsites.plotsquared.plot.util.UUIDHandler;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIntersection;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.world.World;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class PlotSquaredFeature
extends FaweMaskManager {
    private static final Logger log = LoggerFactory.getLogger(PlotSquaredFeature.class);

    public PlotSquaredFeature() {
        super("PlotSquared");
        log.debug("Optimizing PlotSquared");
        if (Settings.IMP.ENABLED_COMPONENTS.PLOTSQUARED_HOOK) {
            Settings.Enabled_Components.WORLDEDIT_RESTRICTIONS = false;
            try {
                this.setupBlockQueue();
                this.setupSchematicHandler();
                this.setupChunkManager();
            }
            catch (Throwable ignored) {
                log.debug("Please update PlotSquared: https://www.spigotmc.org/resources/77506/");
            }
            if (com.github.intellectualsites.plotsquared.plot.config.Settings.PLATFORM.toLowerCase(Locale.ROOT).startsWith("bukkit")) {
                new FaweTrim();
            }
            if (MainCommand.getInstance().getCommand("generatebiome") == null) {
                new PlotSetBiome();
            }
        }
    }

    public static String getName(UUID uuid) {
        return UUIDHandler.getName((UUID)uuid);
    }

    private void setupBlockQueue() throws RuntimeException {
    }

    private void setupChunkManager() throws RuntimeException {
        ChunkManager.manager = new FaweChunkManager(ChunkManager.manager);
        log.debug(" - ChunkManager: " + ChunkManager.manager);
    }

    private void setupSchematicHandler() throws RuntimeException {
        SchematicHandler.manager = new FaweSchematicHandler();
        log.debug(" - SchematicHandler: " + SchematicHandler.manager);
    }

    public boolean isAllowed(Player player, Plot plot, FaweMaskManager.MaskType type) {
        if (plot == null) {
            return false;
        }
        UUID uid = player.getUniqueId();
        return !Flags.NO_WORLDEDIT.isTrue(plot) && (plot.isOwner(uid) || type == FaweMaskManager.MaskType.MEMBER && (plot.getTrusted().contains(uid) || plot.getTrusted().contains(DBFunc.EVERYONE) || (plot.getMembers().contains(uid) || plot.getMembers().contains(DBFunc.EVERYONE)) && player.hasPermission("fawe.plotsquared.member")) || player.hasPermission("fawe.plotsquared.admin"));
    }

    @Override
    public FaweMask getMask(Player player, FaweMaskManager.MaskType type) {
        AbstractRegion maskedRegion;
        Set regions;
        PlotPlayer pp = PlotPlayer.wrap((Object)player.getUniqueId());
        if (pp == null) {
            return null;
        }
        Plot plot = pp.getCurrentPlot();
        if (this.isAllowed(player, plot, type)) {
            regions = plot.getRegions();
        } else {
            CuboidRegion region;
            plot = null;
            regions = WEManager.getMask((PlotPlayer)pp);
            if (regions.size() == 1 && (region = (CuboidRegion)regions.iterator().next()).getMinimumPoint().getX() == Integer.MIN_VALUE && region.getMaximumPoint().getX() == Integer.MAX_VALUE) {
                regions.clear();
            }
        }
        if (regions.isEmpty()) {
            return null;
        }
        PlotArea area = pp.getApplicablePlotArea();
        int min = area != null ? area.MIN_BUILD_HEIGHT : 0;
        int max = area != null ? Math.min(255, area.MAX_BUILD_HEIGHT) : 255;
        HashSet<RegionWrapper> faweRegions = new HashSet<RegionWrapper>();
        for (CuboidRegion current : regions) {
            faweRegions.add(new RegionWrapper(current.getMinimumX(), current.getMaximumX(), min, max, current.getMinimumZ(), current.getMaximumZ()));
        }
        CuboidRegion region = (CuboidRegion)regions.iterator().next();
        BlockVector3 pos1 = BlockVector3.at(region.getMinimumX(), min, region.getMinimumZ());
        BlockVector3 pos2 = BlockVector3.at(region.getMaximumX(), max, region.getMaximumZ());
        final Plot finalPlot = plot;
        if (Settings.Done.RESTRICT_BUILDING && Flags.DONE.isSet(finalPlot) || regions.isEmpty()) {
            return null;
        }
        if (regions.size() == 1) {
            maskedRegion = new CuboidRegion(pos1, pos2);
        } else {
            World world = FaweAPI.getWorld(area.worldname);
            List<Region> weRegions = regions.stream().map(r -> new CuboidRegion(world, BlockVector3.at(r.getMinimumX(), r.getMinimumY(), r.getMinimumZ()), BlockVector3.at(r.getMaximumX(), r.getMaximumY(), r.getMaximumZ()))).collect(Collectors.toList());
            maskedRegion = new RegionIntersection(world, weRegions);
        }
        return new FaweMask(maskedRegion){

            @Override
            public boolean isValid(Player player, FaweMaskManager.MaskType type) {
                if (Settings.Done.RESTRICT_BUILDING && Flags.DONE.isSet(finalPlot)) {
                    return false;
                }
                return PlotSquaredFeature.this.isAllowed(player, finalPlot, type);
            }
        };
    }

    @Override
    public RegionFilter getFilter(String world) {
        PlotArea area = PlotSquared.get().getPlotArea(world, null);
        if (area != null) {
            return new PlotRegionFilter(area);
        }
        return null;
    }
}

