/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.util;

import com.boydti.fawe.bukkit.util.BukkitReflectionUtils;
import com.boydti.fawe.util.ReflectionUtils;
import com.google.gson.internal.;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.fastutil.ints.Int2ObjectMap;
import com.sk89q.worldedit.bukkit.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.inventory.ItemStack;

public class ItemUtil {
    private final Method methodAsNMSCopy;
    private final Method methodGetTag;
    private final Method methodHasTag;
    private final Method methodSetTag;
    private final Method methodAsBukkitCopy;
    private final Field fieldHandle;
    private final BukkitImplAdapter adapter;
    private SoftReference<Int2ObjectOpenHashMap<WeakReference<Tag>>> hashToNMSTag = new SoftReference(new Int2ObjectOpenHashMap());

    public ItemUtil() throws Exception {
        this.adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        .Gson.Preconditions.checkNotNull((Object)this.adapter);
        Class<?> classCraftItemStack = BukkitReflectionUtils.getCbClass("inventory.CraftItemStack");
        Class<?> classNMSItem = BukkitReflectionUtils.getNmsClass("ItemStack");
        this.methodAsNMSCopy = ReflectionUtils.setAccessible(classCraftItemStack.getDeclaredMethod("asNMSCopy", ItemStack.class));
        this.methodHasTag = ReflectionUtils.setAccessible(classNMSItem.getDeclaredMethod("hasTag", new Class[0]));
        this.methodGetTag = ReflectionUtils.setAccessible(classNMSItem.getDeclaredMethod("getTag", new Class[0]));
        this.fieldHandle = ReflectionUtils.setAccessible(classCraftItemStack.getDeclaredField("handle"));
        Class<?> classNBTTagCompound = BukkitReflectionUtils.getNmsClass("NBTTagCompound");
        this.methodSetTag = ReflectionUtils.setAccessible(classNMSItem.getDeclaredMethod("setTag", classNBTTagCompound));
        this.methodAsBukkitCopy = ReflectionUtils.setAccessible(classCraftItemStack.getDeclaredMethod("asBukkitCopy", classNMSItem));
    }

    public Object getNMSItem(ItemStack item) {
        try {
            Object nmsItem = this.fieldHandle.get(item);
            if (nmsItem == null) {
                nmsItem = this.methodAsNMSCopy.invoke(null, item);
            }
            return nmsItem;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public CompoundTag getNBT(ItemStack item) {
        try {
            if (!item.hasItemMeta()) {
                return null;
            }
            Object nmsItem = this.fieldHandle.get(item);
            if (nmsItem == null) {
                nmsItem = this.methodAsNMSCopy.invoke(null, item);
            }
            if (this.methodHasTag.invoke(nmsItem, new Object[0]).equals(true)) {
                Tag nativeTag;
                WeakReference<Tag> nativeTagRef;
                Object nmsTag = this.methodGetTag.invoke(nmsItem, new Object[0]);
                if (nmsTag == null) {
                    return null;
                }
                Int2ObjectOpenHashMap<WeakReference<Tag>> map = this.hashToNMSTag.get();
                if (map == null) {
                    map = new Int2ObjectOpenHashMap();
                    this.hashToNMSTag = new SoftReference<Int2ObjectOpenHashMap<WeakReference<Tag>>>(new Int2ObjectOpenHashMap<WeakReference<Tag>>((Int2ObjectMap<WeakReference<Tag>>)map));
                }
                if ((nativeTagRef = map.get(nmsTag.hashCode())) != null && (nativeTag = (Tag)nativeTagRef.get()) != null) {
                    return (CompoundTag)nativeTag;
                }
                nativeTag = this.adapter.toNative(nmsTag);
                map.put(nmsTag.hashCode(), new WeakReference<Tag>(nativeTag));
                return null;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public ItemStack setNBT(ItemStack item, CompoundTag tag) {
        try {
            Object nmsItem = this.fieldHandle.get(item);
            boolean copy = false;
            if (nmsItem == null) {
                copy = true;
                nmsItem = this.methodAsNMSCopy.invoke(null, item);
            }
            Object nmsTag = this.adapter.fromNative(tag);
            this.methodSetTag.invoke(nmsItem, nmsTag);
            if (copy) {
                return (ItemStack)this.methodAsBukkitCopy.invoke(null, nmsItem);
            }
            return item;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

