/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.util.image;

import com.boydti.fawe.util.image.Drawable;
import com.boydti.fawe.util.image.ImageUtil;
import com.boydti.fawe.util.image.ImageViewer;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.inventivetalent.mapmanager.MapManagerPlugin;
import org.inventivetalent.mapmanager.controller.MapController;
import org.inventivetalent.mapmanager.controller.MultiMapController;
import org.inventivetalent.mapmanager.manager.MapManager;
import org.inventivetalent.mapmanager.wrapper.MapWrapper;

public class BukkitImageViewer
implements ImageViewer {
    private final MapManager mapManager = ((MapManagerPlugin)Bukkit.getPluginManager().getPlugin("MapManager")).getMapManager();
    private final Player player;
    private BufferedImage last;
    private ItemFrame[][] frames;
    private boolean reverse;

    public BukkitImageViewer(Player player) {
        this.player = player;
    }

    public void selectFrame(ItemFrame start) {
        Location pos1 = start.getLocation().clone();
        Location pos2 = start.getLocation().clone();
        BlockFace facing = start.getFacing();
        boolean planeX = facing.getModX() == 0;
        boolean planeY = facing.getModY() == 0;
        boolean planeZ = facing.getModZ() == 0;
        ItemFrame[][] res = this.find(pos1, pos2, facing);
        while (true) {
            Location tmp;
            if (res != null) {
                this.frames = res;
            }
            if ((res = this.find(tmp = pos1.clone().subtract((double)planeX, (double)planeY, (double)planeZ), pos2, facing)) != null) {
                pos1 = tmp;
                continue;
            }
            tmp = pos2.clone().add((double)planeX, (double)planeY, (double)planeZ);
            res = this.find(pos1, tmp, facing);
            if (res != null) {
                pos2 = tmp;
                continue;
            }
            tmp = pos1.clone().subtract((double)planeX, 0.0, (double)planeZ);
            res = this.find(tmp, pos2, facing);
            if (res != null) {
                pos1 = tmp;
                continue;
            }
            tmp = pos2.clone().add((double)planeX, 0.0, (double)planeZ);
            res = this.find(pos1, tmp, facing);
            if (res != null) {
                pos2 = tmp;
                continue;
            }
            tmp = pos1.clone().subtract(0.0, 1.0, 0.0);
            res = this.find(tmp, pos2, facing);
            if (res != null) {
                pos1 = tmp;
                continue;
            }
            tmp = pos2.clone().add(0.0, 1.0, 0.0);
            res = this.find(pos1, tmp, facing);
            if (res == null) break;
            pos2 = tmp;
        }
    }

    public ItemFrame[][] getItemFrames() {
        return this.frames;
    }

    private ItemFrame[][] find(Location pos1, Location pos2, BlockFace facing) {
        try {
            Location distance = pos2.clone().subtract(pos1).add(1.0, 1.0, 1.0);
            int width = Math.max(distance.getBlockX(), distance.getBlockZ());
            ItemFrame[][] frames = new ItemFrame[width][distance.getBlockY()];
            World world = pos1.getWorld();
            this.reverse = facing == BlockFace.NORTH || facing == BlockFace.EAST;
            int v = 0;
            double y = pos1.getY();
            while (y <= pos2.getY()) {
                int h = 0;
                for (double z = pos1.getZ(); z <= pos2.getZ(); z += 1.0) {
                    double x = pos1.getX();
                    while (x <= pos2.getX()) {
                        Location pos = new Location(world, x, y, z);
                        Collection entities = world.getNearbyEntities(pos, 0.1, 0.1, 0.1);
                        boolean contains = false;
                        for (Entity ent : entities) {
                            if (!(ent instanceof ItemFrame) || ent.getFacing() != facing) continue;
                            ItemFrame itemFrame = (ItemFrame)ent;
                            itemFrame.setRotation(Rotation.NONE);
                            contains = true;
                            frames[this.reverse ? width - 1 - h : h][v] = (ItemFrame)ent;
                            break;
                        }
                        if (!contains) {
                            return null;
                        }
                        x += 1.0;
                        ++h;
                    }
                }
                y += 1.0;
                ++v;
            }
            return frames;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void view(Drawable drawable) {
        this.view(null, drawable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void view(@Nullable BufferedImage image, @Nullable Drawable drawable) {
        boolean initializing;
        if (image == null && drawable == null) {
            throw new IllegalArgumentException("An image or drawable must be provided. Both cannot be null");
        }
        boolean bl = initializing = this.last == null;
        if (this.frames != null) {
            if (image == null && drawable != null) {
                image = drawable.draw();
            }
            this.last = image;
            int width = this.frames.length;
            int height = this.frames[0].length;
            BufferedImage scaled = ImageUtil.getScaledInstance(image, 128 * width, 128 * height, RenderingHints.VALUE_INTERPOLATION_BILINEAR, false);
            MapWrapper mapWrapper = this.mapManager.wrapMultiImage(scaled, width, height);
            MultiMapController controller = (MultiMapController)mapWrapper.getController();
            controller.addViewer(this.player);
            controller.sendContent(this.player);
            controller.showInFrames(this.player, this.frames, true);
            return;
        } else {
            int slot = this.getMapSlot(this.player);
            if (slot == -1) {
                if (!initializing) return;
                this.player.getInventory().setItemInMainHand(new ItemStack(Material.MAP));
            } else if (this.player.getInventory().getHeldItemSlot() != slot) {
                this.player.getInventory().setHeldItemSlot(slot);
            }
            if (image == null && drawable != null) {
                image = drawable.draw();
            }
            this.last = image;
            BufferedImage scaled = ImageUtil.getScaledInstance(image, 128, 128, RenderingHints.VALUE_INTERPOLATION_BILINEAR, false);
            MapWrapper mapWrapper = this.mapManager.wrapImage(scaled);
            MapController controller = mapWrapper.getController();
            controller.addViewer(this.player);
            controller.sendContent(this.player);
            controller.showInHand(this.player, true);
        }
    }

    private int getMapSlot(Player player) {
        PlayerInventory inventory = player.getInventory();
        for (int i = 0; i < 9; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() != Material.MAP) continue;
            return i;
        }
        return -1;
    }

    public void refresh() {
        if (this.last != null) {
            this.view(this.last, null);
        }
    }

    @Override
    public void close() throws IOException {
        this.last = null;
    }
}

