/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.wrapper;

import com.boydti.fawe.bukkit.wrapper.AsyncBlockState;
import com.boydti.fawe.bukkit.wrapper.AsyncChunk;
import com.boydti.fawe.bukkit.wrapper.AsyncWorld;
import com.boydti.fawe.bukkit.wrapper.state.AsyncSign;
import com.boydti.fawe.util.TaskManager;
import com.destroystokyo.paper.block.BlockSoundGroup;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class AsyncBlock
implements Block {
    public int z;
    public int y;
    public int x;
    public final AsyncWorld world;

    public AsyncBlock(AsyncWorld world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = Math.max(0, Math.min(255, y));
        this.z = z;
    }

    public void setPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Deprecated
    public byte getData() {
        return (byte)this.getPropertyId();
    }

    public int getPropertyId() {
        return this.world.getBlock(this.x, this.y, this.z).getInternalId() >> BlockTypesCache.BIT_OFFSET;
    }

    public int getCombinedId() {
        return this.world.getBlock(this.x, this.y, this.z).getInternalId();
    }

    public int getTypeId() {
        return this.world.getBlock(this.x, this.y, this.z).getBlockType().getInternalId();
    }

    @Nonnull
    public AsyncBlock getRelative(int modX, int modY, int modZ) {
        return new AsyncBlock(this.world, this.x + modX, this.y + modY, this.z + modZ);
    }

    @Nonnull
    public AsyncBlock getRelative(BlockFace face) {
        return this.getRelative(face.getModX(), face.getModY(), face.getModZ());
    }

    @Nonnull
    public AsyncBlock getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    @Nonnull
    public Material getType() {
        return this.getBlockData().getMaterial();
    }

    @Nonnull
    public BlockData getBlockData() {
        return BukkitAdapter.adapt(this.world.getBlock(this.x, this.y, this.z));
    }

    @Deprecated
    public boolean setTypeIdAndPropertyId(int id, int propertyId, boolean physics) {
        return this.setTypeIdAndPropertyId(id, propertyId);
    }

    @Deprecated
    public boolean setTypeIdAndPropertyId(int id, int propertyId) {
        return this.setCombinedId(id + (propertyId << BlockTypesCache.BIT_OFFSET));
    }

    @Deprecated
    public boolean setCombinedId(int combinedId) {
        return this.world.setBlock(this.x, this.y, this.z, BlockState.getFromInternalId(combinedId));
    }

    @Deprecated
    public boolean setTypeId(int typeId) {
        return this.world.setBlock(this.x, this.y, this.z, BlockTypes.get(typeId).getDefaultState());
    }

    @Deprecated
    public boolean setPropertyId(int propertyId) {
        return this.setTypeIdAndPropertyId(this.getTypeId(), propertyId);
    }

    public byte getLightLevel() {
        return 15;
    }

    public byte getLightFromSky() {
        return 15;
    }

    public byte getLightFromBlocks() {
        return 15;
    }

    @Nonnull
    public AsyncWorld getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    @Nonnull
    public Location getLocation() {
        return new Location((World)this.world, (double)this.x, (double)this.y, (double)this.z);
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld((World)this.getWorld());
            loc.setX((double)this.x);
            loc.setY((double)this.y);
            loc.setZ((double)this.z);
        }
        return loc;
    }

    @Nonnull
    public AsyncChunk getChunk() {
        return this.world.getChunkAt(this.x >> 4, this.z >> 4);
    }

    public void setBlockData(@Nonnull BlockData blockData) {
        try {
            this.world.setBlock(this.x, this.y, this.z, BukkitAdapter.adapt(blockData));
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBlockData(@Nonnull BlockData blockData, boolean b) {
        this.setBlockData(blockData);
    }

    public void setType(@Nonnull Material type) {
        try {
            this.world.setBlock(this.x, this.y, this.z, BukkitAdapter.asBlockType(type).getDefaultState());
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    public void setType(@Nonnull Material type, boolean applyPhysics) {
        this.setType(type);
    }

    public BlockFace getFace(@Nonnull Block block) {
        BlockFace[] directions;
        for (BlockFace face : directions = BlockFace.values()) {
            if (this.getX() + face.getModX() != block.getX() || this.getY() + face.getModY() != block.getY() || this.getZ() + face.getModZ() != block.getZ()) continue;
            return face;
        }
        return null;
    }

    @Nonnull
    public AsyncBlockState getState() {
        BaseBlock state = this.world.getFullBlock(this.x, this.y, this.z);
        switch (state.getBlockType().getInternalId()) {
            case 501: 
            case 565: 
            case 606: 
            case 607: 
            case 616: 
            case 617: 
            case 630: 
            case 631: 
            case 642: 
            case 643: 
            case 670: 
            case 671: {
                return new AsyncSign(this, state);
            }
        }
        return new AsyncBlockState(this, state);
    }

    @Nonnull
    public AsyncBlockState getState(boolean useSnapshot) {
        return this.getState();
    }

    @Nonnull
    public Biome getBiome() {
        return this.world.getAdapter().adapt(this.world.getBiomeType(this.x, this.y, this.z));
    }

    public void setBiome(@Nonnull Biome bio) {
        BiomeType biome = this.world.getAdapter().adapt(bio);
        this.world.setBiome(this.x, 0, this.z, biome);
    }

    public boolean isBlockPowered() {
        return false;
    }

    public boolean isBlockIndirectlyPowered() {
        return false;
    }

    public boolean isBlockFacePowered(@Nonnull BlockFace face) {
        return false;
    }

    public boolean isBlockFaceIndirectlyPowered(@Nonnull BlockFace face) {
        return false;
    }

    public int getBlockPower(@Nonnull BlockFace face) {
        return 0;
    }

    public int getBlockPower() {
        return 0;
    }

    public boolean isEmpty() {
        switch (this.getType()) {
            case AIR: 
            case CAVE_AIR: 
            case VOID_AIR: {
                return true;
            }
        }
        return false;
    }

    public boolean isLiquid() {
        return this.world.getBlock(this.x, this.y, this.z).getMaterial().isLiquid();
    }

    public boolean isBuildable() {
        return this.getUnsafeBlock().isBuildable();
    }

    public boolean isBurnable() {
        return this.getType().isBurnable();
    }

    public boolean isReplaceable() {
        return this.getUnsafeBlock().isReplaceable();
    }

    public double getTemperature() {
        return this.getWorld().getTemperature(this.getX(), this.getZ());
    }

    public double getHumidity() {
        return this.getWorld().getHumidity(this.getX(), this.getZ());
    }

    @Nonnull
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.IGNORE;
    }

    @Deprecated
    private Block getUnsafeBlock() {
        return this.world.getBukkitWorld().getBlockAt(this.x, this.y, this.z);
    }

    public boolean breakNaturally() {
        return TaskManager.IMP.sync(() -> this.getUnsafeBlock().breakNaturally());
    }

    public boolean breakNaturally(@Nonnull ItemStack tool) {
        return TaskManager.IMP.sync(() -> this.getUnsafeBlock().breakNaturally(tool));
    }

    public boolean breakNaturally(@Nonnull ItemStack tool, boolean value) {
        return TaskManager.IMP.sync(() -> this.getUnsafeBlock().breakNaturally(tool));
    }

    @Nonnull
    public Collection<ItemStack> getDrops() {
        return TaskManager.IMP.sync(() -> this.getUnsafeBlock().getDrops());
    }

    @Nonnull
    public Collection<ItemStack> getDrops(@Nonnull ItemStack tool) {
        return TaskManager.IMP.sync(() -> this.getUnsafeBlock().getDrops(tool));
    }

    public Collection<ItemStack> getDrops(ItemStack tool, Entity entity) {
        return Collections.emptyList();
    }

    public void setMetadata(@Nonnull String metadataKey, @Nonnull MetadataValue newMetadataValue) {
        this.getUnsafeBlock().setMetadata(metadataKey, newMetadataValue);
    }

    @Nonnull
    public List<MetadataValue> getMetadata(@Nonnull String metadataKey) {
        return this.getUnsafeBlock().getMetadata(metadataKey);
    }

    public boolean hasMetadata(@Nonnull String metadataKey) {
        return this.getUnsafeBlock().hasMetadata(metadataKey);
    }

    public void removeMetadata(@Nonnull String metadataKey, @Nonnull Plugin owningPlugin) {
        this.getUnsafeBlock().removeMetadata(metadataKey, owningPlugin);
    }

    public boolean isPassable() {
        return this.getUnsafeBlock().isPassable();
    }

    public RayTraceResult rayTrace(@Nonnull Location arg0, @Nonnull Vector arg1, double arg2, @Nonnull FluidCollisionMode arg3) {
        return this.getUnsafeBlock().rayTrace(arg0, arg1, arg2, arg3);
    }

    public boolean applyBoneMeal(@Nonnull BlockFace face) {
        throw new UnsupportedOperationException("FAWE does not support this yet");
    }

    public String getTranslationKey() {
        throw new UnsupportedOperationException("FAWE does not support this yet");
    }

    @Nonnull
    public float getDestroySpeed(@Nonnull ItemStack itemStack) {
        throw new UnsupportedOperationException("FAWE does not support this yet");
    }

    @Nonnull
    public BoundingBox getBoundingBox() {
        return this.getUnsafeBlock().getBoundingBox();
    }

    @Nonnull
    public BlockSoundGroup getSoundGroup() {
        return TaskManager.IMP.sync(() -> this.getUnsafeBlock().getSoundGroup());
    }

    @Nonnull
    public boolean isSolid() {
        return this.getType().isSolid();
    }
}

