/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.wrapper;

import com.boydti.fawe.bukkit.wrapper.AsyncBlock;
import com.boydti.fawe.bukkit.wrapper.AsyncWorld;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncBlockState
implements BlockState {
    private BaseBlock state;
    private BlockData blockData;
    private final AsyncBlock block;

    public AsyncBlockState(AsyncBlock block, BaseBlock state) {
        this.state = state;
        this.block = block;
        this.blockData = BukkitAdapter.adapt(state);
    }

    public int getTypeId() {
        return this.state.getBlockType().getInternalId();
    }

    public int getPropertyId() {
        return this.state.getInternalId() >> BlockTypesCache.BIT_OFFSET;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockData getBlockData() {
        return this.blockData;
    }

    public MaterialData getData() {
        return new MaterialData(this.blockData.getMaterial());
    }

    public Material getType() {
        return this.blockData.getMaterial();
    }

    public byte getLightLevel() {
        return (byte)this.state.getMaterial().getLightValue();
    }

    public AsyncWorld getWorld() {
        return this.block.world;
    }

    public int getX() {
        return this.block.x;
    }

    public int getY() {
        return this.block.y;
    }

    public int getZ() {
        return this.block.z;
    }

    public Location getLocation() {
        return this.block.getLocation();
    }

    public Location getLocation(Location loc) {
        return this.block.getLocation(loc);
    }

    @NotNull
    public Chunk getChunk() {
        return this.block.getChunk();
    }

    public void setData(MaterialData data) {
        this.setBlockData(data.getItemType().createBlockData());
    }

    public void setBlockData(BlockData blockData) {
        this.blockData = blockData;
        CompoundTag nbt = this.getNbtData();
        BlockType oldType = this.state.getBlockType();
        com.sk89q.worldedit.world.block.BlockState newState = BukkitAdapter.adapt(blockData);
        if (nbt != null && newState.getBlockType() == oldType) {
            this.setNbtData(nbt);
        } else {
            this.state = newState.toBaseBlock();
        }
    }

    public void setType(Material type) {
        this.setBlockData(type.createBlockData());
    }

    public boolean update() {
        return this.update(false);
    }

    public boolean update(boolean force) {
        return this.update(force, true);
    }

    public boolean update(boolean force, boolean applyPhysics) {
        try {
            return this.block.world.setBlock(this.block.x, this.block.y, this.block.z, this.state);
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public synchronized CompoundTag getNbtData() {
        if (this.state == null) {
            return null;
        }
        return this.state.getNbtData();
    }

    @NotNull
    public Map<String, Tag> cloneNbtMap() {
        return Optional.ofNullable(this.getNbtData()).map(CompoundTag::getValue).map(HashMap::new).orElse(new HashMap());
    }

    public synchronized void setNbtData(@Nullable CompoundTag nbt) {
        this.state = this.state.toBaseBlock(nbt);
    }

    public void setNbtData(@NotNull Map<String, Tag> map) {
        this.setNbtData(new CompoundTag(map));
    }

    public byte getRawData() {
        return (byte)(this.state.getInternalId() >> BlockTypesCache.BIT_OFFSET);
    }

    public void setRawData(byte data) {
        int combinedId = this.getTypeId() + (data << BlockTypesCache.BIT_OFFSET);
        this.state = com.sk89q.worldedit.world.block.BlockState.getFromInternalId(combinedId).toBaseBlock(this.getNbtData());
        this.blockData = BukkitAdapter.adapt(this.state);
    }

    public boolean isPlaced() {
        return true;
    }

    public void setMetadata(String key, MetadataValue value) {
        this.block.setMetadata(key, value);
    }

    public List<MetadataValue> getMetadata(String key) {
        return this.block.getMetadata(key);
    }

    public boolean hasMetadata(String key) {
        return this.block.hasMetadata(key);
    }

    public void removeMetadata(String key, Plugin plugin) {
        this.block.removeMetadata(key, plugin);
    }
}

