/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.wrapper;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.bukkit.wrapper.AsyncBlock;
import com.boydti.fawe.bukkit.wrapper.AsyncWorld;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.TaskManager;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class AsyncChunk
implements Chunk {
    private final AsyncWorld world;
    private final int z;
    private final int x;

    public AsyncChunk(World world, int x, int z) {
        this.world = world instanceof AsyncWorld ? (AsyncWorld)world : new AsyncWorld(world, true);
        this.x = x;
        this.z = z;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Chunk)) {
            return false;
        }
        Chunk other = (Chunk)obj;
        return other.getX() == this.x && other.getZ() == this.z && this.world.equals(other.getWorld());
    }

    public int hashCode() {
        return MathMan.pair((short)this.x, (short)this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public long getChunkKey() {
        return Chunk.getChunkKey((int)this.getX(), (int)this.getZ());
    }

    public AsyncWorld getWorld() {
        return this.world;
    }

    public AsyncBlock getBlock(int x, int y, int z) {
        return new AsyncBlock(this.world, (this.x << 4) + x, y, (this.z << 4) + z);
    }

    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(false, true, false);
    }

    public ChunkSnapshot getChunkSnapshot(boolean includeMaxblocky, boolean includeBiome, boolean includeBiomeTempRain) {
        if (Fawe.isMainThread()) {
            return this.world.getChunkAt(this.x, this.z).getChunkSnapshot(includeMaxblocky, includeBiome, includeBiomeTempRain);
        }
        return this.whenLoaded(() -> this.world.getChunkAt(this.x, this.z).getChunkSnapshot(includeBiome, includeBiome, includeBiomeTempRain));
    }

    private <T> T whenLoaded(Supplier<T> task) {
        if (Fawe.isMainThread()) {
            return task.get();
        }
        if (this.world.isWorld() && this.world.isChunkLoaded(this.x, this.z)) {
            return task.get();
        }
        return TaskManager.IMP.sync(task);
    }

    public Entity[] getEntities() {
        if (!this.isLoaded()) {
            return new Entity[0];
        }
        return this.whenLoaded(() -> this.world.getChunkAt(this.x, this.z).getEntities());
    }

    public BlockState[] getTileEntities() {
        if (!this.isLoaded()) {
            return new BlockState[0];
        }
        return TaskManager.IMP.sync(() -> this.world.getChunkAt(this.x, this.z).getTileEntities());
    }

    @NotNull
    public BlockState[] getTileEntities(boolean useSnapshot) {
        if (!this.isLoaded()) {
            return new BlockState[0];
        }
        return TaskManager.IMP.sync(() -> this.world.getChunkAt(this.x, this.z).getTileEntities(useSnapshot));
    }

    @NotNull
    public Collection<BlockState> getTileEntities(@NotNull Predicate<Block> blockPredicate, boolean useSnapshot) {
        if (!this.isLoaded()) {
            return Collections.emptyList();
        }
        return TaskManager.IMP.sync(() -> this.world.getChunkAt(this.x, this.z).getTileEntities(blockPredicate, useSnapshot));
    }

    public boolean isLoaded() {
        return this.world.isChunkLoaded(this.x, this.z);
    }

    public boolean load(boolean generate) {
        return TaskManager.IMP.sync(() -> this.world.loadChunk(this.x, this.z, generate));
    }

    public boolean load() {
        return this.load(false);
    }

    public boolean unload(boolean save) {
        return this.world.unloadChunk(this.x, this.z, save);
    }

    public boolean unload() {
        return this.unload(true);
    }

    public boolean isSlimeChunk() {
        return TaskManager.IMP.sync(() -> this.world.getChunkAt(this.x, this.z).isSlimeChunk());
    }

    public boolean isForceLoaded() {
        return this.world.isChunkForceLoaded(this.x, this.z);
    }

    public void setForceLoaded(boolean arg0) {
        this.world.getChunkAt(this.x, this.z).setForceLoaded(arg0);
    }

    public boolean addPluginChunkTicket(Plugin plugin) {
        return this.world.addPluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    public boolean removePluginChunkTicket(Plugin plugin) {
        return this.world.removePluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    public Collection<Plugin> getPluginChunkTickets() {
        return this.world.getPluginChunkTickets(this.getX(), this.getZ());
    }

    public long getInhabitedTime() {
        return TaskManager.IMP.sync(() -> this.world.getChunkAt(this.x, this.z).getInhabitedTime());
    }

    public void setInhabitedTime(long ticks) {
        this.world.getChunkAt(this.x, this.z).setInhabitedTime(ticks);
    }

    public boolean contains(@NotNull BlockData block) {
        return TaskManager.IMP.sync(() -> this.world.getChunkAt(this.x, this.z).contains(block));
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return TaskManager.IMP.sync(() -> this.world.getChunkAt(this.x, this.z).getPersistentDataContainer());
    }
}

