/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.wrapper;

import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.bukkit.wrapper.AsyncBlock;
import com.boydti.fawe.bukkit.wrapper.AsyncChunk;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.StringMan;
import com.boydti.fawe.util.TaskManager;
import com.destroystokyo.paper.HeightmapType;
import com.google.common.annotations.Beta;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.PassthroughExtent;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockState;
import io.papermc.paper.world.MoonPhase;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncWorld
extends PassthroughExtent
implements World {
    private World parent;
    private BukkitImplAdapter adapter;

    public <T> void spawnParticle(@NotNull Particle particle, double v, double v1, double v2, int i, double v3, double v4, double v5, double v6, T t) {
        this.parent.spawnParticle(particle, v, v1, v2, i, v3, v4, v5, v6, t);
    }

    @Deprecated
    public AsyncWorld(World parent, boolean autoQueue) {
        this(parent, FaweAPI.createQueue(new BukkitWorld(parent), autoQueue));
    }

    public AsyncWorld(String world, boolean autoQueue) {
        this(Bukkit.getWorld((String)world), autoQueue);
    }

    @Deprecated
    public AsyncWorld(World parent, Extent extent) {
        super(extent);
        this.parent = parent;
        this.adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
    }

    public static AsyncWorld wrap(World world) {
        if (world instanceof AsyncWorld) {
            return (AsyncWorld)world;
        }
        return new AsyncWorld(world, false);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public World getBukkitWorld() {
        return this.parent;
    }

    @Beta
    public static synchronized AsyncWorld create(WorldCreator creator) {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        @Nullable World world = adapter.createWorld(creator);
        return AsyncWorld.wrap(world);
    }

    @Override
    public Operation commit() {
        this.flush();
        return null;
    }

    public void flush() {
        this.getExtent().commit();
    }

    @NotNull
    public WorldBorder getWorldBorder() {
        return TaskManager.IMP.sync(() -> this.parent.getWorldBorder());
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int i) {
        this.parent.spawnParticle(particle, location, i);
    }

    public void spawnParticle(@NotNull Particle particle, double v, double v1, double v2, int i) {
        this.parent.spawnParticle(particle, v, v1, v2, i);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int i, T t) {
        this.parent.spawnParticle(particle, location, i, t);
    }

    public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, T data) {
        this.parent.spawnParticle(particle, x, y, z, count, data);
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.parent.spawnParticle(particle, location, count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(@NotNull Particle particle, double v, double v1, double v2, int i, double v3, double v4, double v5) {
        this.parent.spawnParticle(particle, v, v1, v2, i, v3, v4, v5);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int i, double v, double v1, double v2, T t) {
        this.parent.spawnParticle(particle, location, i, v, v1, v2, t);
    }

    public <T> void spawnParticle(@NotNull Particle particle, double v, double v1, double v2, int i, double v3, double v4, double v5, T t) {
        this.parent.spawnParticle(particle, v, v1, v2, i, v3, v4, v5, t);
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int i, double v, double v1, double v2, double v3) {
        this.parent.spawnParticle(particle, location, i, v, v1, v2, v3);
    }

    public void spawnParticle(@NotNull Particle particle, double v, double v1, double v2, int i, double v3, double v4, double v5, double v6) {
        this.parent.spawnParticle(particle, v, v1, v2, i, v3, v4, v5, v6);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int i, double v, double v1, double v2, double v3, T t) {
        this.parent.spawnParticle(particle, location, i, v, v1, v2, v3, t);
    }

    public boolean setSpawnLocation(@NotNull Location location) {
        return this.parent.setSpawnLocation(location);
    }

    @NotNull
    public AsyncBlock getBlockAt(int x, int y, int z) {
        return new AsyncBlock(this, x, y, z);
    }

    @NotNull
    public AsyncBlock getBlockAt(Location loc) {
        return this.getBlockAt(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public int getHighestBlockYAt(int x, int z) {
        for (int y = this.getMaxHeight() - 1; y >= 0; --y) {
            BlockState state = this.getBlock(x, y, z);
            if (state.getMaterial().isAir()) continue;
            return y;
        }
        return 0;
    }

    public int getHighestBlockYAt(Location loc) {
        return this.getHighestBlockYAt(loc.getBlockX(), loc.getBlockZ());
    }

    @NotNull
    public AsyncBlock getHighestBlockAt(int x, int z) {
        int y = this.getHighestBlockYAt(x, z);
        return this.getBlockAt(x, y, z);
    }

    @NotNull
    public AsyncBlock getHighestBlockAt(Location loc) {
        return this.getHighestBlockAt(loc.getBlockX(), loc.getBlockZ());
    }

    public int getHighestBlockYAt(int i, int i1, @NotNull HeightMap heightMap) {
        return this.parent.getHighestBlockYAt(i, i1, heightMap);
    }

    public int getHighestBlockYAt(@NotNull Location location, @NotNull HeightMap heightMap) {
        return this.parent.getHighestBlockYAt(location, heightMap);
    }

    @NotNull
    public Block getHighestBlockAt(int i, int i1, @NotNull HeightMap heightMap) {
        return this.parent.getHighestBlockAt(i, i1, heightMap);
    }

    @NotNull
    public Block getHighestBlockAt(@NotNull Location location, @NotNull HeightMap heightMap) {
        return this.parent.getHighestBlockAt(location, heightMap);
    }

    @NotNull
    public AsyncChunk getChunkAt(int x, int z) {
        return new AsyncChunk(this, x, z);
    }

    @NotNull
    public AsyncChunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX(), location.getBlockZ());
    }

    @NotNull
    public AsyncChunk getChunkAt(Block block) {
        return this.getChunkAt(block.getX(), block.getZ());
    }

    public boolean isChunkGenerated(int x, int z) {
        return this.parent.isChunkGenerated(x, z);
    }

    public boolean isChunkLoaded(Chunk chunk) {
        return chunk.isLoaded();
    }

    @NotNull
    public Chunk[] getLoadedChunks() {
        return this.parent.getLoadedChunks();
    }

    public void loadChunk(final Chunk chunk) {
        if (!chunk.isLoaded()) {
            TaskManager.IMP.sync(new RunnableVal<Object>(){

                @Override
                public void run(Object value) {
                    AsyncWorld.this.parent.loadChunk(chunk);
                }
            });
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof World)) {
            return false;
        }
        World other = (World)obj;
        return StringMan.isEqual(other.getName(), this.getName());
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.parent.isChunkLoaded(x, z);
    }

    @Deprecated
    public boolean isChunkInUse(int x, int z) {
        return this.parent.isChunkInUse(x, z);
    }

    public void loadChunk(final int x, final int z) {
        if (!this.isChunkLoaded(x, z)) {
            TaskManager.IMP.sync(new RunnableVal<Object>(){

                @Override
                public void run(Object value) {
                    AsyncWorld.this.parent.loadChunk(x, z);
                }
            });
        }
    }

    public boolean loadChunk(int x, int z, boolean generate) {
        if (!this.isChunkLoaded(x, z)) {
            return TaskManager.IMP.sync(() -> this.parent.loadChunk(x, z, generate));
        }
        return true;
    }

    public boolean unloadChunk(Chunk chunk) {
        if (chunk.isLoaded()) {
            return TaskManager.IMP.sync(() -> this.parent.unloadChunk(chunk));
        }
        return true;
    }

    public boolean unloadChunk(int x, int z) {
        return this.unloadChunk(x, z, true);
    }

    public boolean unloadChunk(int x, int z, boolean save) {
        if (this.isChunkLoaded(x, z)) {
            return TaskManager.IMP.sync(() -> this.parent.unloadChunk(x, z, save));
        }
        return true;
    }

    public boolean unloadChunkRequest(int x, int z) {
        if (this.isChunkLoaded(x, z)) {
            return TaskManager.IMP.sync(() -> this.parent.unloadChunkRequest(x, z));
        }
        return true;
    }

    @Deprecated
    public boolean regenerateChunk(int x, int z) {
        return TaskManager.IMP.sync(() -> this.parent.regenerateChunk(x, z));
    }

    @Deprecated
    public boolean refreshChunk(int x, int z) {
        return this.parent.refreshChunk(x, z);
    }

    @NotNull
    public Item dropItem(@NotNull Location location, @NotNull ItemStack item) {
        return TaskManager.IMP.sync(() -> this.parent.dropItem(location, item));
    }

    @NotNull
    public Item dropItemNaturally(@NotNull Location location, @NotNull ItemStack item) {
        return TaskManager.IMP.sync(() -> this.parent.dropItemNaturally(location, item));
    }

    @NotNull
    public Arrow spawnArrow(@NotNull Location location, @NotNull Vector direction, float speed, float spread) {
        return TaskManager.IMP.sync(() -> this.parent.spawnArrow(location, direction, speed, spread));
    }

    @NotNull
    public <T extends AbstractArrow> T spawnArrow(@NotNull Location location, @NotNull Vector direction, float speed, float spread, @NotNull Class<T> clazz) {
        return (T)this.parent.spawnArrow(location, direction, speed, spread, clazz);
    }

    public boolean generateTree(@NotNull Location location, @NotNull TreeType type) {
        return TaskManager.IMP.sync(() -> this.parent.generateTree(location, type));
    }

    public boolean generateTree(@NotNull Location loc, @NotNull TreeType type, @NotNull BlockChangeDelegate delegate) {
        return TaskManager.IMP.sync(() -> this.parent.generateTree(loc, type, delegate));
    }

    @NotNull
    public Entity spawnEntity(@NotNull Location loc, EntityType type) {
        return this.spawn(loc, type.getEntityClass());
    }

    @NotNull
    public LightningStrike strikeLightning(@NotNull Location loc) {
        return TaskManager.IMP.sync(() -> this.parent.strikeLightning(loc));
    }

    @NotNull
    public LightningStrike strikeLightningEffect(@NotNull Location loc) {
        return TaskManager.IMP.sync(() -> this.parent.strikeLightningEffect(loc));
    }

    @NotNull
    public List getEntities() {
        return TaskManager.IMP.sync(() -> this.parent.getEntities());
    }

    @NotNull
    public List<LivingEntity> getLivingEntities() {
        return TaskManager.IMP.sync(() -> this.parent.getLivingEntities());
    }

    @Deprecated
    @NotNull
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        return TaskManager.IMP.sync(() -> this.parent.getEntitiesByClass(classes));
    }

    @NotNull
    public <T extends Entity> Collection<T> getEntitiesByClass(@NotNull Class<T> cls) {
        return TaskManager.IMP.sync(() -> this.parent.getEntitiesByClass(cls));
    }

    @NotNull
    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        return TaskManager.IMP.sync(() -> this.parent.getEntitiesByClasses(classes));
    }

    @NotNull
    public List<Player> getPlayers() {
        return TaskManager.IMP.sync(() -> this.parent.getPlayers());
    }

    @NotNull
    public Collection<Entity> getNearbyEntities(@NotNull Location location, double x, double y, double z) {
        return TaskManager.IMP.sync(() -> this.parent.getNearbyEntities(location, x, y, z));
    }

    @NotNull
    public String getName() {
        return this.parent.getName();
    }

    @NotNull
    public UUID getUID() {
        return this.parent.getUID();
    }

    @NotNull
    public Location getSpawnLocation() {
        return this.parent.getSpawnLocation();
    }

    public boolean setSpawnLocation(int x, int y, int z) {
        return TaskManager.IMP.sync(() -> this.parent.setSpawnLocation(x, y, z));
    }

    public boolean setSpawnLocation(int x, int y, int z, float angle) {
        return TaskManager.IMP.sync(() -> this.parent.setSpawnLocation(x, y, z, angle));
    }

    @NotNull
    public MoonPhase getMoonPhase() {
        return this.parent.getMoonPhase();
    }

    public long getTime() {
        return this.parent.getTime();
    }

    public void setTime(long time) {
        this.parent.setTime(time);
    }

    public long getFullTime() {
        return this.parent.getFullTime();
    }

    public void setFullTime(long time) {
        this.parent.setFullTime(time);
    }

    public boolean hasStorm() {
        return this.parent.hasStorm();
    }

    public void setStorm(boolean hasStorm) {
        this.parent.setStorm(hasStorm);
    }

    public int getWeatherDuration() {
        return this.parent.getWeatherDuration();
    }

    public void setWeatherDuration(int duration) {
        this.parent.setWeatherDuration(duration);
    }

    public boolean isThundering() {
        return this.parent.isThundering();
    }

    public void setThundering(boolean thundering) {
        this.parent.setThundering(thundering);
    }

    public int getThunderDuration() {
        return this.parent.getThunderDuration();
    }

    public void setThunderDuration(int duration) {
        this.parent.setThunderDuration(duration);
    }

    public boolean isClearWeather() {
        return this.parent.isClearWeather();
    }

    public void setClearWeatherDuration(int duration) {
        this.parent.setClearWeatherDuration(duration);
    }

    public int getClearWeatherDuration() {
        return this.parent.getClearWeatherDuration();
    }

    public boolean createExplosion(double x, double y, double z, float power) {
        return this.createExplosion(x, y, z, power, false, true);
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire) {
        return this.createExplosion(x, y, z, power, setFire, true);
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        return TaskManager.IMP.sync(() -> this.parent.createExplosion(x, y, z, power, setFire, breakBlocks));
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks, @Nullable Entity source) {
        return TaskManager.IMP.sync(() -> this.parent.createExplosion(x, y, z, power, setFire, breakBlocks, source));
    }

    public boolean createExplosion(@NotNull Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire) {
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire);
    }

    @NotNull
    public World.Environment getEnvironment() {
        return this.parent.getEnvironment();
    }

    public long getSeed() {
        return this.parent.getSeed();
    }

    public boolean getPVP() {
        return this.parent.getPVP();
    }

    public void setPVP(boolean pvp) {
        this.parent.setPVP(pvp);
    }

    public ChunkGenerator getGenerator() {
        return this.parent.getGenerator();
    }

    public void save() {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.save();
            }
        });
    }

    @NotNull
    public List<BlockPopulator> getPopulators() {
        return this.parent.getPopulators();
    }

    @NotNull
    public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz) throws IllegalArgumentException {
        return (T)TaskManager.IMP.sync(() -> this.parent.spawn(location, clazz));
    }

    @NotNull
    public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, Consumer<T> function) throws IllegalArgumentException {
        return (T)TaskManager.IMP.sync(() -> this.parent.spawn(location, clazz, function));
    }

    @NotNull
    public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @Nullable Consumer<T> function, @NotNull CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return (T)TaskManager.IMP.sync(() -> this.parent.spawn(location, clazz, function, reason));
    }

    @NotNull
    public FallingBlock spawnFallingBlock(@NotNull Location location, @NotNull MaterialData data) throws IllegalArgumentException {
        return TaskManager.IMP.sync(() -> this.parent.spawnFallingBlock(location, data));
    }

    @Deprecated
    @NotNull
    public FallingBlock spawnFallingBlock(@NotNull Location location, @NotNull Material material, byte data) throws IllegalArgumentException {
        return TaskManager.IMP.sync(() -> this.parent.spawnFallingBlock(location, material, data));
    }

    @NotNull
    public FallingBlock spawnFallingBlock(@NotNull Location location, @NotNull BlockData blockData) throws IllegalArgumentException {
        return TaskManager.IMP.sync(() -> this.parent.spawnFallingBlock(location, blockData));
    }

    public void playEffect(@NotNull Location location, @NotNull Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    public void playEffect(final @NotNull Location location, final @NotNull Effect effect, final int data, final int radius) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.playEffect(location, effect, data, radius);
            }
        });
    }

    public <T> void playEffect(@NotNull Location loc, @NotNull Effect effect, T data) {
        this.playEffect(loc, effect, data, 64);
    }

    public <T> void playEffect(final @NotNull Location location, final @NotNull Effect effect, final T data, final int radius) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.playEffect(location, effect, data, radius);
            }
        });
    }

    @NotNull
    public ChunkSnapshot getEmptyChunkSnapshot(int x, int z, boolean includeBiome, boolean includeBiomeTempRain) {
        return TaskManager.IMP.sync(() -> this.parent.getEmptyChunkSnapshot(x, z, includeBiome, includeBiomeTempRain));
    }

    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.parent.setSpawnFlags(allowMonsters, allowAnimals);
    }

    public boolean getAllowAnimals() {
        return this.parent.getAllowAnimals();
    }

    public boolean getAllowMonsters() {
        return this.parent.getAllowMonsters();
    }

    @NotNull
    public Biome getBiome(int x, int z) {
        return this.adapter.adapt(this.getExtent().getBiomeType(x, 0, z));
    }

    @NotNull
    public Biome getBiome(int x, int y, int z) {
        return this.adapter.adapt(this.getExtent().getBiomeType(x, y, z));
    }

    public void setBiome(int x, int z, @NotNull Biome bio) {
        BiomeType biome = this.adapter.adapt(bio);
        this.getExtent().setBiome(x, 0, z, biome);
    }

    public void setBiome(int x, int y, int z, @NotNull Biome bio) {
        BiomeType biome = this.adapter.adapt(bio);
        this.getExtent().setBiome(x, y, z, biome);
    }

    @Deprecated
    public double getTemperature(int x, int z) {
        return this.parent.getTemperature(x, z);
    }

    public double getTemperature(int x, int y, int z) {
        return this.parent.getTemperature(x, y, z);
    }

    @Deprecated
    public double getHumidity(int x, int z) {
        return this.parent.getHumidity(x, z);
    }

    public double getHumidity(int x, int y, int z) {
        return this.parent.getHumidity(x, y, z);
    }

    public int getMaxHeight() {
        return this.parent.getMaxHeight();
    }

    public int getSeaLevel() {
        return this.parent.getSeaLevel();
    }

    public boolean getKeepSpawnInMemory() {
        return this.parent.getKeepSpawnInMemory();
    }

    public void setKeepSpawnInMemory(final boolean keepLoaded) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.setKeepSpawnInMemory(keepLoaded);
            }
        });
    }

    public boolean isAutoSave() {
        return this.parent.isAutoSave();
    }

    public void setAutoSave(boolean value) {
        this.parent.setAutoSave(value);
    }

    public void setDifficulty(@NotNull Difficulty difficulty) {
        this.parent.setDifficulty(difficulty);
    }

    @NotNull
    public Difficulty getDifficulty() {
        return this.parent.getDifficulty();
    }

    @NotNull
    public File getWorldFolder() {
        return this.parent.getWorldFolder();
    }

    @Deprecated
    public WorldType getWorldType() {
        return this.parent.getWorldType();
    }

    public boolean canGenerateStructures() {
        return this.parent.canGenerateStructures();
    }

    public void setHardcore(boolean hardcore) {
        this.parent.setHardcore(hardcore);
    }

    public boolean isHardcore() {
        return this.parent.isHardcore();
    }

    public long getTicksPerAnimalSpawns() {
        return this.parent.getTicksPerAnimalSpawns();
    }

    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.parent.setTicksPerAnimalSpawns(ticksPerAnimalSpawns);
    }

    public long getTicksPerMonsterSpawns() {
        return this.parent.getTicksPerMonsterSpawns();
    }

    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.parent.setTicksPerMonsterSpawns(ticksPerMonsterSpawns);
    }

    public int getMonsterSpawnLimit() {
        return this.parent.getMonsterSpawnLimit();
    }

    public void setMonsterSpawnLimit(int limit) {
        this.parent.setMonsterSpawnLimit(limit);
    }

    public int getAnimalSpawnLimit() {
        return this.parent.getAnimalSpawnLimit();
    }

    public void setAnimalSpawnLimit(int limit) {
        this.parent.setAnimalSpawnLimit(limit);
    }

    public int getWaterAnimalSpawnLimit() {
        return this.parent.getWaterAnimalSpawnLimit();
    }

    public void setWaterAnimalSpawnLimit(int limit) {
        this.parent.setWaterAnimalSpawnLimit(limit);
    }

    public int getWaterAmbientSpawnLimit() {
        return this.parent.getWaterAmbientSpawnLimit();
    }

    public void setWaterAmbientSpawnLimit(int limit) {
        this.parent.setWaterAmbientSpawnLimit(limit);
    }

    public int getAmbientSpawnLimit() {
        return this.parent.getAmbientSpawnLimit();
    }

    public void setAmbientSpawnLimit(int limit) {
        this.parent.setAmbientSpawnLimit(limit);
    }

    public void playSound(final @NotNull Location location, final @NotNull Sound sound, final float volume, final float pitch) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.playSound(location, sound, volume, pitch);
            }
        });
    }

    public void playSound(final @NotNull Location location, final @NotNull String sound, final float volume, final float pitch) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.playSound(location, sound, volume, pitch);
            }
        });
    }

    public void playSound(final @NotNull Location location, final @NotNull Sound sound, final @NotNull SoundCategory category, final float volume, final float pitch) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.playSound(location, sound, category, volume, pitch);
            }
        });
    }

    public void playSound(final @NotNull Location location, final @NotNull String sound, final @NotNull SoundCategory category, final float volume, final float pitch) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.playSound(location, sound, category, volume, pitch);
            }
        });
    }

    @NotNull
    public String[] getGameRules() {
        return this.parent.getGameRules();
    }

    @Deprecated
    public String getGameRuleValue(String rule) {
        return this.parent.getGameRuleValue(rule);
    }

    @Deprecated
    public boolean setGameRuleValue(@NotNull String rule, @NotNull String value) {
        return this.parent.setGameRuleValue(rule, value);
    }

    public boolean isGameRule(@NotNull String rule) {
        return this.parent.isGameRule(rule);
    }

    @Deprecated
    public <T> T getGameRuleValue(@NotNull GameRule<T> gameRule) {
        return (T)this.parent.getGameRuleValue(gameRule);
    }

    public <T> T getGameRuleDefault(@NotNull GameRule<T> gameRule) {
        return (T)this.parent.getGameRuleDefault(gameRule);
    }

    public <T> boolean setGameRule(@NotNull GameRule<T> gameRule, @NotNull T t) {
        return this.parent.setGameRule(gameRule, t);
    }

    @NotNull
    public World.Spigot spigot() {
        return this.parent.spigot();
    }

    @Nullable
    public Raid locateNearestRaid(@NotNull Location location, int i) {
        return this.parent.locateNearestRaid(location, i);
    }

    @NotNull
    public List<Raid> getRaids() {
        return this.parent.getRaids();
    }

    public void setMetadata(final @NotNull String key, final @NotNull MetadataValue meta) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.setMetadata(key, meta);
            }
        });
    }

    @NotNull
    public List<MetadataValue> getMetadata(@NotNull String key) {
        return this.parent.getMetadata(key);
    }

    public boolean hasMetadata(@NotNull String key) {
        return this.parent.hasMetadata(key);
    }

    public void removeMetadata(final @NotNull String key, final @NotNull Plugin plugin) {
        TaskManager.IMP.sync(new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                AsyncWorld.this.parent.removeMetadata(key, plugin);
            }
        });
    }

    public void sendPluginMessage(@NotNull Plugin source, @NotNull String channel, @NotNull byte[] message) {
        this.parent.sendPluginMessage(source, channel, message);
    }

    @NotNull
    public Set<String> getListeningPluginChannels() {
        return this.parent.getListeningPluginChannels();
    }

    public BukkitImplAdapter getAdapter() {
        return this.adapter;
    }

    @NotNull
    public Collection<Entity> getNearbyEntities(@NotNull BoundingBox arg0) {
        return this.parent.getNearbyEntities(arg0);
    }

    @NotNull
    public Collection<Entity> getNearbyEntities(@NotNull BoundingBox arg0, Predicate<Entity> arg1) {
        return this.parent.getNearbyEntities(arg0, arg1);
    }

    @NotNull
    public Collection<Entity> getNearbyEntities(@NotNull Location arg0, double arg1, double arg2, double arg3, Predicate<Entity> arg4) {
        return this.parent.getNearbyEntities(arg0, arg1, arg2, arg3, arg4);
    }

    public boolean isChunkForceLoaded(int arg0, int arg1) {
        return this.parent.isChunkForceLoaded(arg0, arg1);
    }

    public Location locateNearestStructure(@NotNull Location arg0, @NotNull StructureType arg1, int arg2, boolean arg3) {
        return this.parent.locateNearestStructure(arg0, arg1, arg2, arg3);
    }

    public int getViewDistance() {
        return this.parent.getViewDistance();
    }

    public void setViewDistance(int viewDistance) {
    }

    public int getNoTickViewDistance() {
        return 0;
    }

    public void setNoTickViewDistance(int viewDistance) {
    }

    public RayTraceResult rayTrace(@NotNull Location arg0, @NotNull Vector arg1, double arg2, @NotNull FluidCollisionMode arg3, boolean arg4, double arg5, Predicate<Entity> arg6) {
        return this.parent.rayTrace(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public RayTraceResult rayTraceBlocks(@NotNull Location arg0, @NotNull Vector arg1, double arg2) {
        return this.parent.rayTraceBlocks(arg0, arg1, arg2);
    }

    public RayTraceResult rayTraceBlocks(@NotNull Location start, @NotNull Vector direction, double maxDistance, @NotNull FluidCollisionMode fluidCollisionMode) {
        return this.parent.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode);
    }

    public RayTraceResult rayTraceBlocks(@NotNull Location start, @NotNull Vector direction, double arg2, @NotNull FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        return this.parent.rayTraceBlocks(start, direction, arg2, fluidCollisionMode, ignorePassableBlocks);
    }

    public RayTraceResult rayTraceEntities(@NotNull Location start, @NotNull Vector direction, double maxDistance) {
        return this.parent.rayTraceEntities(start, direction, maxDistance);
    }

    public RayTraceResult rayTraceEntities(@NotNull Location arg0, @NotNull Vector arg1, double arg2, double arg3) {
        return this.parent.rayTraceEntities(arg0, arg1, arg2, arg3);
    }

    public RayTraceResult rayTraceEntities(@NotNull Location arg0, @NotNull Vector arg1, double arg2, Predicate<Entity> arg3) {
        return this.parent.rayTraceEntities(arg0, arg1, arg2, arg3);
    }

    public RayTraceResult rayTraceEntities(@NotNull Location arg0, @NotNull Vector arg1, double arg2, double arg3, Predicate<Entity> arg4) {
        return this.parent.rayTraceEntities(arg0, arg1, arg2, arg3, arg4);
    }

    public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data, boolean force) {
    }

    public void setChunkForceLoaded(int x, int z, boolean forced) {
        this.parent.setChunkForceLoaded(x, z, forced);
    }

    @NotNull
    public Collection<Chunk> getForceLoadedChunks() {
        return this.parent.getForceLoadedChunks();
    }

    public boolean addPluginChunkTicket(int x, int z, @NotNull Plugin plugin) {
        return this.getBukkitWorld().addPluginChunkTicket(x, z, plugin);
    }

    public boolean removePluginChunkTicket(int x, int z, @NotNull Plugin plugin) {
        return this.getBukkitWorld().removePluginChunkTicket(x, z, plugin);
    }

    public void removePluginChunkTickets(@NotNull Plugin plugin) {
        this.getBukkitWorld().removePluginChunkTickets(plugin);
    }

    @NotNull
    public Collection<Plugin> getPluginChunkTickets(int x, int z) {
        return this.getBukkitWorld().getPluginChunkTickets(x, z);
    }

    @NotNull
    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        return this.getBukkitWorld().getPluginChunkTickets();
    }

    @Deprecated
    public int getHighestBlockYAt(int x, int z, @NotNull HeightmapType heightmap) throws UnsupportedOperationException {
        return TaskManager.IMP.sync(() -> this.parent.getHighestBlockYAt(x, z, heightmap));
    }

    public int getEntityCount() {
        return TaskManager.IMP.sync(() -> this.parent.getEntityCount());
    }

    public int getTileEntityCount() {
        return TaskManager.IMP.sync(() -> this.parent.getTileEntityCount());
    }

    public int getTickableTileEntityCount() {
        return TaskManager.IMP.sync(() -> this.parent.getTickableTileEntityCount());
    }

    public int getChunkCount() {
        return TaskManager.IMP.sync(() -> this.parent.getChunkCount());
    }

    public int getPlayerCount() {
        return TaskManager.IMP.sync(() -> this.parent.getPlayerCount());
    }

    @NotNull
    public CompletableFuture<Chunk> getChunkAtAsync(int x, int z, boolean gen) {
        return this.parent.getChunkAtAsync(x, z, gen);
    }

    @NotNull
    public CompletableFuture<Chunk> getChunkAtAsync(int x, int z, boolean gen, boolean urgent) {
        return this.parent.getChunkAtAsync(x, z, gen, urgent);
    }

    public boolean isDayTime() {
        return this.parent.isDayTime();
    }

    @Deprecated
    public void getChunkAtAsync(int x, int z, @NotNull World.ChunkLoadCallback cb) {
        this.parent.getChunkAtAsync(x, z, cb);
    }

    @Deprecated
    public void getChunkAtAsync(@NotNull Location location, @NotNull World.ChunkLoadCallback cb) {
        this.parent.getChunkAtAsync(location, cb);
    }

    @Deprecated
    public void getChunkAtAsync(@NotNull Block block, @NotNull World.ChunkLoadCallback cb) {
        this.parent.getChunkAtAsync(block, cb);
    }

    public Entity getEntity(@NotNull UUID uuid) {
        return TaskManager.IMP.sync(() -> this.parent.getEntity(uuid));
    }

    @Nullable
    public DragonBattle getEnderDragonBattle() {
        return TaskManager.IMP.sync(() -> this.parent.getEnderDragonBattle());
    }

    public boolean createExplosion(Entity source, @NotNull Location loc, float power, boolean setFire, boolean breakBlocks) {
        return TaskManager.IMP.sync(() -> this.parent.createExplosion(source, loc, power, setFire, breakBlocks));
    }

    public boolean createExplosion(@NotNull Location loc, float power, boolean setFire, boolean breakBlocks) {
        return false;
    }

    public boolean createExplosion(@NotNull Location loc, float power, boolean setFire, boolean breakBlocks, @Nullable Entity source) {
        return false;
    }

    public <T> void spawnParticle(@NotNull Particle particle, List<Player> receivers, @NotNull Player source, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.parent.spawnParticle(particle, receivers, source, x, y, z, count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(@NotNull Particle particle, List<Player> list, Player player, double v, double v1, double v2, int i, double v3, double v4, double v5, double v6, T t, boolean b) {
        this.parent.spawnParticle(particle, list, player, v, v1, v2, i, v3, v4, v5, v6, t, b);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data, boolean force) {
        this.parent.spawnParticle(particle, location, count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    @Deprecated
    public int getHighestBlockYAt(@NotNull Location location, @NotNull HeightmapType heightmap) throws UnsupportedOperationException {
        return this.parent.getHighestBlockYAt(location, heightmap);
    }

    @Deprecated
    @NotNull
    public Block getHighestBlockAt(int x, int z, @NotNull HeightmapType heightmap) throws UnsupportedOperationException {
        return this.parent.getHighestBlockAt(x, z, heightmap);
    }

    @Deprecated
    @NotNull
    public Block getHighestBlockAt(@NotNull Location location, @NotNull HeightmapType heightmap) throws UnsupportedOperationException {
        return this.parent.getHighestBlockAt(location, heightmap);
    }

    public long getTicksPerWaterSpawns() {
        return this.parent.getTicksPerWaterSpawns();
    }

    public void setTicksPerWaterSpawns(int ticksPerWaterSpawns) {
        this.parent.setTicksPerWaterSpawns(ticksPerWaterSpawns);
    }

    public long getTicksPerWaterAmbientSpawns() {
        return this.parent.getTicksPerWaterAmbientSpawns();
    }

    public void setTicksPerWaterAmbientSpawns(int ticksPerAmbientSpawns) {
        this.parent.setTicksPerWaterAmbientSpawns(ticksPerAmbientSpawns);
    }

    public long getTicksPerAmbientSpawns() {
        return this.parent.getTicksPerAmbientSpawns();
    }

    public void setTicksPerAmbientSpawns(int ticksPerAmbientSpawns) {
        this.parent.setTicksPerAmbientSpawns(ticksPerAmbientSpawns);
    }
}

