/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.wrapper.state;

import com.boydti.fawe.FaweCache;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public final class AsyncDataContainer
implements PersistentDataContainer {
    private final Supplier<CompoundTag> supplier;
    private final Consumer<CompoundTag> consumer;

    public AsyncDataContainer(@NotNull Supplier<CompoundTag> supplier, @NotNull Consumer<CompoundTag> consumer) {
        this.supplier = supplier;
        this.consumer = consumer;
    }

    private CompoundTag root() {
        return (CompoundTag)this.supplier.get().getValue().get("PublicBukkitValues");
    }

    private Map<String, Tag> get() {
        return this.get(true);
    }

    private Map<String, Tag> get(boolean create) {
        HashMap<String, Tag> raw;
        CompoundTag tag = this.root();
        if (tag == null) {
            if (!create) {
                return Collections.emptyMap();
            }
            HashMap<String, Tag> map = new HashMap<String, Tag>((Map<String, Tag>)this.root().getValue());
            raw = new HashMap<String, Tag>();
            map.put("PublicBukkitValues", new CompoundTag(raw));
            this.consumer.accept(new CompoundTag(map));
        } else {
            raw = tag.getValue();
        }
        return raw;
    }

    public <T, Z> void set(NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null");
        Validate.notNull(type, (String)"The provided type for the custom value was null");
        Validate.notNull(value, (String)"The provided value for the custom value was null");
        HashMap<String, Tag> publicValues = new HashMap<String, Tag>(this.get());
        publicValues.put(key.toString(), FaweCache.IMP.asTag(type.toPrimitive(value, null)));
        HashMap<String, Tag> map = new HashMap<String, Tag>((Map<String, Tag>)this.root().getValue());
        map.put("PublicBukkitValues", new CompoundTag(publicValues));
        this.consumer.accept(new CompoundTag(map));
    }

    public <T, Z> boolean has(NamespacedKey key, PersistentDataType<T, Z> type) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null");
        Validate.notNull(type, (String)"The provided type for the custom value was null");
        Tag value = this.get(false).get(key.toString());
        if (value == null) {
            return false;
        }
        return type.getPrimitiveType() == value.getValue().getClass();
    }

    public <T, Z> Z get(NamespacedKey key, PersistentDataType<T, Z> type) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null");
        Validate.notNull(type, (String)"The provided type for the custom value was null");
        Tag value = this.get(false).get(key.toString());
        return (Z)value.toRaw();
    }

    public <T, Z> Z getOrDefault(NamespacedKey key, PersistentDataType<T, Z> type, Z defaultValue) {
        Z z = this.get(key, type);
        return z != null ? z : defaultValue;
    }

    @NotNull
    public Set<NamespacedKey> getKeys() {
        HashSet<NamespacedKey> keys = new HashSet<NamespacedKey>();
        this.get(false).keySet().forEach(key -> {
            String[] keyData = key.split(":", 2);
            if (keyData.length == 2) {
                keys.add(new NamespacedKey(keyData[0], keyData[1]));
            }
        });
        return keys;
    }

    public void remove(NamespacedKey key) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null");
        HashMap<String, Tag> publicValues = new HashMap<String, Tag>(this.get(false));
        publicValues.remove(key.toString());
        HashMap<String, Tag> map = new HashMap<String, Tag>((Map<String, Tag>)this.root().getValue());
        map.put("PublicBukkitValues", new CompoundTag(publicValues));
        this.consumer.accept(new CompoundTag(map));
    }

    public boolean isEmpty() {
        return this.get(false).isEmpty();
    }

    public PersistentDataAdapterContext getAdapterContext() {
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AsyncDataContainer)) {
            return false;
        }
        Map<String, Tag> myRawMap = this.getRaw();
        Map<String, Tag> theirRawMap = ((AsyncDataContainer)obj).getRaw();
        return Objects.equals(myRawMap, theirRawMap);
    }

    public Map<String, Tag> getRaw() {
        return this.get(false);
    }

    public int hashCode() {
        return this.get(false).hashCode();
    }

    public Map<String, Object> serialize() {
        return new CompoundTag(this.get(false)).toRaw();
    }
}

