/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.wrapper.state;

import com.boydti.fawe.bukkit.wrapper.AsyncBlock;
import com.boydti.fawe.bukkit.wrapper.AsyncBlockState;
import com.boydti.fawe.bukkit.wrapper.state.AsyncDataContainer;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.serializer.gson.GsonComponentSerializer;
import com.sk89q.worldedit.util.formatting.text.serializer.legacy.LegacyComponentSerializer;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.Locale;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.block.Sign;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncSign
extends AsyncBlockState
implements Sign {
    private boolean isEditable = false;

    public AsyncSign(AsyncBlock block, BaseBlock state) {
        super(block, state);
    }

    public String[] getLines() {
        CompoundTag nbt = this.getNbtData();
        String[] data = new String[4];
        if (nbt != null) {
            for (int i = 1; i <= 4; ++i) {
                data[i - 1] = this.fromJson(nbt.getString("Text" + i));
            }
        }
        return data;
    }

    private String fromJson(String jsonInput) {
        if (jsonInput == null || jsonInput.isEmpty()) {
            return "";
        }
        return GsonComponentSerializer.INSTANCE.deserialize(jsonInput).toString();
    }

    private String toJson(String oldInput) {
        if (oldInput == null || oldInput.isEmpty()) {
            return "";
        }
        return LegacyComponentSerializer.INSTANCE.serialize(TextComponent.of(oldInput));
    }

    public String getLine(int index) throws IndexOutOfBoundsException {
        CompoundTag nbt = this.getNbtData();
        return nbt == null ? "" : this.fromJson(nbt.getString("Text" + (index + 1)));
    }

    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        Map<String, Tag> map = this.cloneNbtMap();
        if (map.isEmpty()) {
            return;
        }
        map.put("Text" + (index + 1), new StringTag(this.toJson(line)));
        this.setNbtData(map);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean arg0) {
        this.isEditable = arg0;
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return new AsyncDataContainer(this::getNbtData, this::setNbtData);
    }

    @Nullable
    public DyeColor getColor() {
        String color;
        CompoundTag nbt = this.getNbtData();
        if (nbt != null && !(color = nbt.getString("Color").toUpperCase(Locale.ROOT)).isEmpty()) {
            return DyeColor.valueOf((String)color);
        }
        return DyeColor.BLACK;
    }

    public void setColor(DyeColor color) {
        Map<String, Tag> map = this.cloneNbtMap();
        if (map.isEmpty()) {
            return;
        }
        map.put("Color", new StringTag(color.name().toLowerCase(Locale.ROOT)));
        this.setNbtData(map);
    }
}

