/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.database;

import com.boydti.fawe.config.Config;
import com.boydti.fawe.database.RollbackDatabase;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.world.World;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DBHandler {
    private final Logger log = LoggerFactory.getLogger(Config.class);
    public static final DBHandler IMP = new DBHandler();
    private Map<World, RollbackDatabase> databases = new ConcurrentHashMap<World, RollbackDatabase>(8, 0.9f, 1);

    public RollbackDatabase getDatabase(World world) {
        RollbackDatabase database = this.databases.get(world);
        if (database != null) {
            return database;
        }
        try {
            database = new RollbackDatabase(world);
            this.databases.put(world, database);
            return database;
        }
        catch (Throwable e) {
            this.log.error("No JDBC driver found!", e);
            return null;
        }
    }
}

