/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.database;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.logging.rollback.RollbackOptimizedHistory;
import com.boydti.fawe.object.collection.YieldIterable;
import com.boydti.fawe.object.task.AsyncNotifyQueue;
import com.boydti.fawe.util.MainUtil;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class RollbackDatabase
extends AsyncNotifyQueue {
    private static final Logger log = LoggerFactory.getLogger(RollbackDatabase.class);
    private final String prefix;
    private final File dbLocation;
    private final World world;
    private Connection connection;
    @Language(value="SQLite")
    private String createTable = "CREATE TABLE IF NOT EXISTS `{0}edits` (`player` BLOB(16) NOT NULL,`id` INT NOT NULL, `time` INT NOT NULL,`x1` INT NOT NULL,`x2` INT NOT NULL,`z1` INT NOT NULL,`z2` INT NOT NULL,`y1` INT NOT NULL, `y2` INT NOT NULL, `size` INT NOT NULL, `command` VARCHAR, PRIMARY KEY (player, id))";
    @Language(value="SQLite")
    private String updateTable1 = "ALTER TABLE `{0}edits` ADD COLUMN `command` VARCHAR";
    @Language(value="SQLite")
    private String updateTable2 = "alter table `{0}edits` add size int default 0 not null";
    @Language(value="SQLite")
    private String insertEdit = "INSERT OR REPLACE INTO `{0}edits` (`player`,`id`,`time`,`x1`,`x2`,`z1`,`z2`,`y1`,`y2`,`command`,`size`) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
    @Language(value="SQLite")
    private String purge = "DELETE FROM `{0}edits` WHERE `time`<?";
    @Language(value="SQLite")
    private String getEditsUser = "SELECT * FROM `{0}edits` WHERE `time`>? AND `x2`>=? AND `x1`<=? AND `z2`>=? AND `z1`<=? AND `y2`>=? AND `y1`<=? AND `player`=? ORDER BY `time` DESC, `id` DESC";
    @Language(value="SQLite")
    private String getEditsUserAsc = "SELECT * FROM `{0}edits` WHERE `time`>? AND `x2`>=? AND `x1`<=? AND `z2`>=? AND `z1`<=? AND `y2`>=? AND `y1`<=? AND `player`=? ORDER BY `time` ASC, `id` ASC";
    @Language(value="SQLite")
    private String getEdits = "SELECT * FROM `{0}edits` WHERE `time`>? AND `x2`>=? AND `x1`<=? AND `z2`>=? AND `z1`<=? AND `y2`>=? AND `y1`<=? ORDER BY `time` DESC, `id` DESC";
    @Language(value="SQLite")
    private String getEditsAsc = "SELECT * FROM `{0}edits` WHERE `time`>? AND `x2`>=? AND `x1`<=? AND `z2`>=? AND `z1`<=? AND `y2`>=? AND `y1`<=? ORDER BY `time` , `id` ";
    @Language(value="SQLite")
    private String getEditUser = "SELECT * FROM `{0}edits` WHERE `player`=? AND `id`=?";
    @Language(value="SQLite")
    private String deleteEditsUser = "DELETE FROM `{0}edits` WHERE `player`=? AND `time`>? AND `x2`>=? AND `x1`<=? AND `y2`>=? AND `y1`<=? AND `z2`>=? AND `z1`<=?";
    @Language(value="SQLite")
    private String deleteEditUser = "DELETE FROM `{0}edits` WHERE `player`=? AND `id`=?";
    private final ConcurrentLinkedQueue<RollbackOptimizedHistory> historyChanges = new ConcurrentLinkedQueue();

    RollbackDatabase(World world) throws SQLException, ClassNotFoundException {
        super((Thread t, Throwable e) -> e.printStackTrace());
        this.prefix = "";
        this.world = world;
        this.dbLocation = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HISTORY + File.separator + world.getName() + File.separator + "summary.db");
        this.connection = this.openConnection();
        this.createTable = this.createTable.replace("{0}", this.prefix);
        this.updateTable1 = this.updateTable1.replace("{0}", this.prefix);
        this.updateTable2 = this.updateTable2.replace("{0}", this.prefix);
        this.insertEdit = this.insertEdit.replace("{0}", this.prefix);
        this.purge = this.purge.replace("{0}", this.prefix);
        this.getEditsUser = this.getEditsUser.replace("{0}", this.prefix);
        this.getEditsUserAsc = this.getEditsUserAsc.replace("{0}", this.prefix);
        this.getEdits = this.getEdits.replace("{0}", this.prefix);
        this.getEditsAsc = this.getEditsAsc.replace("{0}", this.prefix);
        this.getEditUser = this.getEditUser.replace("{0}", this.prefix);
        this.deleteEditsUser = this.deleteEditsUser.replace("{0}", this.prefix);
        this.deleteEditUser = this.deleteEditUser.replace("{0}", this.prefix);
        try {
            this.init().get();
            this.purge((int)TimeUnit.DAYS.toSeconds(Settings.IMP.HISTORY.DELETE_AFTER_DAYS));
        }
        catch (InterruptedException | ExecutionException e2) {
            throw new RuntimeException(e2);
        }
    }

    private byte[] toBytes(UUID uuid) {
        return ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
    }

    public Future<Boolean> init() {
        return this.call(() -> {
            try (PreparedStatement stmt = this.connection.prepareStatement(this.createTable);){
                stmt.executeUpdate();
            }
            try {
                stmt = this.connection.prepareStatement(this.updateTable1);
                var2_4 = null;
                try {
                    stmt.executeUpdate();
                }
                catch (Throwable throwable) {
                    var2_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var2_4 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var2_4.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException stmt2) {
                // empty catch block
            }
            try {
                stmt = this.connection.prepareStatement(this.updateTable2);
                var2_4 = null;
                try {
                    stmt.executeUpdate();
                }
                catch (Throwable throwable) {
                    var2_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var2_4 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var2_4.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return true;
        });
    }

    public Future<Integer> delete(UUID uuid, int id) {
        return this.call(() -> {
            try (PreparedStatement stmt = this.connection.prepareStatement(this.deleteEditUser);){
                stmt.setBytes(1, this.toBytes(uuid));
                stmt.setInt(2, id);
                Integer n = stmt.executeUpdate();
                return n;
            }
        });
    }

    public Future<RollbackOptimizedHistory> getEdit(@NotNull UUID uuid, int id) {
        return this.call(() -> {
            try (PreparedStatement stmt = this.connection.prepareStatement(this.getEditUser);){
                stmt.setBytes(1, this.toBytes(uuid));
                stmt.setInt(2, id);
                ResultSet result = stmt.executeQuery();
                if (!result.next()) {
                    RollbackOptimizedHistory rollbackOptimizedHistory = null;
                    return rollbackOptimizedHistory;
                }
                RollbackOptimizedHistory rollbackOptimizedHistory = this.create(result).get();
                return rollbackOptimizedHistory;
            }
        });
    }

    private Supplier<RollbackOptimizedHistory> create(ResultSet result) throws SQLException {
        byte[] uuidBytes = result.getBytes("player");
        int index = result.getInt("id");
        int x1 = result.getInt("x1");
        int x2 = result.getInt("x2");
        int y1 = result.getByte("y1") + 128;
        int y2 = result.getByte("y2") + 128;
        int z1 = result.getInt("z1");
        int z2 = result.getInt("z2");
        CuboidRegion region = new CuboidRegion(BlockVector3.at(x1, y1, z1), BlockVector3.at(x2, y2, z2));
        long time = (long)result.getInt("time") * 1000L;
        long size = result.getInt("size");
        String command = result.getString("command");
        ByteBuffer bb = ByteBuffer.wrap(uuidBytes);
        long high = bb.getLong();
        long low = bb.getLong();
        UUID uuid = new UUID(high, low);
        return () -> new RollbackOptimizedHistory(this.world, uuid, index, time, size, region, command);
    }

    public Future<Integer> purge(int diff) {
        long now = System.currentTimeMillis() / 1000L;
        int then = (int)(now - (long)diff);
        return this.call(() -> {
            try (PreparedStatement stmt = this.connection.prepareStatement(this.purge);){
                stmt.setInt(1, then);
                Integer n = stmt.executeUpdate();
                return n;
            }
        });
    }

    public Iterable<Supplier<RollbackOptimizedHistory>> getEdits(BlockVector3 pos, boolean ascending) {
        return this.getEdits(null, 0L, pos, pos, false, ascending);
    }

    public Iterable<Supplier<RollbackOptimizedHistory>> getEdits(UUID uuid, long minTime, BlockVector3 pos1, BlockVector3 pos2, boolean delete, boolean ascending) {
        YieldIterable<Supplier<RollbackOptimizedHistory>> yieldIterable = new YieldIterable<Supplier<RollbackOptimizedHistory>>();
        Future<Integer> future = this.call(() -> {
            try {
                byte[] uuidBytes;
                int count = 0;
                String stmtStr = ascending ? (uuid == null ? this.getEditsAsc : this.getEditsUserAsc) : (uuid == null ? this.getEdits : this.getEditsUser);
                try (PreparedStatement stmt = this.connection.prepareStatement(stmtStr);){
                    ResultSet result;
                    stmt.setInt(1, (int)(minTime / 1000L));
                    stmt.setInt(2, pos1.getBlockX());
                    stmt.setInt(3, pos2.getBlockX());
                    stmt.setInt(4, pos1.getBlockZ());
                    stmt.setInt(5, pos2.getBlockZ());
                    stmt.setByte(6, (byte)(pos1.getBlockY() - 128));
                    stmt.setByte(7, (byte)(pos2.getBlockY() - 128));
                    if (uuid != null) {
                        uuidBytes = this.toBytes(uuid);
                        stmt.setBytes(8, uuidBytes);
                    }
                    if (!(result = stmt.executeQuery()).next()) {
                        Integer n = 0;
                        return n;
                    }
                    do {
                        ++count;
                        Supplier<RollbackOptimizedHistory> history = this.create(result);
                        yieldIterable.accept(history);
                    } while (result.next());
                }
                if (delete && uuid != null) {
                    stmt = this.connection.prepareStatement(this.deleteEditsUser);
                    var12_11 = null;
                    try {
                        stmt.setInt(1, (int)(minTime / 1000L));
                        stmt.setInt(2, pos1.getBlockX());
                        stmt.setInt(3, pos2.getBlockX());
                        stmt.setInt(4, pos1.getBlockZ());
                        stmt.setInt(5, pos2.getBlockZ());
                        stmt.setByte(6, (byte)(pos1.getBlockY() - 128));
                        stmt.setByte(7, (byte)(pos2.getBlockY() - 128));
                        uuidBytes = ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
                        stmt.setBytes(8, uuidBytes);
                    }
                    catch (Throwable throwable) {
                        var12_11 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (stmt != null) {
                            if (var12_11 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable) {
                                    var12_11.addSuppressed(throwable);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                Integer n = count;
                return n;
            }
            finally {
                yieldIterable.close();
            }
        });
        yieldIterable.setFuture(future);
        return yieldIterable;
    }

    public Future<?> logEdit(RollbackOptimizedHistory history) {
        this.historyChanges.add(history);
        return this.call(this::sendBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendBatch() throws SQLException {
        int size = Math.min(1048572, this.historyChanges.size());
        if (size == 0) {
            return false;
        }
        this.commit();
        if (this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
        }
        RollbackOptimizedHistory[] copy = (RollbackOptimizedHistory[])IntStream.range(0, size).mapToObj(i -> this.historyChanges.poll()).toArray(RollbackOptimizedHistory[]::new);
        try (PreparedStatement stmt = this.connection.prepareStatement(this.insertEdit);){
            for (RollbackOptimizedHistory change : copy) {
                UUID uuid = change.getUUID();
                byte[] uuidBytes = this.toBytes(uuid);
                stmt.setBytes(1, uuidBytes);
                stmt.setInt(2, change.getIndex());
                stmt.setInt(3, (int)(change.getTime() / 1000L));
                BlockVector3 pos1 = change.getMinimumPoint();
                BlockVector3 pos2 = change.getMaximumPoint();
                stmt.setInt(4, pos1.getX());
                stmt.setInt(5, pos2.getX());
                stmt.setInt(6, pos1.getZ());
                stmt.setInt(7, pos2.getZ());
                stmt.setByte(8, (byte)(pos1.getY() - 128));
                stmt.setByte(9, (byte)(pos2.getY() - 128));
                stmt.setString(10, change.getCommand());
                stmt.setInt(11, change.size());
                stmt.executeUpdate();
                stmt.clearParameters();
            }
        }
        finally {
            this.commit();
        }
        return true;
    }

    private void commit() {
        try {
            if (this.connection == null) {
                return;
            }
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Connection openConnection() throws SQLException, ClassNotFoundException {
        if (this.checkConnection()) {
            return this.connection;
        }
        if (!Fawe.imp().getDirectory().exists()) {
            Fawe.imp().getDirectory().mkdirs();
        }
        if (!this.dbLocation.exists()) {
            try {
                this.dbLocation.getParentFile().mkdirs();
                this.dbLocation.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                log.debug("Unable to create the database!");
            }
        }
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbLocation);
        return this.connection;
    }

    private Connection forceConnection() throws SQLException, ClassNotFoundException {
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbLocation);
        return this.connection;
    }

    public Connection getConnection() {
        if (this.connection == null) {
            try {
                this.forceConnection();
            }
            catch (ClassNotFoundException | SQLException e) {
                e.printStackTrace();
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnection() throws SQLException {
        if (this.connection == null) {
            return false;
        }
        RollbackDatabase rollbackDatabase = this;
        synchronized (rollbackDatabase) {
            if (this.connection == null) {
                return false;
            }
            this.connection.close();
            this.connection = null;
            return true;
        }
    }

    public boolean checkConnection() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.closeConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        super.close();
    }
}

