/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt.anvil;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.worldedit.bukkit.fastutil.io.FastBufferedInputStream;
import com.sk89q.worldedit.bukkit.fastutil.io.FastBufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class LevelDat {
    private final File file;
    private CompoundTag tag;

    public LevelDat(File file) {
        Preconditions.checkArgument((boolean)file.exists());
        this.file = file;
    }

    public void load() throws IOException {
        try (NBTInputStream nis = new NBTInputStream(new FastBufferedInputStream(new GZIPInputStream(new FastBufferedInputStream(new FileInputStream(this.file)))));){
            this.tag = (CompoundTag)nis.readNamedTag().getTag();
        }
    }

    public void save() throws IOException {
        if (this.tag != null) {
            try (NBTOutputStream nos = new NBTOutputStream(new FastBufferedOutputStream(new GZIPOutputStream(new FastBufferedOutputStream(new FileOutputStream(this.file)))));){
                nos.writeNamedTag("", this.tag);
            }
        }
    }

    public CompoundTag getTag() {
        return this.tag;
    }
}

