/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt.anvil;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.Filter;
import com.boydti.fawe.beta.IChunk;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.beta.IQueueExtent;
import com.boydti.fawe.beta.implementation.filter.block.ChunkFilterBlock;
import com.boydti.fawe.beta.implementation.lighting.HeightMapType;
import com.boydti.fawe.jnbt.streamer.StreamDelegate;
import com.boydti.fawe.object.collection.BitArray;
import com.boydti.fawe.object.collection.BlockVector3ChunkMap;
import com.boydti.fawe.util.MathMan;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.worldedit.bukkit.fastutil.io.FastByteArrayOutputStream;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public class MCAChunk
implements IChunk {
    public final boolean[] hasSections = new boolean[16];
    public boolean hasBiomes = false;
    public final BiomeType[] biomes = new BiomeType[1024];
    public final char[] blocks = new char[65536];
    public final BlockVector3ChunkMap<CompoundTag> tiles = new BlockVector3ChunkMap();
    public final Map<UUID, CompoundTag> entities = new HashMap<UUID, CompoundTag>();
    public long inhabitedTime = System.currentTimeMillis();
    public long lastUpdate;
    public int modified;
    public boolean deleted;
    public int chunkX;
    public int chunkZ;
    private boolean createCopy = false;

    public MCAChunk() {
    }

    private boolean readLayer(Section section) {
        if (section.palette == null || section.layer == -1 || section.blocksLength == -1 || section.palette[section.palette.length - 1] == null || section.blocks == null) {
            return false;
        }
        int bitsPerEntry = MathMan.log2nlz(section.palette.length - 1);
        BitArray bitArray = new BitArray(bitsPerEntry, 4096, section.blocks);
        char[] buffer = (char[])FaweCache.IMP.SECTION_BITS_TO_CHAR.get();
        bitArray.toRaw(buffer);
        int offset = section.layer << 12;
        for (int i = 0; i < buffer.length; ++i) {
            BlockState block = section.palette[buffer[i]];
            this.blocks[offset + i] = block.getOrdinalChar();
        }
        section.layer = -1;
        section.blocksLength = -1;
        section.blocks = null;
        section.palette = null;
        return true;
    }

    public MCAChunk(NBTInputStream nis, int chunkX, int chunkZ, boolean readPos) throws IOException {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.read(nis, readPos);
    }

    @Override
    public <V extends IChunk> void init(IQueueExtent<V> extent, int x, int z) {
        if (x != this.chunkX || z != this.chunkZ) {
            throw new UnsupportedOperationException("Not reuse capable");
        }
    }

    public void read(NBTInputStream nis, boolean readPos) throws IOException {
        StreamDelegate root = this.createDelegate(nis, readPos);
        nis.readNamedTagLazy(root);
    }

    public StreamDelegate createDelegate(NBTInputStream nis, boolean readPos) {
        StreamDelegate root = new StreamDelegate();
        StreamDelegate level = root.add("").add("Level");
        level.add("InhabitedTime").withLong((i, v) -> {
            this.inhabitedTime = v;
        });
        level.add("LastUpdate").withLong((i, v) -> {
            this.lastUpdate = v;
        });
        if (readPos) {
            level.add("xPos").withInt((i, v) -> {
                this.chunkX = v;
            });
            level.add("zPos").withInt((i, v) -> {
                this.chunkZ = v;
            });
        }
        Section section = new Section();
        StreamDelegate layers = level.add("Sections");
        StreamDelegate layer = layers.add();
        layer.withInfo((length, type) -> {
            section.layer = -1;
            section.blocksLength = -1;
        });
        layer.add("Y").withInt((i, y) -> {
            section.layer = y;
        });
        layer.add("Palette").withElem((index, map) -> {
            String name = (String)map.get("Name");
            BlockType type = BlockTypes.get(name);
            BlockStateHolder<BlockState> state = type.getDefaultState();
            Map properties = (Map)map.get("Properties");
            if (properties != null) {
                for (Map.Entry entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    Property property = type.getProperty(key);
                    state = state.with(property, property.getValueFor(value));
                }
            }
            section.palette[index] = state;
            this.readLayer(section);
        });
        StreamDelegate blockStates = layer.add("BlockStates");
        blockStates.withInfo((length, type) -> {
            if (section.blocks == null) {
                section.blocks = (long[])FaweCache.IMP.LONG_BUFFER_1024.get();
            }
            section.blocksLength = length;
        });
        blockStates.withLong((index, value) -> {
            section.blocks[index] = value;
        });
        level.add("TileEntities").withElem((index, value) -> {
            CompoundTag tile = FaweCache.IMP.asTag((Map<String, Object>)value);
            int x = tile.getInt("x") & 0xF;
            int y = tile.getInt("y");
            int z = tile.getInt("z") & 0xF;
            this.tiles.put(x, y, z, tile);
        });
        level.add("Entities").withElem((index, value) -> {
            CompoundTag entity = FaweCache.IMP.asTag((Map<String, Object>)value);
            this.entities.put(entity.getUUID(), entity);
        });
        level.add("Biomes").withInt((index, value) -> {
            this.biomes[index] = BiomeTypes.getLegacy(value);
        });
        return root;
    }

    @Override
    public int getX() {
        return this.chunkX;
    }

    @Override
    public int getZ() {
        return this.chunkZ;
    }

    @Override
    public boolean hasSection(int layer) {
        return this.hasSections[layer];
    }

    public void setPosition(int X, int Z) {
        this.chunkX = X;
        this.chunkZ = Z;
    }

    @Override
    public MCAChunk reset() {
        return this.reset(true);
    }

    public MCAChunk reset(boolean full) {
        if (!this.tiles.isEmpty()) {
            this.tiles.clear();
        }
        if (!this.entities.isEmpty()) {
            this.entities.clear();
        }
        this.modified = 0;
        this.deleted = false;
        this.hasBiomes = false;
        if (full) {
            for (int i = 0; i < 65536; ++i) {
                this.blocks[i] = '\u0001';
            }
        }
        Arrays.fill(this.hasSections, false);
        return this;
    }

    public void write(NBTOutputStream nbtOut) throws IOException {
        int[] blockToPalette = (int[])FaweCache.IMP.BLOCK_TO_PALETTE.get();
        int[] paletteToBlock = (int[])FaweCache.IMP.PALETTE_TO_BLOCK.get();
        long[] blockstates = (long[])FaweCache.IMP.BLOCK_STATES.get();
        int[] blocksCopy = (int[])FaweCache.IMP.SECTION_BLOCKS.get();
        nbtOut.writeNamedTagName("", 10);
        nbtOut.writeNamedTag("DataVersion", 1631);
        nbtOut.writeLazyCompoundTag("Level", out -> {
            void var8_11;
            out.writeNamedTag("Status", "decorated");
            out.writeNamedTag("xPos", this.getX());
            out.writeNamedTag("zPos", this.getZ());
            if (this.entities.isEmpty()) {
                out.writeNamedEmptyList("Entities");
            } else {
                out.writeNamedTag("Entities", new ListTag(CompoundTag.class, new ArrayList<CompoundTag>(this.entities.values())));
            }
            if (this.tiles.isEmpty()) {
                out.writeNamedEmptyList("TileEntities");
            } else {
                out.writeNamedTag("TileEntities", new ListTag(CompoundTag.class, new ArrayList(this.tiles.values())));
            }
            out.writeNamedTag("InhabitedTime", this.inhabitedTime);
            out.writeNamedTag("LastUpdate", this.lastUpdate);
            if (this.hasBiomes) {
                int type = 7;
                out.writeNamedTagName("Biomes", type);
                out.writeInt(this.biomes.length);
                for (BiomeType biome : this.biomes) {
                    out.write(biome.getLegacyId());
                }
            }
            int len = 0;
            for (boolean hasSection : this.hasSections) {
                if (!hasSection) continue;
                ++len;
            }
            out.writeNamedTagName("Sections", 9);
            nbtOut.writeByte(10);
            nbtOut.writeInt(len);
            boolean bl = false;
            while (var8_11 < this.hasSections.length) {
                if (this.hasSections[var8_11]) {
                    out.writeNamedTag("Y", (byte)var8_11);
                    void blockIndexStart = var8_11 << 12;
                    void blockIndexEnd = blockIndexStart + 4096;
                    int num_palette = 0;
                    try {
                        int i = blockIndexStart;
                        int j = 0;
                        while (i < blockIndexEnd) {
                            int ordinal = this.blocks[i];
                            int palette = blockToPalette[ordinal];
                            if (palette == Integer.MAX_VALUE) {
                                blockToPalette[ordinal] = palette = num_palette;
                                paletteToBlock[num_palette] = ordinal;
                                ++num_palette;
                            }
                            blocksCopy[j] = palette;
                            ++i;
                            ++j;
                        }
                        for (i = 0; i < num_palette; ++i) {
                            blockToPalette[paletteToBlock[i]] = Integer.MAX_VALUE;
                        }
                        out.writeNamedTagName("Palette", 9);
                        out.writeByte(10);
                        out.writeInt(num_palette);
                        for (i = 0; i < num_palette; ++i) {
                            int ordinal = paletteToBlock[i];
                            BlockState state = BlockTypesCache.states[ordinal];
                            BlockType type = state.getBlockType();
                            out.writeNamedTag("Name", type.getId());
                            if (type.getDefaultState() != state) {
                                out.writeNamedTagName("Properties", 10);
                                for (Property<?> property : type.getProperties()) {
                                    String key = property.getName();
                                    Object value = state.getState(property);
                                    String valueStr = value.toString();
                                    if (Character.isUpperCase(valueStr.charAt(0))) {
                                        LoggerFactory.getLogger(MCAChunk.class).warn("Invalid uppercase value {}", value);
                                        valueStr = valueStr.toLowerCase(Locale.ROOT);
                                    }
                                    out.writeNamedTag(key, valueStr);
                                }
                                out.writeEndTag();
                            }
                            out.writeEndTag();
                        }
                        int bitsPerEntry = MathMan.log2nlz(num_palette - 1);
                        int blockBitArrayEnd = bitsPerEntry * 4096 >> 6;
                        if (num_palette == 1) {
                            blockstates[0] = 0L;
                            blockBitArrayEnd = 1;
                        } else {
                            BitArray bitArray = new BitArray(bitsPerEntry, 4096, blockstates);
                            bitArray.fromRaw(blocksCopy);
                        }
                        out.writeNamedTagName("BlockStates", 12);
                        out.writeInt(blockBitArrayEnd);
                        for (int i2 = 0; i2 < blockBitArrayEnd; ++i2) {
                            out.writeLong(blockstates[i2]);
                        }
                        out.writeEndTag();
                    }
                    catch (Throwable e) {
                        Arrays.fill(blockToPalette, Integer.MAX_VALUE);
                        e.printStackTrace();
                        throw e;
                    }
                }
                ++var8_11;
            }
        });
        nbtOut.writeEndTag();
    }

    public FastByteArrayOutputStream toBytes(byte[] buffer) throws IOException {
        if (buffer == null) {
            buffer = new byte[8192];
        }
        FastByteArrayOutputStream buffered = new FastByteArrayOutputStream(buffer);
        try (NBTOutputStream nbtOut = new NBTOutputStream(buffered);){
            this.write(nbtOut);
        }
        return buffered;
    }

    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setInhabitedTime(long inhabitedTime) {
        this.inhabitedTime = inhabitedTime;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setDeleted(boolean deleted) {
        this.setModified();
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public boolean isEmpty() {
        if (this.deleted) {
            return true;
        }
        for (boolean hasSection : this.hasSections) {
            if (!hasSection) continue;
            return false;
        }
        return true;
    }

    public boolean isModified() {
        return this.modified != 0;
    }

    public int getModified() {
        return this.modified;
    }

    public final void setModified() {
        ++this.modified;
    }

    @Override
    public int getBitMask() {
        int bitMask = 0;
        for (int section = 0; section < this.hasSections.length; ++section) {
            if (!this.hasSections[section]) continue;
            bitMask += 1 << section;
        }
        return bitMask;
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tile) {
        this.setModified();
        if (tile == null) {
            return this.tiles.remove(x, y, z) != null;
        }
        this.tiles.put(x, y, z, tile);
        return true;
    }

    @Override
    public void setBlockLight(int x, int y, int z, int value) {
    }

    @Override
    public void setSkyLight(int x, int y, int z, int value) {
    }

    @Override
    public void setHeightMap(HeightMapType type, int[] heightMap) {
    }

    @Override
    public void removeSectionLighting(int layer, boolean sky) {
    }

    @Override
    public void setFullBright(int layer) {
    }

    @Override
    public void setLightLayer(int layer, char[] toSet) {
    }

    @Override
    public void setSkyLightLayer(int layer, char[] toSet) {
    }

    @Override
    public void setEntity(CompoundTag entityTag) {
        this.setModified();
        long least = entityTag.getLong("UUIDLeast");
        long most = entityTag.getLong("UUIDMost");
        this.entities.put(new UUID(most, least), entityTag);
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        return this.biomes[y >> 2 << 4 | z >> 2 << 2 | x >> 2];
    }

    @Override
    public BiomeType[] getBiomes() {
        return this.biomes;
    }

    @Override
    public char[][] getLight() {
        return new char[0][];
    }

    @Override
    public char[][] getSkyLight() {
        return new char[0][];
    }

    @Override
    public boolean setBiome(BlockVector3 pos, BiomeType biome) {
        return this.setBiome(pos.getX(), pos.getY(), pos.getZ(), biome);
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        this.setModified();
        this.biomes[y >> 2 << 4 | z >> 2 << 2 | x >> 2] = biome;
        return true;
    }

    @Override
    public Set<CompoundTag> getEntities() {
        return new HashSet<CompoundTag>(this.entities.values());
    }

    @Override
    public Map<BlockVector3, CompoundTag> getTiles() {
        return this.tiles == null ? Collections.emptyMap() : this.tiles;
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        if (this.tiles == null || this.tiles.isEmpty()) {
            return null;
        }
        short pair = MathMan.tripleBlockCoord(x, y, z);
        return (CompoundTag)this.tiles.get(pair);
    }

    private final int getIndex(int x, int y, int z) {
        return x | z << 4 | y << 8;
    }

    public int getBlockOrdinal(int x, int y, int z) {
        return this.blocks[x | z << 4 | y << 8];
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        int ordinal = this.getBlockOrdinal(x, y, z);
        return BlockState.getFromOrdinal(ordinal);
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return 0;
    }

    @Override
    public int getEmmittedLight(int x, int y, int z) {
        return 0;
    }

    @Override
    public int[] getHeightMap(HeightMapType type) {
        return new int[256];
    }

    @Override
    public BaseBlock getFullBlock(int x, int y, int z) {
        BlockState block = this.getBlock(x, y, z);
        return block.toBaseBlock(this, x, y, z);
    }

    @Override
    public Set<UUID> getEntityRemoves() {
        return new HashSet<UUID>();
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x, int y, int z, B holder) {
        this.setBlock(x, y, z, holder.getOrdinalChar());
        holder.applyTileEntity(this, x, y, z);
        return true;
    }

    @Override
    public void setBlocks(int layer, char[] data) {
        int offset = layer << 12;
        System.arraycopy(data, 0, this.blocks, offset, 4096);
    }

    @Override
    public char[] load(int layer) {
        char[] tmp = (char[])FaweCache.IMP.SECTION_BITS_TO_CHAR.get();
        int offset = layer << 12;
        System.arraycopy(this.blocks, offset, tmp, 0, 4096);
        return tmp;
    }

    public void setBlock(int x, int y, int z, char ordinal) {
        this.blocks[this.getIndex((int)x, (int)y, (int)z)] = ordinal;
    }

    public void setBiome(BiomeType biome) {
        Arrays.fill(this.biomes, biome);
    }

    @Override
    public void removeEntity(UUID uuid) {
        this.entities.remove(uuid);
    }

    @Override
    public boolean trim(boolean aggressive) {
        return this.isEmpty();
    }

    @Override
    public boolean trim(boolean aggressive, int layer) {
        return this.hasSection(layer);
    }

    @Override
    public CompoundTag getEntity(UUID uuid) {
        return this.entities.get(uuid);
    }

    @Override
    public void setCreateCopy(boolean createCopy) {
        this.createCopy = createCopy;
    }

    @Override
    public boolean isCreateCopy() {
        return this.createCopy;
    }

    @Override
    public void setLightingToGet(char[][] lighting) {
    }

    @Override
    public void setSkyLightingToGet(char[][] lighting) {
    }

    @Override
    public void setHeightmapToGet(HeightMapType type, int[] data) {
    }

    public Future call(IChunkSet set, Runnable finalize) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filterBlocks(Filter filter, ChunkFilterBlock block, @Nullable Region region, boolean full) {
        try {
            block.filter(this, this, this, filter, region, full);
        }
        finally {
            filter.finishChunk(this);
        }
    }

    private static class Section {
        public int layer = -1;
        public long[] blocks;
        public int blocksLength = -1;
        public BlockState[] palette;

        private Section() {
        }
    }
}

