/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt.anvil;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.Trimable;
import com.boydti.fawe.beta.implementation.IChunkExtent;
import com.boydti.fawe.beta.implementation.processors.ExtentBatchProcessorHolder;
import com.boydti.fawe.jnbt.anvil.MCAChunk;
import com.boydti.fawe.object.RunnableVal4;
import com.boydti.fawe.object.io.BufferedRandomAccessFile;
import com.boydti.fawe.object.io.FastByteArrayInputStream;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MathMan;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.fastutil.ints.Int2ObjectMap;
import com.sk89q.worldedit.bukkit.fastutil.ints.Int2ObjectOpenHashMap;
import com.sk89q.worldedit.bukkit.fastutil.io.FastByteArrayOutputStream;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.world.World;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class MCAFile
extends ExtentBatchProcessorHolder
implements Trimable,
IChunkExtent {
    private static Field fieldBuf2;
    private final ForkJoinPool pool;
    private final byte[] locations;
    private boolean readLocations;
    private File file;
    private RandomAccessFile raf;
    private boolean deleted;
    private int X;
    private int Z;
    private MCAChunk[] chunks;
    private boolean[] chunkInitialized;
    private Object[] locks;
    private Deflater deflater = new Deflater(1, false);

    public MCAFile(ForkJoinPool pool) {
        this.pool = pool;
        this.locations = new byte[4096];
        this.chunks = new MCAChunk[1024];
        this.chunkInitialized = new boolean[this.chunks.length];
        this.locks = new Object[this.chunks.length];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new Object();
        }
    }

    @Override
    public boolean trim(boolean aggressive) {
        boolean hasChunk = false;
        for (int i = 0; i < this.chunkInitialized.length; ++i) {
            if (!this.chunkInitialized[i]) {
                this.chunks[i] = null;
                continue;
            }
            hasChunk = true;
        }
        return !hasChunk;
    }

    public MCAFile init(File file) throws FileNotFoundException {
        String[] split = file.getName().split("\\.");
        int X = Integer.parseInt(split[1]);
        int Z = Integer.parseInt(split[2]);
        return this.init(file, X, Z);
    }

    public MCAFile init(File file, int mcrX, int mcrZ) throws FileNotFoundException {
        if (this.raf != null) {
            this.flush(true);
            for (int i = 0; i < 4096; ++i) {
                this.locations[i] = 0;
            }
            try {
                this.raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.raf = null;
        }
        this.deleted = false;
        Arrays.fill(this.chunkInitialized, false);
        this.readLocations = false;
        this.X = mcrX;
        this.Z = mcrZ;
        this.file = file;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName());
        }
        return this;
    }

    public MCAFile init(World world, int mcrX, int mcrZ) throws FileNotFoundException {
        return this.init(new File(world.getStoragePath().toFile(), File.separator + "regions" + File.separator + "r." + mcrX + "." + mcrZ + ".mca"));
    }

    @Override
    public BlockVector3 getMinimumPoint() {
        return BlockVector3.at(this.X << 9, 0, this.Z << 9);
    }

    @Override
    public BlockVector3 getMaximumPoint() {
        return BlockVector3.at((this.X << 9) + 511, FaweCache.IMP.WORLD_MAX_Y, (this.Z << 9) + 511);
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tile) throws WorldEditException {
        return false;
    }

    public int getIndex(int chunkX, int chunkZ) {
        return ((chunkX & 0x1F) << 2) + ((chunkZ & 0x1F) << 7);
    }

    private RandomAccessFile getRaf() throws FileNotFoundException {
        if (this.raf == null) {
            this.raf = new RandomAccessFile(this.file, "rw");
        }
        return this.raf;
    }

    private void readHeader() throws IOException {
        if (!this.readLocations) {
            this.readLocations = true;
            this.getRaf();
            if (this.raf.length() < 8192L) {
                this.raf.setLength(8192L);
            } else {
                this.raf.seek(0L);
                this.raf.readFully(this.locations);
            }
        }
    }

    public void clear() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.deleted = false;
        this.readLocations = false;
        Arrays.fill(this.chunkInitialized, false);
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public int getX() {
        return this.X;
    }

    public int getZ() {
        return this.Z;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    public File getFile() {
        return this.file;
    }

    public MCAChunk getCachedChunk(int cx, int cz) {
        int pair = this.getIndex(cx, cz);
        MCAChunk chunk = this.chunks[pair];
        if (chunk != null && this.chunkInitialized[pair]) {
            return chunk;
        }
        return null;
    }

    public void setChunk(MCAChunk chunk) {
        int cx = chunk.getX();
        int cz = chunk.getZ();
        int pair = this.getIndex(cx, cz);
        this.chunks[pair] = chunk;
    }

    public MCAChunk getOrCreateChunk(int chunkX, int chunkZ) {
        try {
            return this.getChunk(chunkX, chunkZ);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCAChunk getChunk(int cx, int cz) throws IOException {
        int pair = this.getIndex(cx, cz);
        MCAChunk chunk = this.chunks[pair];
        if (chunk == null) {
            Object lock;
            Object object = lock = this.locks[pair];
            synchronized (object) {
                chunk = this.chunks[pair];
                if (chunk == null) {
                    chunk = new MCAChunk();
                    chunk.setPosition(cx, cz);
                    this.chunks[pair] = chunk;
                }
            }
        } else if (this.chunkInitialized[pair]) {
            return chunk;
        }
        MCAChunk mCAChunk = chunk;
        synchronized (mCAChunk) {
            if (!this.chunkInitialized[pair]) {
                this.readChunk(chunk, pair);
                this.chunkInitialized[pair] = true;
            }
        }
        return chunk;
    }

    private MCAChunk readChunk(MCAChunk chunk, int i) throws IOException {
        int offset = ((this.locations[i] & 0xFF) << 16) + ((this.locations[i + 1] & 0xFF) << 8) + (this.locations[i + 2] & 0xFF) << 12;
        if (offset == 0) {
            return null;
        }
        int size = (this.locations[i + 3] & 0xFF) << 12;
        try (NBTInputStream nis = this.getChunkIS(offset);){
            chunk.read(nis, false);
        }
        return chunk;
    }

    public void forEachSortedChunk(RunnableVal4<Integer, Integer, Integer, Integer> onEach) throws IOException {
        char[] offsets = new char[(int)(this.raf.length() / 4096L) - 2];
        Arrays.fill(offsets, '\uffff');
        int i = 0;
        for (int z = 0; z < 32; ++z) {
            int x = 0;
            while (x < 32) {
                int offset = ((this.locations[i] & 0xFF) << 16) + ((this.locations[i + 1] & 0xFF) << 8) + (this.locations[i + 2] & 0xFF) - 2;
                int size = this.locations[i + 3] & 0xFF;
                if (size != 0) {
                    if (offset < offsets.length) {
                        offsets[offset] = i;
                    } else {
                        LoggerFactory.getLogger(MCAFile.class).debug("Ignoring invalid offset " + offset);
                    }
                }
                ++x;
                i = (char)(i + 4);
            }
        }
        for (i = 0; i < offsets.length; i = (int)((char)(i + 1))) {
            char index = offsets[i];
            if (index == '\uffff') continue;
            int offset = i + 2;
            int size = this.locations[index + 3] & 0xFF;
            int index2 = index >> 2;
            int x = index2 & 0x1F;
            int z = index2 >> 5;
            onEach.run(x, z, offset << 12, size << 12);
        }
    }

    public void forEachChunk(RunnableVal4<Integer, Integer, Integer, Integer> onEach) {
        int i = 0;
        for (int z = 0; z < 32; ++z) {
            int x = 0;
            while (x < 32) {
                int offset = ((this.locations[i] & 0xFF) << 16) + ((this.locations[i + 1] & 0xFF) << 8) + (this.locations[i + 2] & 0xFF);
                int size = this.locations[i + 3] & 0xFF;
                if (size != 0) {
                    onEach.run(x, z, offset << 12, size << 12);
                }
                ++x;
                i += 4;
            }
        }
    }

    public void forEachChunk(Consumer<MCAChunk> onEach) {
        int i = 0;
        for (int z = 0; z < 32; ++z) {
            int x = 0;
            while (x < 32) {
                int offset = ((this.locations[i] & 0xFF) << 16) + ((this.locations[i + 1] & 0xFF) << 8) + (this.locations[i + 2] & 0xFF);
                int size = this.locations[i + 3] & 0xFF;
                if (size != 0) {
                    try {
                        onEach.accept(this.getChunk(x, z));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++x;
                i += 4;
            }
        }
    }

    public int getOffset(int cx, int cz) {
        int i = this.getIndex(cx, cz);
        int offset = ((this.locations[i] & 0xFF) << 16) + ((this.locations[i + 1] & 0xFF) << 8) + (this.locations[i + 2] & 0xFF);
        return offset << 12;
    }

    public int getSize(int cx, int cz) {
        int i = this.getIndex(cx, cz);
        return (this.locations[i + 3] & 0xFF) << 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastByteArrayInputStream getChunkCompressedBytes(int offset) throws IOException {
        if (offset == 0) {
            return null;
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(offset);
            int size = this.raf.readInt();
            int compression = this.raf.read();
            byte[] data = FaweCache.IMP.BYTE_BUFFER_VAR.get(size);
            this.raf.readFully(data, 0, size);
            FastByteArrayInputStream result = new FastByteArrayInputStream(data, 0, size);
            return result;
        }
    }

    private NBTInputStream getChunkIS(int offset) throws IOException {
        try {
            return this.getChunkIS(this.getChunkCompressedBytes(offset));
        }
        catch (IllegalAccessException unlikely) {
            unlikely.printStackTrace();
            return null;
        }
    }

    private NBTInputStream getChunkIS(InputStream is) throws IllegalAccessException {
        InflaterInputStream iis = new InflaterInputStream(is, new Inflater(), 1);
        fieldBuf2.set(iis, FaweCache.IMP.BYTE_BUFFER_8192.get());
        BufferedInputStream bis = new BufferedInputStream(iis);
        NBTInputStream nis = new NBTInputStream(bis);
        return nis;
    }

    public void forEachCachedChunk(Consumer<MCAChunk> onEach) {
        for (int i = 0; i < this.chunks.length; ++i) {
            MCAChunk chunk = this.chunks[i];
            if (chunk == null || !this.chunkInitialized[i]) continue;
            onEach.accept(chunk);
        }
    }

    public List<MCAChunk> getCachedChunks() {
        int size = (int)IntStream.range(0, this.chunks.length).filter(i -> this.chunks[i] != null && this.chunkInitialized[i]).count();
        ArrayList<MCAChunk> list = new ArrayList<MCAChunk>(size);
        for (int i2 = 0; i2 < this.chunks.length; ++i2) {
            MCAChunk chunk = this.chunks[i2];
            if (chunk == null || !this.chunkInitialized[i2]) continue;
            list.add(chunk);
        }
        return list;
    }

    private FastByteArrayOutputStream toBytes(MCAChunk chunk) throws IOException {
        if (chunk.isDeleted()) {
            return null;
        }
        byte[] writeBuffer = FaweCache.IMP.BYTE_BUFFER_VAR.get(4096);
        FastByteArrayOutputStream uncompressed = chunk.toBytes(writeBuffer);
        if (uncompressed.array.length > writeBuffer.length) {
            FaweCache.IMP.BYTE_BUFFER_VAR.set(uncompressed.array);
        }
        writeBuffer = uncompressed.array;
        byte[] buffer = (byte[])FaweCache.IMP.BYTE_BUFFER_8192.get();
        int length = uncompressed.length;
        uncompressed.reset();
        int compressedLength = MainUtil.compress(uncompressed.array, length, buffer, uncompressed, this.deflater);
        return uncompressed;
    }

    private void writeSafe(RandomAccessFile raf, int offset, byte[] data, int length) throws IOException {
        int len = length + 5;
        raf.seek(offset);
        if (raf.length() - (long)offset < (long)len) {
            raf.setLength((offset + len + 4095) / 4096 * 4096);
        }
        raf.writeInt(length + 1);
        raf.write(2);
        raf.write(data, 0, length);
    }

    private void writeHeader(RandomAccessFile raf, int cx, int cz, int offsetMedium, int sizeByte, boolean writeTime) throws IOException {
        int i = this.getIndex(cx, cz);
        this.locations[i] = (byte)(offsetMedium >> 16);
        this.locations[i + 1] = (byte)(offsetMedium >> 8);
        this.locations[i + 2] = (byte)offsetMedium;
        this.locations[i + 3] = (byte)sizeByte;
        raf.seek(i);
        raf.write(offsetMedium >> 16);
        raf.write(offsetMedium >> 8);
        raf.write(offsetMedium >> 0);
        raf.write(sizeByte);
        raf.seek(i + 4096);
        if (offsetMedium == 0 && sizeByte == 0) {
            raf.writeInt(0);
        } else {
            raf.writeInt((int)(System.currentTimeMillis() / 1000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.raf == null) {
            return;
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            if (this.raf != null) {
                this.flush(true);
                try {
                    this.raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.raf = null;
            }
        }
    }

    public boolean isModified() {
        if (this.isDeleted()) {
            return true;
        }
        for (int i = 0; i < this.chunks.length; ++i) {
            MCAChunk chunk = this.chunks[i];
            if (chunk == null || !this.chunkInitialized[i] || !chunk.isModified() && !chunk.isDeleted()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean wait) {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            int start;
            if (this.isDeleted()) {
                this.clear();
                this.file.delete();
                return;
            }
            Int2ObjectOpenHashMap<byte[]> relocate = new Int2ObjectOpenHashMap<byte[]>();
            final Int2ObjectOpenHashMap offsetMap = new Int2ObjectOpenHashMap();
            Int2ObjectOpenHashMap compressedMap = new Int2ObjectOpenHashMap();
            Int2ObjectOpenHashMap append = new Int2ObjectOpenHashMap();
            long now = System.currentTimeMillis();
            ForkJoinPool finalPool = this.pool;
            boolean modified = false;
            for (int i = 0; i < this.chunks.length; ++i) {
                MCAChunk chunk;
                if (!this.chunkInitialized[i] || (chunk = this.chunks[i]) == null || !chunk.isModified() || chunk.isDeleted()) continue;
                modified = true;
                Future future = this.pool.submit(() -> {
                    FastByteArrayOutputStream compressed = this.toBytes(chunk);
                    return Arrays.copyOf(compressed.array, compressed.length);
                });
            }
            if (!modified) {
                return;
            }
            this.file.setLastModified(now);
            this.forEachChunk(new RunnableVal4<Integer, Integer, Integer, Integer>(){

                @Override
                public void run(Integer cx, Integer cz, Integer offset, Integer size) {
                    short pair1 = MathMan.pairByte((byte)(cx & 0x1F), (byte)(cz & 0x1F));
                    short pair2 = (short)(size >> 12);
                    offsetMap.put((int)offset, Integer.valueOf(MathMan.pair(pair1, pair2)));
                }
            });
            int written = start = 8192;
            int end = 8192;
            int nextOffset = 8192;
            try {
                for (int count = 0; count < offsetMap.size(); ++count) {
                    Integer loc = (Integer)offsetMap.get(nextOffset);
                    while (loc == null) {
                        loc = (Integer)offsetMap.get(nextOffset += 4096);
                    }
                    int offset = nextOffset;
                    short cxz = MathMan.unpairX(loc);
                    byte cx = MathMan.unpairShortX(cxz);
                    byte cz = MathMan.unpairShortY(cxz);
                    int size = MathMan.unpairY(loc) << 12;
                    nextOffset += size;
                    end = Math.min(start + size, end);
                    int pair = this.getIndex(cx, cz);
                    Future future = null;
                    byte[] newBytes = (byte[])relocate.get(pair);
                    int newBytesLength = 0;
                    if (newBytes == null) {
                        MCAChunk cached = this.getCachedChunk(cx, cz);
                        if (offset == start) {
                            if (cached == null || !cached.isModified()) {
                                this.writeHeader(this.raf, cx, cz, start >> 12, size >> 12, true);
                                written = (start += size) + size;
                                continue;
                            }
                            future = (Future)compressedMap.get(pair);
                        } else {
                            future = (Future)compressedMap.get(pair);
                            if (!(future != null || cached != null && cached.isDeleted())) {
                                FastByteArrayInputStream result = this.getChunkCompressedBytes(this.getOffset(cx, cz));
                                newBytes = result.array;
                                newBytesLength = result.length;
                            }
                        }
                    } else {
                        newBytesLength = newBytes.length;
                    }
                    if (future != null) {
                        newBytes = (byte[])future.get();
                        newBytesLength = newBytes.length;
                    }
                    if (newBytes == null) {
                        this.writeHeader(this.raf, cx, cz, 0, 0, false);
                        continue;
                    }
                    int len = newBytesLength + 5;
                    int oldSize = size + 4095 >> 12;
                    int newSize = len + 4095 >> 12;
                    int nextOffset2 = end;
                    while (start + len > end) {
                        Integer nextLoc = (Integer)offsetMap.get(nextOffset2);
                        if (nextLoc != null) {
                            byte nextCZ;
                            short nextCXZ = MathMan.unpairX(nextLoc);
                            byte nextCX = MathMan.unpairShortX(nextCXZ);
                            MCAChunk cached = this.getCachedChunk(nextCX, nextCZ = MathMan.unpairShortY(nextCXZ));
                            if (cached == null || !cached.isModified()) {
                                FastByteArrayInputStream tmp = this.getChunkCompressedBytes(nextOffset2);
                                byte[] nextBytes = Arrays.copyOf(tmp.array, tmp.length);
                                relocate.put(MathMan.pair((short)(nextCX & 0x1F), (short)(nextCZ & 0x1F)), nextBytes);
                            }
                            int nextSize = MathMan.unpairY(nextLoc) << 12;
                            end += nextSize;
                            nextOffset2 += nextSize;
                            continue;
                        }
                        end += 4096;
                        nextOffset2 += 4096;
                    }
                    this.writeSafe(this.raf, start, newBytes, newBytesLength);
                    this.writeHeader(this.raf, cx, cz, start >> 12, newSize, true);
                    written = start + newBytesLength + 5;
                    start += newSize << 12;
                }
                if (!append.isEmpty()) {
                    for (Int2ObjectMap.Entry entry : append.int2ObjectEntrySet()) {
                        int pair = entry.getIntKey();
                        short cx = MathMan.unpairX(pair);
                        short cz = MathMan.unpairY(pair);
                        byte[] bytes = (byte[])((Future)entry.getValue()).get();
                        int len = bytes.length + 5;
                        int newSize = len + 4095 >> 12;
                        this.writeSafe(this.raf, start, bytes, bytes.length);
                        this.writeHeader(this.raf, cx, cz, start >> 12, newSize, true);
                        written = start + bytes.length + 5;
                        start += newSize << 12;
                    }
                }
                this.raf.setLength(4096 * ((written + 4095) / 4096));
                if (this.raf instanceof BufferedRandomAccessFile) {
                    ((BufferedRandomAccessFile)this.raf).flush();
                }
                this.raf.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (wait) {
                this.pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
        }
    }

    static {
        try {
            fieldBuf2 = InflaterInputStream.class.getDeclaredField("buf");
            fieldBuf2.setAccessible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

