/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object;

import com.boydti.fawe.object.changeset.AbstractChangeSet;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class HistoryExtent
extends AbstractDelegateExtent {
    private AbstractChangeSet changeSet;

    public HistoryExtent(Extent extent, AbstractChangeSet changeSet) {
        super(extent);
        Preconditions.checkNotNull((Object)changeSet);
        this.changeSet = changeSet;
    }

    public AbstractChangeSet getChangeSet() {
        return this.changeSet;
    }

    @Override
    public void setChangeSet(AbstractChangeSet fcs) {
        this.changeSet = fcs;
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x, int y, int z, B block) throws WorldEditException {
        BaseBlock previous = this.getFullBlock(x, y, z);
        if (previous.getInternalId() == block.getInternalId() && !previous.hasNbtData() && block instanceof BaseBlock && !block.hasNbtData()) {
            return false;
        }
        this.changeSet.add(x, y, z, previous, block.toBaseBlock());
        return this.getExtent().setBlock(x, y, z, block);
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        return this.setBlock(location.getBlockX(), location.getBlockY(), location.getBlockZ(), block);
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity state) {
        Entity entity = super.createEntity(location, state);
        if (state != null) {
            this.changeSet.addEntityCreate(state.getNbtData());
        }
        return entity;
    }

    @Override
    public List<? extends Entity> getEntities() {
        return this.wrapEntities(super.getEntities());
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        return this.wrapEntities(super.getEntities(region));
    }

    private List<? extends Entity> wrapEntities(List<? extends Entity> entities) {
        ArrayList<TrackedEntity> newList = new ArrayList<TrackedEntity>(entities.size());
        for (Entity entity : entities) {
            newList.add(new TrackedEntity(entity));
        }
        return newList;
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType newBiome) {
        BiomeType oldBiome = this.getBiome(position);
        if (oldBiome.getId() != newBiome.getId()) {
            this.changeSet.addBiomeChange(position.getBlockX(), position.getBlockY(), position.getBlockZ(), oldBiome, newBiome);
            return this.getExtent().setBiome(position, newBiome);
        }
        return false;
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType newBiome) {
        BiomeType oldBiome = this.getBiome(BlockVector3.at(x, y, z));
        if (oldBiome.getId() != newBiome.getId()) {
            this.changeSet.addBiomeChange(x, y, z, oldBiome, newBiome);
            return this.getExtent().setBiome(x, y, z, newBiome);
        }
        return false;
    }

    @Override
    public Extent disableHistory() {
        return this.getExtent();
    }

    public class TrackedEntity
    implements Entity {
        private final Entity entity;

        private TrackedEntity(Entity entity) {
            this.entity = entity;
        }

        @Override
        public BaseEntity getState() {
            return this.entity.getState();
        }

        @Override
        public Location getLocation() {
            return this.entity.getLocation();
        }

        @Override
        public Extent getExtent() {
            return this.entity.getExtent();
        }

        @Override
        public boolean remove() {
            Location location = this.entity.getLocation();
            BaseEntity state = this.entity.getState();
            boolean success = this.entity.remove();
            if (state != null && success) {
                HistoryExtent.this.changeSet.addEntityRemove(state.getNbtData());
            }
            return success;
        }

        @Override
        @Nullable
        public <T> T getFacet(Class<? extends T> cls) {
            return this.entity.getFacet(cls);
        }

        @Override
        public boolean setLocation(Location location) {
            return this.entity.setLocation(location);
        }
    }
}

