/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.AffineTransform;

public class CircleBrush
implements Brush {
    private final Player player;

    public CircleBrush(Player player) {
        this.player = player;
    }

    @Override
    public void build(EditSession editSession, BlockVector3 position, Pattern pattern, double size) throws MaxChangedBlocksException {
        Vector3 normal = position.toVector3().subtract((Vector3)this.player.getLocation());
        editSession.makeCircle(position, pattern, size, size, size, false, normal);
    }

    private Vector3 any90Rotate(Vector3 normal) {
        if ((normal = normal.normalize()).getX() == 1.0 || normal.getY() == 1.0 || normal.getZ() == 1.0) {
            return Vector3.at(normal.getZ(), normal.getX(), normal.getY());
        }
        AffineTransform affine = new AffineTransform();
        affine = affine.rotateX(90.0);
        affine = affine.rotateY(90.0);
        affine = affine.rotateZ(90.0);
        Vector3 random = affine.apply(normal);
        return random.cross(normal).normalize();
    }
}

