/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush;

import com.boydti.fawe.config.Caption;
import com.boydti.fawe.object.brush.ResettableTool;
import com.boydti.fawe.object.brush.visualization.VisualExtent;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;

public class LineBrush
implements Brush,
ResettableTool {
    private final boolean shell;
    private final boolean select;
    private final boolean flat;
    private BlockVector3 pos1;

    public LineBrush(boolean shell, boolean select, boolean flat) {
        this.shell = shell;
        this.select = select;
        this.flat = flat;
    }

    @Override
    public void build(EditSession editSession, BlockVector3 position, Pattern pattern, double size) throws MaxChangedBlocksException {
        boolean visual = editSession.getExtent() instanceof VisualExtent;
        if (this.pos1 == null) {
            if (!visual) {
                this.pos1 = position;
                editSession.getPlayer().print(Caption.of("fawe.worldedit.brush.brush.line.primary", position));
            }
            return;
        }
        editSession.drawLine(pattern, this.pos1, position, size, !this.shell, this.flat);
        if (!visual) {
            editSession.getPlayer().print(TranslatableComponent.of("fawe.worldedit.brush.brush.line.secondary"));
            this.pos1 = !this.select ? null : position;
        }
    }

    @Override
    public boolean reset() {
        this.pos1 = null;
        return true;
    }
}

