/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush;

import com.boydti.fawe.object.brush.ScatterBrush;
import com.boydti.fawe.object.collection.LocalBlockVectorSet;
import com.boydti.fawe.object.mask.SurfaceMask;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.BreadthFirstSearch;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector3;
import java.util.concurrent.ThreadLocalRandom;

public class ShatterBrush
extends ScatterBrush {
    private final MutableBlockVector3 mutable = new MutableBlockVector3();

    public ShatterBrush(int count) {
        super(count, 1);
    }

    @Override
    public void apply(EditSession editSession, LocalBlockVectorSet placed, BlockVector3 position, Pattern p, double size) throws MaxChangedBlocksException {
    }

    @Override
    public void finish(EditSession editSession, LocalBlockVectorSet placed, BlockVector3 position, Pattern pattern, double size) {
        int radius2 = (int)(size * size);
        LocalBlockVectorSet[] frontiers = new LocalBlockVectorSet[placed.size()];
        LocalBlockVectorSet[] frontiersVisited = new LocalBlockVectorSet[placed.size()];
        int i = 0;
        for (BlockVector3 pos : placed) {
            LocalBlockVectorSet set = new LocalBlockVectorSet();
            set.add(pos);
            frontiers[i] = set;
            frontiersVisited[i] = set.clone();
            ++i;
        }
        Mask mask = editSession.getMask();
        if (mask == null) {
            mask = Masks.alwaysTrue();
        }
        Mask finalMask = mask;
        SurfaceMask surfaceTest = new SurfaceMask(editSession);
        boolean notEmpty = true;
        LocalBlockVectorSet tmp = new LocalBlockVectorSet();
        while (notEmpty) {
            notEmpty = false;
            for (i = 0; i < frontiers.length; ++i) {
                LocalBlockVectorSet frontier = frontiers[i];
                notEmpty |= !frontier.isEmpty();
                LocalBlockVectorSet frontierVisited = frontiersVisited[i];
                LocalBlockVectorSet finalTmp = tmp;
                frontier.forEach((x, y, z, index) -> {
                    if (ThreadLocalRandom.current().nextInt(2) == 0) {
                        finalTmp.add(x, y, z);
                        return;
                    }
                    for (int i1 = 0; i1 < BreadthFirstSearch.DIAGONAL_DIRECTIONS.length; ++i1) {
                        MutableBlockVector3 bv;
                        int dz;
                        int dy;
                        BlockVector3 direction = BreadthFirstSearch.DIAGONAL_DIRECTIONS[i1];
                        int x2 = x + direction.getBlockX();
                        int y2 = y + direction.getBlockY();
                        int z2 = z + direction.getBlockZ();
                        int dx = position.getBlockX() - x2;
                        int dSqr = dx * dx + (dy = position.getBlockY() - y2) * dy + (dz = position.getBlockZ() - z2) * dz;
                        if (dSqr > radius2 || !surfaceTest.test(bv = this.mutable.setComponents(x2, y2, z2)) || !finalMask.test(bv)) continue;
                        if (!placed.add(x2, y2, z2)) {
                            if (frontierVisited.contains(x2, y2, z2)) continue;
                            editSession.setBlock(x2, y2, z2, pattern);
                            continue;
                        }
                        finalTmp.add(x2, y2, z2);
                        frontierVisited.add(x2, y2, z2);
                    }
                });
                frontiers[i] = tmp;
                tmp = frontier;
                tmp.clear();
            }
        }
    }
}

