/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.object.brush.ResettableTool;
import com.boydti.fawe.object.brush.visualization.VisualExtent;
import com.boydti.fawe.object.mask.IdMask;
import com.boydti.fawe.object.visitor.DFSRecursiveVisitor;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MathUtils;
import com.sk89q.worldedit.math.MutableVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.interpolation.Node;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SplineBrush
implements Brush,
ResettableTool {
    public static int MAX_POINTS = 15;
    private ArrayList<ArrayList<BlockVector3>> positionSets;
    private int numSplines;
    private final Player player;
    private BlockVector3 position;

    public SplineBrush(Player player) {
        this.player = player;
        this.positionSets = new ArrayList();
    }

    @Override
    public boolean reset() {
        this.numSplines = 0;
        this.positionSets.clear();
        this.position = null;
        return true;
    }

    @Override
    public void build(EditSession editSession, BlockVector3 position, Pattern pattern, double size) throws WorldEditException {
        Mask mask = editSession.getMask();
        mask = mask == null ? new IdMask(editSession) : new MaskIntersection(mask, new IdMask(editSession));
        boolean visualization = editSession.getExtent() instanceof VisualExtent;
        if (visualization && this.positionSets.isEmpty()) {
            return;
        }
        int originalSize = this.numSplines;
        boolean newPos = !position.equals(this.position);
        this.position = position;
        if (newPos) {
            if (this.positionSets.size() >= MAX_POINTS) {
                throw FaweCache.MAX_CHECKS;
            }
            ArrayList<BlockVector3> points = new ArrayList<BlockVector3>();
            if (size > 0.0) {
                DFSRecursiveVisitor visitor = new DFSRecursiveVisitor(mask, p -> {
                    points.add(p);
                    return true;
                }, (int)size, 1);
                List<BlockVector3> list = visitor.getDirections();
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            BlockVector3 pos;
                            if (x == 0 && y == 0 && z == 0 || list.contains(pos = BlockVector3.at(x, y, z))) continue;
                            list.add(pos);
                        }
                    }
                }
                list.sort((o1, o2) -> (int)Math.signum(o1.lengthSq() - o2.lengthSq()));
                visitor.visit(position);
                Operations.completeBlindly(visitor);
                if (points.size() > this.numSplines) {
                    this.numSplines = points.size();
                }
            } else {
                points.add(position);
            }
            this.positionSets.add(points);
            this.player.print(TranslatableComponent.of("fawe.worldedit.brush.spline.primary.2"));
            if (!visualization) {
                return;
            }
        }
        if (this.positionSets.size() < 2) {
            this.player.print(TranslatableComponent.of("fawe.worldedit.brush.brush.spline.secondary.error"));
            return;
        }
        ArrayList<Vector3> centroids = new ArrayList<Vector3>();
        for (List list : this.positionSets) {
            centroids.add(this.getCentroid(list));
        }
        double tension = 0.0;
        double bias = 0.0;
        double continuity = 0.0;
        double quality = 10.0;
        ArrayList<Node> nodes = new ArrayList<Node>(centroids.size());
        for (Vector3 nodevector : centroids) {
            Node n = new Node(nodevector);
            n.setTension(tension);
            n.setBias(bias);
            n.setContinuity(continuity);
            nodes.add(n);
        }
        int samples = this.numSplines;
        for (int i = 0; i < this.numSplines; ++i) {
            ArrayList<BlockVector3> currentSpline = new ArrayList<BlockVector3>();
            for (ArrayList<BlockVector3> points : this.positionSets) {
                int listSize = points.size();
                int index = (int)((double)(i * listSize) / (double)this.numSplines);
                currentSpline.add(points.get(index));
            }
            editSession.drawSpline(pattern, currentSpline, 0.0, 0.0, 0.0, 10.0, 0.0, true);
        }
        this.player.print(TranslatableComponent.of("fawe.worldedit.brush.spline.secondary"));
        if (visualization) {
            this.numSplines = originalSize;
            this.positionSets.remove(this.positionSets.size() - 1);
        } else {
            this.positionSets.clear();
            this.numSplines = 0;
        }
    }

    private Vector3 getCentroid(Collection<BlockVector3> points) {
        MutableVector3 sum = new MutableVector3();
        for (BlockVector3 p : points) {
            sum.mutX(sum.getX() + (double)p.getX());
            sum.mutY(sum.getY() + (double)p.getY());
            sum.mutZ(sum.getZ() + (double)p.getZ());
        }
        return sum.multiply(1.0 / (double)points.size());
    }

    private BlockVector3 normal(Collection<BlockVector3> points, BlockVector3 centroid) {
        BlockVector3 dir;
        int n = points.size();
        switch (n) {
            case 1: {
                return null;
            }
            case 2: {
                return null;
            }
        }
        double xx = 0.0;
        double xy = 0.0;
        double xz = 0.0;
        double yy = 0.0;
        double yz = 0.0;
        double zz = 0.0;
        MutableVector3 r = new MutableVector3();
        for (BlockVector3 p : points) {
            r.mutX(p.getX() - centroid.getX());
            r.mutY(p.getY() - centroid.getY());
            r.mutZ(p.getZ() - centroid.getZ());
            xx += r.getX() * r.getX();
            xy += r.getX() * r.getY();
            xz += r.getX() * r.getZ();
            yy += r.getY() * r.getY();
            yz += r.getY() * r.getZ();
            zz += r.getZ() * r.getZ();
        }
        double det_x = yy * zz - yz * yz;
        double det_y = xx * zz - xz * xz;
        double det_z = xx * yy - xy * xy;
        double det_max = Math.max(Math.max(det_x, det_y), det_z);
        if (det_max <= 0.0) {
            return null;
        }
        if (det_max == det_x) {
            double a = (xz * yz - xy * zz) / det_x;
            double b = (xy * yz - xz * yy) / det_x;
            dir = BlockVector3.at(1.0, (double)((int)MathUtils.roundHalfUp(a)), (double)((int)MathUtils.roundHalfUp(b)));
        } else if (det_max == det_y) {
            double a = (yz * xz - xy * zz) / det_y;
            double b = (xy * xz - yz * xx) / det_y;
            dir = BlockVector3.at((double)((int)MathUtils.roundHalfUp(a)), 1.0, (double)((int)MathUtils.roundHalfUp(b)));
        } else {
            double a = (yz * xy - xz * yy) / det_z;
            double b = (xz * xy - yz * xx) / det_z;
            dir = BlockVector3.at((double)((int)MathUtils.roundHalfUp(a)), (double)((int)MathUtils.roundHalfUp(b)), 1.0);
        }
        return dir.normalize();
    }
}

