/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush.heightmap;

import com.boydti.fawe.object.IntPair;
import com.boydti.fawe.object.brush.heightmap.ArrayHeightMap;
import com.boydti.fawe.object.brush.heightmap.FlatScalableHeightMap;
import com.boydti.fawe.object.brush.heightmap.HeightMap;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector3;
import com.sk89q.worldedit.world.block.BlockState;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;

public class ScalableHeightMap
implements HeightMap {
    public int size2;
    public int size;

    public ScalableHeightMap() {
        this.setSize(5);
    }

    public ScalableHeightMap(int size) {
        this.setSize(size);
    }

    @Override
    public void setSize(int size) {
        this.size = size;
        this.size2 = size * size;
    }

    @Override
    public double getHeight(int x, int z) {
        int dz;
        int dx = Math.abs(x);
        int d2 = dx * dx + (dz = Math.abs(z)) * dz;
        if (d2 > this.size2) {
            return 0.0;
        }
        return Math.max(0.0f, (float)this.size - MathMan.sqrtApprox(d2));
    }

    public static ScalableHeightMap fromShape(Shape shape) {
        switch (shape) {
            default: {
                return new ScalableHeightMap();
            }
            case CYLINDER: 
        }
        return new FlatScalableHeightMap();
    }

    public static ScalableHeightMap fromClipboard(Clipboard clipboard) {
        BlockVector3 dim = clipboard.getDimensions();
        byte[][] heightArray = new byte[dim.getBlockX()][dim.getBlockZ()];
        int minX = clipboard.getMinimumPoint().getBlockX();
        int minZ = clipboard.getMinimumPoint().getBlockZ();
        int minY = clipboard.getMinimumPoint().getBlockY();
        int maxY = clipboard.getMaximumPoint().getBlockY();
        int clipHeight = maxY - minY + 1;
        HashSet<IntPair> visited = new HashSet<IntPair>();
        for (BlockVector3 pos : clipboard.getRegion()) {
            IntPair pair = new IntPair(pos.getBlockX(), pos.getBlockZ());
            if (visited.contains(pair)) continue;
            visited.add(pair);
            int xx = pos.getBlockX();
            int zz = pos.getBlockZ();
            int highestY = minY;
            MutableBlockVector3 bv = new MutableBlockVector3(pos);
            for (int y = minY; y <= maxY; ++y) {
                bv.mutY(y);
                BlockState block = clipboard.getBlock(bv);
                if (block.getBlockType().getMaterial().isAir()) continue;
                highestY = y + 1;
            }
            int pointHeight = Math.min(255, 256 * (highestY - minY) / clipHeight);
            int x = xx - minX;
            int z = zz - minZ;
            heightArray[x][z] = (byte)pointHeight;
        }
        return new ArrayHeightMap(heightArray);
    }

    public static ScalableHeightMap fromPNG(InputStream stream) throws IOException {
        BufferedImage heightFile = MainUtil.readImage(stream);
        int width = heightFile.getWidth();
        int length = heightFile.getHeight();
        Raster data = heightFile.getData();
        byte[][] array = new byte[width][length];
        double third = 0.3333333333333333;
        double alphaInverse = 0.00392156862745098;
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                int pixel = heightFile.getRGB(x, z);
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel >> 0 & 0xFF;
                int alpha = pixel >> 24 & 0xFF;
                int intensity = (int)((double)alpha * ((double)(red + green + blue) * third) * alphaInverse);
                array[x][z] = (byte)intensity;
            }
        }
        return new ArrayHeightMap(array);
    }

    public static enum Shape {
        CONE,
        CYLINDER;

    }
}

