/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush.visualization.cfi;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.brush.visualization.cfi.HeightMapMCAGenerator;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.TextureUtil;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;

public final class CFIDrawer {
    private final HeightMapMCAGenerator gen;
    private final TextureUtil tu;
    private final ForkJoinPool pool;

    public CFIDrawer(HeightMapMCAGenerator generator, TextureUtil textureUtil) {
        this.gen = generator;
        this.tu = textureUtil;
        this.pool = new ForkJoinPool();
    }

    public CFIDrawer(HeightMapMCAGenerator generator) {
        this(generator, Fawe.get().getCachedTextureUtil(false, 0, 100));
    }

    public BufferedImage draw() {
        BufferedImage img = new BufferedImage(this.gen.getWidth(), this.gen.getLength(), 1);
        char[] overlay = this.gen.overlay == null ? this.gen.floor.get() : this.gen.overlay.get();
        char[] floor = this.gen.floor.get();
        char[] main = this.gen.main.get();
        byte[] heights = this.gen.heights.get();
        byte[] biomes = this.gen.biomes.get();
        int waterHeight = this.gen.primitives.waterHeight;
        int width = this.gen.getWidth();
        int length = this.gen.getLength();
        int[] raw = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int parallelism = this.pool.getParallelism();
        int size = (heights.length + parallelism - 1) / parallelism;
        for (int i = 0; i < parallelism; ++i) {
            int start = i * size;
            int end = Math.min(heights.length, start + size);
            this.pool.submit(() -> {
                for (int index = start; index < end; ++index) {
                    int color;
                    int height = heights[index] & 0xFF;
                    char ordinal = overlay[index];
                    if (ordinal == '\u0000') {
                        --height;
                        ordinal = floor[index];
                        if (ordinal == '\u0000') {
                            --height;
                            ordinal = main[index];
                        }
                    }
                    switch (ordinal >> 4) {
                        case 2: {
                            color = this.getAverageBiomeColor(biomes, width, index);
                            break;
                        }
                        case 78: {
                            color = 0xDDDDDD;
                            break;
                        }
                        default: {
                            color = this.tu.getColor(BlockTypes.getFromStateOrdinal(ordinal));
                        }
                    }
                    int slope = this.getSlope(heights, width, index, height);
                    if (slope != 0) {
                        slope = (slope << 3) + (slope << 2);
                        int r = MathMan.clamp((color >> 16 & 0xFF) + slope, 0, 255);
                        int g = MathMan.clamp((color >> 8 & 0xFF) + slope, 0, 255);
                        int b = MathMan.clamp((color >> 0 & 0xFF) + slope, 0, 255);
                        color = (r << 16) + (g << 8) + (b << 0);
                    }
                    if (height + 1 < waterHeight) {
                        char waterId = this.gen.primitives.waterOrdinal;
                        boolean waterColor = false;
                        switch (waterId) {
                            case '\u0237': {
                                color = this.tu.averageColor(0x1166CC, color);
                                break;
                            }
                            case '\u011e': {
                                color = 0xCC3300;
                                break;
                            }
                            default: {
                                color = this.tu.getColor(BlockTypes.getFromStateOrdinal(waterId));
                            }
                        }
                    }
                    raw[index] = color;
                }
            });
        }
        this.pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        this.pool.shutdownNow();
        return img;
    }

    private final int getAverageBiomeColor(byte[] biomes, int width, int index) {
        int c0 = this.tu.getBiome((int)(biomes[index] & 0xFF)).grassCombined;
        int c2 = this.getBiome(biomes, index + 1 + width, index);
        int c1 = this.getBiome(biomes, index - 1 - width, index);
        int r = (c0 >> 16 & 0xFF) + (c1 >> 16 & 0xFF) + (c2 >> 16 & 0xFF);
        int g = (c0 >> 8 & 0xFF) + (c1 >> 8 & 0xFF) + (c2 >> 8 & 0xFF);
        int b = (c0 & 0xFF) + (c1 & 0xFF) + (c2 & 0xFF);
        r = r * 85 >> 8;
        g = g * 85 >> 8;
        b = b * 85 >> 8;
        return (r << 16) + (g << 8) + b;
    }

    private final int getBiome(byte[] biomes, int newIndex, int index) {
        if (newIndex < 0 || newIndex >= biomes.length) {
            newIndex = index;
        }
        int biome = biomes[newIndex] & 0xFF;
        return this.tu.getBiome((int)biome).grassCombined;
    }

    private int getSlope(byte[] heights, int width, int index, int height) {
        return this.getHeight(heights, index + 1, height) + this.getHeight(heights, index + width + 1, height) - this.getHeight(heights, index - 1, height) - this.getHeight(heights, index - width - 1, height);
    }

    private int getHeight(byte[] heights, int index, int height) {
        if (index < 0 || index >= heights.length) {
            return height;
        }
        return heights[index] & 0xFF;
    }
}

