/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush.visualization.cfi;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.IBlocks;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.beta.implementation.blocks.FallbackChunkGet;
import com.boydti.fawe.beta.implementation.filter.block.ArrayFilterBlock;
import com.boydti.fawe.beta.implementation.packet.ChunkPacket;
import com.boydti.fawe.jnbt.anvil.MCAChunk;
import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.Metadatable;
import com.boydti.fawe.object.brush.visualization.VirtualWorld;
import com.boydti.fawe.object.brush.visualization.cfi.CFIDrawer;
import com.boydti.fawe.object.brush.visualization.cfi.MCAWriter;
import com.boydti.fawe.object.change.StreamChange;
import com.boydti.fawe.object.changeset.CFIChangeSet;
import com.boydti.fawe.object.collection.DifferentialArray;
import com.boydti.fawe.object.collection.DifferentialBlockBuffer;
import com.boydti.fawe.object.collection.LocalBlockVector2DSet;
import com.boydti.fawe.object.collection.SummedAreaTable;
import com.boydti.fawe.object.exception.FaweChunkLoadException;
import com.boydti.fawe.util.CachedTextureUtil;
import com.boydti.fawe.util.RandomTextureUtil;
import com.boydti.fawe.util.ReflectionUtils;
import com.boydti.fawe.util.TextureUtil;
import com.boydti.fawe.util.image.Drawable;
import com.boydti.fawe.util.image.ImageViewer;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.util.Identifiable;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class HeightMapMCAGenerator
extends MCAWriter
implements StreamChange,
Drawable,
VirtualWorld {
    private final MutableBlockVector3 mutable = new MutableBlockVector3();
    private final DifferentialBlockBuffer blocks;
    protected final DifferentialArray<byte[]> heights;
    protected final DifferentialArray<byte[]> biomes;
    protected final DifferentialArray<char[]> floor;
    protected final DifferentialArray<char[]> main;
    protected DifferentialArray<char[]> overlay;
    protected Metadatable metaData = new Metadatable();
    protected TextureUtil textureUtil;
    protected final CFIPrimitives primitives = new CFIPrimitives();
    private CFIPrimitives oldPrimitives = new CFIPrimitives();
    private ImageViewer viewer;
    private Player player;
    private BlockVector2 chunkOffset = BlockVector2.ZERO;
    private EditSession editSession;

    @Override
    public void flush() {
    }

    @Override
    public void flushChanges(FaweOutputStream out) throws IOException {
        this.heights.flushChanges(out);
        this.biomes.flushChanges(out);
        this.floor.flushChanges(out);
        this.main.flushChanges(out);
        out.writeBoolean(this.overlay != null);
        if (this.overlay != null) {
            this.overlay.flushChanges(out);
        }
        try {
            for (Field field : ReflectionUtils.sortFields(CFIPrimitives.class.getDeclaredFields())) {
                Object now = field.get(this.primitives);
                Object old = field.get(this.oldPrimitives);
                boolean diff = old != now;
                out.writeBoolean(diff);
                if (!diff) continue;
                out.writePrimitive(old);
                out.writePrimitive(now);
            }
            this.resetPrimitives();
        }
        catch (Throwable neverHappens) {
            neverHappens.printStackTrace();
        }
        this.blocks.flushChanges(out);
    }

    public boolean isModified() {
        return this.blocks.isModified() || this.heights.isModified() || this.biomes.isModified() || this.overlay != null && this.overlay.isModified() || !this.primitives.equals(this.oldPrimitives);
    }

    private void resetPrimitives() throws CloneNotSupportedException {
        this.oldPrimitives = (CFIPrimitives)this.primitives.clone();
    }

    @Override
    public void undoChanges(FaweInputStream in) throws IOException {
        this.heights.undoChanges(in);
        this.biomes.undoChanges(in);
        this.floor.undoChanges(in);
        this.main.undoChanges(in);
        if (in.readBoolean()) {
            this.overlay.undoChanges(in);
        }
        try {
            for (Field field : ReflectionUtils.sortFields(CFIPrimitives.class.getDeclaredFields())) {
                if (!in.readBoolean()) continue;
                field.set(this.primitives, in.readPrimitive(field.getType()));
                in.readPrimitive(field.getType());
            }
            this.resetPrimitives();
        }
        catch (Throwable neverHappens) {
            neverHappens.printStackTrace();
        }
        this.blocks.undoChanges(in);
    }

    @Override
    public void redoChanges(FaweInputStream in) throws IOException {
        this.heights.redoChanges(in);
        this.biomes.redoChanges(in);
        this.floor.redoChanges(in);
        this.main.redoChanges(in);
        if (in.readBoolean()) {
            this.overlay.redoChanges(in);
        }
        try {
            for (Field field : ReflectionUtils.sortFields(CFIPrimitives.class.getDeclaredFields())) {
                if (!in.readBoolean()) continue;
                in.readPrimitive(field.getType());
                field.set(this.primitives, in.readPrimitive(field.getType()));
            }
            this.resetPrimitives();
        }
        catch (Throwable neverHappens) {
            neverHappens.printStackTrace();
        }
        this.blocks.clearChanges();
    }

    public void addEditSession(EditSession session) {
        session.setFastMode(true);
        this.editSession = session;
    }

    public HeightMapMCAGenerator(BufferedImage img, File regionFolder) {
        this(img.getWidth(), img.getHeight(), regionFolder);
        this.setHeight(img);
    }

    public HeightMapMCAGenerator(int width, int length, File regionFolder) {
        super(width, length, regionFolder);
        this.blocks = new DifferentialBlockBuffer(width, length);
        this.heights = new DifferentialArray<byte[]>(new byte[this.getArea()]);
        this.biomes = new DifferentialArray<byte[]>(new byte[this.getArea()]);
        this.floor = new DifferentialArray<char[]>(new char[this.getArea()]);
        this.main = new DifferentialArray<char[]>(new char[this.getArea()]);
        char stone = BlockTypes.STONE.getDefaultState().getOrdinalChar();
        char grass = BlockTypes.GRASS_BLOCK.getDefaultState().getOrdinalChar();
        Arrays.fill(this.main.getCharArray(), stone);
        Arrays.fill(this.floor.getCharArray(), grass);
    }

    public Metadatable getMetaData() {
        return this.metaData;
    }

    @Override
    public Vector3 getOrigin() {
        return Vector3.at(this.chunkOffset.getBlockX() << 4, 0.0, this.chunkOffset.getBlockZ() << 4);
    }

    public boolean hasPacketViewer() {
        return this.player != null;
    }

    public void setPacketViewer(Player player) {
        this.player = player;
        if (player != null) {
            Location pos = player.getLocation();
            this.chunkOffset = BlockVector2.at(1 + (pos.getBlockX() >> 4), 1 + (pos.getBlockZ() >> 4));
        }
    }

    public Player getOwner() {
        return this.player;
    }

    private char[][][] getChunkArray(int x, int z) {
        char[][][][][] blocksData = this.blocks.get();
        if (blocksData == null) {
            return null;
        }
        char[][][][] arr = blocksData[z];
        return arr != null ? arr[x] : (char[][][])null;
    }

    public void setImageViewer(ImageViewer viewer) {
        this.viewer = viewer;
    }

    public ImageViewer getImageViewer() {
        return this.viewer;
    }

    @Override
    public void update() {
        if (this.viewer != null) {
            this.viewer.view(this);
        }
        if (this.chunkOffset != null && this.player != null) {
            World world = this.player.getWorld();
            int lenCX = this.getWidth() + 15 >> 4;
            int lenCZ = this.getLength() + 15 >> 4;
            Location position = this.player.getLocation();
            int pcx = (position.getBlockX() >> 4) - this.chunkOffset.getBlockX();
            int pcz = (position.getBlockZ() >> 4) - this.chunkOffset.getBlockZ();
            int scx = Math.max(0, pcx - 15);
            int scz = Math.max(0, pcz - 15);
            int ecx = Math.min(lenCX - 1, pcx + 15);
            int ecz = Math.min(lenCZ - 1, pcz + 15);
            for (int chunkZ = scz; chunkZ <= ecz; ++chunkZ) {
                for (int chunkX = scx; chunkX <= ecx; ++chunkX) {
                    this.refreshChunk(world, chunkX, chunkZ);
                }
            }
        }
    }

    public void refreshChunk(World world, int chunkX, int chunkZ) {
        Supplier<IBlocks> blocksSupplier = () -> this.getChunk(chunkX, chunkZ);
        int realChunkX = chunkX + this.chunkOffset.getBlockX();
        int realChunkZ = chunkZ + this.chunkOffset.getBlockZ();
        ChunkPacket packet = new ChunkPacket(realChunkX, realChunkZ, blocksSupplier, true);
        world.sendFakeChunk(this.player, packet);
    }

    @Override
    public void sendFakeChunk(@Nullable Player player, ChunkPacket packet) {
        if (this.player != null) {
            player.getWorld().sendFakeChunk(player, packet);
        }
    }

    @Override
    public void refreshChunk(int chunkX, int chunkZ) {
        if (this.chunkOffset != null && this.player != null) {
            this.refreshChunk(this.player.getWorld(), chunkX, chunkZ);
        }
    }

    public IChunkSet getChunk(int chunkX, int chunkZ) {
        MCAChunk tmp = new MCAChunk();
        int bx = chunkX << 4;
        int bz = chunkZ << 4;
        this.write(tmp, bx, bx + 15, bz, bz + 15);
        return tmp;
    }

    public TextureUtil getRawTextureUtil() {
        if (this.textureUtil == null) {
            this.textureUtil = Fawe.get().getTextureUtil();
        }
        return this.textureUtil;
    }

    public TextureUtil getTextureUtil() {
        if (this.textureUtil == null) {
            this.textureUtil = Fawe.get().getTextureUtil();
        }
        try {
            if (this.primitives.randomVariation) {
                return new RandomTextureUtil(this.textureUtil);
            }
            if (this.textureUtil instanceof CachedTextureUtil) {
                return this.textureUtil;
            }
            return new CachedTextureUtil(this.textureUtil);
        }
        catch (FileNotFoundException neverHappens) {
            neverHappens.printStackTrace();
            return null;
        }
    }

    public void setBedrock(BlockState bedrock) {
        this.primitives.bedrockOrdinal = bedrock.getOrdinalChar();
    }

    public void setFloorThickness(int floorThickness) {
        this.primitives.floorThickness = floorThickness;
    }

    public void setWorldThickness(int height) {
        this.primitives.worldThickness = height;
    }

    public void setWaterHeight(int waterHeight) {
        this.primitives.waterHeight = waterHeight;
    }

    public void setWater(BlockState water) {
        this.primitives.waterOrdinal = water.getOrdinalChar();
    }

    public void setTextureRandomVariation(boolean randomVariation) {
        this.primitives.randomVariation = randomVariation;
    }

    public boolean getTextureRandomVariation() {
        return this.primitives.randomVariation;
    }

    public void setTextureUtil(TextureUtil textureUtil) {
        this.textureUtil = textureUtil;
    }

    public void smooth(BufferedImage img, boolean white, int radius, int iterations) {
        this.smooth(img, null, white, radius, iterations);
    }

    public void smooth(Mask mask, int radius, int iterations) {
        this.smooth(null, mask, false, radius, iterations);
    }

    public void smooth(BlockVector2 min, BlockVector2 max, int radius, int iterations) {
        char snowLayer = BlockTypes.SNOW.getDefaultState().getOrdinalChar();
        char snowBlock = BlockTypes.SNOW_BLOCK.getDefaultState().getOrdinalChar();
        char[] floor = this.floor.get();
        byte[] heights = this.heights.get();
        int width = this.getWidth();
        int length = this.getLength();
        int minX = min.getBlockX();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxZ = max.getBlockZ();
        int tableWidth = maxX - minX + 1;
        int tableLength = maxZ - minZ + 1;
        int smoothArea = tableWidth * tableLength;
        long[] copy = new long[smoothArea];
        char[] layers = new char[smoothArea];
        SummedAreaTable table = new SummedAreaTable(copy, layers, tableWidth, radius);
        for (int j = 0; j < iterations; ++j) {
            int localIndex = 0;
            int zIndex = minZ * this.getWidth();
            int z = minZ;
            while (z <= maxZ) {
                int index = zIndex + minX;
                int x = minX;
                while (x <= maxX) {
                    char combined = floor[index];
                    layers[localIndex] = BlockTypes.getFromStateOrdinal(combined) == BlockTypes.SNOW ? (char)(((heights[index] & 0xFF) << 3) + (floor[index] >> BlockTypesCache.BIT_OFFSET) - 7) : (char)((heights[index] & 0xFF) << 3);
                    ++x;
                    ++index;
                    ++localIndex;
                }
                ++z;
                zIndex += this.getWidth();
            }
            table.processSummedAreaTable();
            localIndex = 0;
            zIndex = minZ * this.getWidth();
            z = minZ;
            int localZ = 0;
            while (z <= maxZ) {
                int index = zIndex + minX;
                int x = minX;
                int localX = 0;
                while (x <= maxX) {
                    int y = heights[index] & 0xFF;
                    int newHeight = table.average(localX, localZ, localIndex);
                    this.setLayerHeight(index, newHeight);
                    ++x;
                    ++localX;
                    ++index;
                    ++localIndex;
                }
                ++z;
                ++localZ;
                zIndex += this.getWidth();
            }
        }
    }

    private final void setLayerHeight(int index, int height) {
        int blockHeight = height >> 3;
        int layerHeight = height & 7;
        this.setLayerHeight(index, blockHeight, layerHeight);
    }

    private final void setLayerHeight(int index, int blockHeight, int layerHeight) {
        char floorState = this.floor.get()[index];
        switch (floorState) {
            case '\u01fd': 
            case '\u01fe': {
                if (layerHeight != 0) {
                    this.heights.setByte(index, (byte)(blockHeight + 1));
                    this.floor.setInt(index, BlockTypes.SNOW.getDefaultState().getOrdinalChar() + layerHeight);
                    break;
                }
                this.heights.setByte(index, (byte)blockHeight);
                this.floor.setInt(index, BlockTypes.SNOW_BLOCK.getDefaultState().getOrdinalChar());
                break;
            }
            default: {
                this.heights.setByte(index, (byte)blockHeight);
            }
        }
    }

    private final void setLayerHeightRaw(int index, int height) {
        int blockHeight = height >> 3;
        int layerHeight = height & 7;
        this.setLayerHeightRaw(index, blockHeight, layerHeight);
    }

    private final void setLayerHeightRaw(int index, int blockHeight, int layerHeight) {
        char floorState = this.floor.get()[index];
        switch (floorState) {
            case '\u01fd': 
            case '\u01fe': {
                if (layerHeight != 0) {
                    this.heights.getByteArray()[index] = (byte)(blockHeight + 1);
                    this.overlay.getCharArray()[index] = (char)(BlockTypes.SNOW.getDefaultState().getOrdinalChar() + layerHeight);
                    break;
                }
                this.heights.getByteArray()[index] = (byte)blockHeight;
                this.overlay.getCharArray()[index] = BlockTypes.SNOW_BLOCK.getDefaultState().getOrdinalChar();
                break;
            }
            default: {
                this.heights.getByteArray()[index] = (byte)blockHeight;
            }
        }
    }

    private void smooth(BufferedImage img, Mask mask, boolean white, int radius, int iterations) {
        char[] floor = this.floor.get();
        byte[] heights = this.heights.get();
        long[] copy = new long[heights.length];
        char[] layers = new char[heights.length];
        this.floor.record(() -> this.heights.record(() -> {
            int width = this.getWidth();
            int length = this.getLength();
            SummedAreaTable table = new SummedAreaTable(copy, layers, width, radius);
            for (int j = 0; j < iterations; ++j) {
                int newHeight;
                int x;
                int z;
                for (int i = 0; i < heights.length; ++i) {
                    char combined = floor[i];
                    layers[i] = BlockTypes.getFromStateOrdinal(combined) == BlockTypes.SNOW ? (char)(((heights[i] & 0xFF) << 3) + (floor[i] >> BlockTypesCache.BIT_OFFSET) - 7) : (char)((heights[i] & 0xFF) << 3);
                }
                int index = 0;
                table.processSummedAreaTable();
                if (img != null) {
                    for (z = 0; z < this.getLength(); ++z) {
                        x = 0;
                        while (x < this.getWidth()) {
                            int height = img.getRGB(x, z) & 0xFF;
                            if (height == 255 || height > 0 && !white && ThreadLocalRandom.current().nextInt(256) <= height) {
                                newHeight = table.average(x, z, index);
                                this.setLayerHeightRaw(index, newHeight);
                            }
                            ++x;
                            ++index;
                        }
                    }
                    continue;
                }
                if (mask != null) {
                    for (z = 0; z < this.getLength(); ++z) {
                        this.mutable.mutZ(z);
                        x = 0;
                        while (x < this.getWidth()) {
                            int y = heights[index] & 0xFF;
                            this.mutable.mutX(x);
                            this.mutable.mutY(y);
                            if (mask.test(this.mutable)) {
                                newHeight = table.average(x, z, index);
                                this.setLayerHeightRaw(index, newHeight);
                            }
                            ++x;
                            ++index;
                        }
                    }
                    continue;
                }
                for (z = 0; z < this.getLength(); ++z) {
                    x = 0;
                    while (x < this.getWidth()) {
                        int newHeight2 = table.average(x, z, index);
                        this.setLayerHeightRaw(index, newHeight2);
                        ++x;
                        ++index;
                    }
                }
            }
        }));
    }

    public void setHeight(BufferedImage img) {
        int index = 0;
        for (int z = 0; z < this.getLength(); ++z) {
            int x = 0;
            while (x < this.getWidth()) {
                this.heights.setByte(index, (byte)(img.getRGB(x, z) >> 8));
                ++x;
                ++index;
            }
        }
    }

    public void addCaves() throws WorldEditException {
        CuboidRegion region = new CuboidRegion(BlockVector3.at(0, 0, 0), BlockVector3.at(this.getWidth() - 1, 255, this.getLength() - 1));
        this.addCaves(region);
    }

    @Deprecated
    public void addSchems(Mask mask, List<ClipboardHolder> clipboards, int rarity, boolean rotate) throws WorldEditException {
        CuboidRegion region = new CuboidRegion(BlockVector3.at(0, 0, 0), BlockVector3.at(this.getWidth() - 1, 255, this.getLength() - 1));
        this.addSchems(region, mask, clipboards, rarity, rotate);
    }

    public void addSchems(BufferedImage img, Mask mask, List<ClipboardHolder> clipboards, int rarity, int distance, boolean randomRotate) throws WorldEditException {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        double doubleRarity = (double)rarity / 100.0;
        int index = 0;
        AffineTransform identity = new AffineTransform();
        LocalBlockVector2DSet placed = new LocalBlockVector2DSet();
        block0: for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                int height = img.getRGB(x, z) & 0xFF;
                if (height != 0 && !((double)ThreadLocalRandom.current().nextInt(256) > (double)height * doubleRarity)) {
                    this.mutable.mutX(x);
                    this.mutable.mutY(y);
                    if (mask.test(this.mutable) && !placed.containsRadius(x, z, distance)) {
                        placed.add(x, z);
                        ClipboardHolder holder = clipboards.get(ThreadLocalRandom.current().nextInt(clipboards.size()));
                        if (randomRotate) {
                            int rotate = ThreadLocalRandom.current().nextInt(4) * 90;
                            if (rotate != 0) {
                                holder.setTransform(new AffineTransform().rotateY(ThreadLocalRandom.current().nextInt(4) * 90));
                            } else {
                                holder.setTransform(identity);
                            }
                        }
                        Clipboard clipboard = holder.getClipboard();
                        Transform transform = holder.getTransform();
                        if (transform.isIdentity()) {
                            clipboard.paste(this, this.mutable, false);
                        } else {
                            clipboard.paste(this, this.mutable, false, transform);
                        }
                        if (x + distance >= this.getWidth()) continue block0;
                        x += distance;
                        index += distance;
                    }
                }
                ++x;
                ++index;
            }
        }
    }

    public void addSchems(Mask mask, List<ClipboardHolder> clipboards, int rarity, int distance, boolean randomRotate) throws WorldEditException {
        int scaledRarity = 256 * rarity / 100;
        int index = 0;
        AffineTransform identity = new AffineTransform();
        LocalBlockVector2DSet placed = new LocalBlockVector2DSet();
        block0: for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                if (ThreadLocalRandom.current().nextInt(256) <= scaledRarity) {
                    this.mutable.mutX(x);
                    this.mutable.mutY(y);
                    if (mask.test(this.mutable) && !placed.containsRadius(x, z, distance)) {
                        this.mutable.mutY(y + 1);
                        placed.add(x, z);
                        ClipboardHolder holder = clipboards.get(ThreadLocalRandom.current().nextInt(clipboards.size()));
                        if (randomRotate) {
                            int rotate = ThreadLocalRandom.current().nextInt(4) * 90;
                            if (rotate != 0) {
                                holder.setTransform(new AffineTransform().rotateY(ThreadLocalRandom.current().nextInt(4) * 90));
                            } else {
                                holder.setTransform(identity);
                            }
                        }
                        Clipboard clipboard = holder.getClipboard();
                        Transform transform = holder.getTransform();
                        if (transform.isIdentity()) {
                            clipboard.paste(this, this.mutable, false);
                        } else {
                            clipboard.paste(this, this.mutable, false, transform);
                        }
                        if (x + distance >= this.getWidth()) continue block0;
                        x += distance;
                        index += distance;
                    }
                }
                ++x;
                ++index;
            }
        }
    }

    public void addOre(Mask mask, Pattern material, int size, int frequency, int rarity, int minY, int maxY) throws WorldEditException {
        CuboidRegion region = new CuboidRegion(BlockVector3.at(0, 0, 0), BlockVector3.at(this.getWidth() - 1, 255, this.getLength() - 1));
        this.addOre(region, mask, material, size, frequency, rarity, minY, maxY);
    }

    public void addDefaultOres(Mask mask) throws WorldEditException {
        this.addOres(new CuboidRegion(BlockVector3.at(0, 0, 0), BlockVector3.at(this.getWidth() - 1, 255, this.getLength() - 1)), mask);
    }

    @Override
    public BlockVector3 getMinimumPoint() {
        return BlockVector3.at(0, 0, 0);
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public BlockVector3 getMaximumPoint() {
        return BlockVector3.at(this.getWidth() - 1, 255, this.getLength() - 1);
    }

    @Override
    public Set<SideEffect> applySideEffects(BlockVector3 position, BlockState previousType, SideEffectSet sideEffectSet) throws WorldEditException {
        return SideEffectSet.none().getSideEffectsToApply();
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block) throws WorldEditException {
        return this.setBlock(position.getBlockX(), position.getBlockY(), position.getBlockZ(), block);
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, SideEffectSet sideEffects) throws WorldEditException {
        return this.setBlock(position.getBlockX(), position.getBlockY(), position.getBlockZ(), block);
    }

    private boolean setBlock(int x, int y, int z, char combined) {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            return false;
        }
        int height = this.heights.getByte(index) & 0xFF;
        switch (y - height) {
            case 0: {
                this.floor.setInt(index, combined);
                return true;
            }
            case 1: {
                char mainId = this.overlay.getChar(index);
                char floorId = this.overlay.getChar(index);
                this.floor.setInt(index, combined);
                byte currentHeight = this.heights.getByte(index);
                currentHeight = (byte)(currentHeight + 1);
                this.heights.setByte(index, currentHeight);
                if (mainId == floorId) {
                    return true;
                }
                --y;
                combined = floorId;
            }
        }
        try {
            this.blocks.set(x, y, z, combined);
            return true;
        }
        catch (IndexOutOfBoundsException ignored) {
            return false;
        }
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            return false;
        }
        this.biomes.setByte(index, (byte)biome.getInternalId());
        return true;
    }

    @Override
    @Nullable
    public Path getStoragePath() {
        return this.getFolder().toPath();
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public boolean regenerateChunk(int x, int z, @Nullable BiomeType biome, @Nullable Long seed) {
        return false;
    }

    @Override
    @Nullable
    public Operation commit() {
        EditSession curES = this.editSession;
        if (curES != null && this.isModified()) {
            try {
                this.update();
                Player esPlayer = curES.getPlayer();
                UUID uuid = esPlayer != null ? esPlayer.getUniqueId() : Identifiable.CONSOLE;
                try {
                    curES.setRawChangeSet(new CFIChangeSet(this, uuid));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void close(boolean update) {
        if (this.chunkOffset != null && this.player != null && update) {
            World world = this.player.getWorld();
            int lenCX = this.getWidth() + 15 >> 4;
            int lenCZ = this.getLength() + 15 >> 4;
            int OX = this.chunkOffset.getBlockX();
            int OZ = this.chunkOffset.getBlockZ();
            Location position = this.player.getLocation();
            int pcx = (position.getBlockX() >> 4) - OX;
            int pcz = (position.getBlockZ() >> 4) - OZ;
            int scx = Math.max(0, pcx - 10);
            int scz = Math.max(0, pcz - 10);
            int ecx = Math.min(lenCX - 1, pcx + 10);
            int ecz = Math.min(lenCZ - 1, pcz + 10);
            for (int cz = scz; cz <= ecz; ++cz) {
                for (int cx = scx; cx <= ecx; ++cx) {
                    world.refreshChunk(cx + OX, cz + OZ);
                }
            }
        }
        if (this.player != null) {
            this.player.deleteMeta("CFISettings");
            LocalSession session = this.player.getSession();
            session.clearHistory();
        }
        this.player = null;
        this.chunkOffset = null;
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) throws FaweChunkLoadException {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            index = Math.floorMod(index, this.getArea());
        }
        return BiomeTypes.get(this.biomes.getByte(index));
    }

    public int getOrdinal(int x, int y, int z) throws FaweChunkLoadException {
        int combined;
        short chunkZ;
        short chunkX;
        char[][][] map;
        int index = z * this.getWidth() + x;
        if (y < 0) {
            return 0;
        }
        if (index < 0 || index >= this.getArea() || x < 0 || x >= this.getWidth()) {
            return 0;
        }
        int height = this.heights.getByte(index) & 0xFF;
        if (y > height) {
            int combined2;
            short chunkZ2;
            short chunkX2;
            char[][][] map2;
            if (y == height + 1) {
                return this.overlay != null ? (int)this.overlay.getChar(index) : 0;
            }
            if (this.blocks != null && (map2 = this.getChunkArray(chunkX2 = (short)(x >> 4), chunkZ2 = (short)(z >> 4))) != null && (combined2 = this.get(map2, x, y, z)) != 0) {
                return combined2;
            }
            if (y <= this.primitives.waterHeight) {
                return this.primitives.waterOrdinal;
            }
            return 0;
        }
        if (y == height) {
            return this.overlay.getChar(index);
        }
        if (this.blocks != null && (map = this.getChunkArray(chunkX = (short)(x >> 4), chunkZ = (short)(z >> 4))) != null && (combined = this.get(map, x, y, z)) != 0) {
            return combined;
        }
        return this.overlay.getChar(index);
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x, int y, int z, B block) throws WorldEditException {
        return this.setBlock(x, y, z, block.getOrdinalChar());
    }

    @Override
    public BiomeType getBiome(BlockVector3 position) {
        return this.getBiomeType(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        return this.getBlock(position.getX(), position.getY(), position.getZ());
    }

    public BlockState getFloor(int x, int z) {
        int index = z * this.getWidth() + x;
        return BlockState.getFromOrdinal(this.overlay.getChar(index));
    }

    public int getHeight(int x, int z) {
        int index = z * this.getWidth() + x;
        return this.heights.getByte(index) & 0xFF;
    }

    public int getHeight(int index) {
        return this.heights.getByte(index) & 0xFF;
    }

    public <B extends BlockStateHolder<B>> void setFloor(int x, int z, B block) {
        int index = z * this.getWidth() + x;
        this.floor.setInt(index, block.getOrdinalChar());
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return BlockState.getFromOrdinal(this.getOrdinal(x, y, z));
    }

    @Override
    public int getNearestSurfaceLayer(int x, int z, int y, int minY, int maxY) {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            index = Math.floorMod(index, this.getArea());
        }
        return ((this.heights.getByte(index) & 0xFF) << 3) + (this.overlay.getChar(index) & 0xFF) + 1;
    }

    @Override
    public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY) {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            index = Math.floorMod(index, this.getArea());
        }
        return this.heights.getByte(index) & 0xFF;
    }

    @Override
    public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY, int failedMin, int failedMax) {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            index = Math.floorMod(index, this.getArea());
        }
        return this.heights.getByte(index) & 0xFF;
    }

    public void setBiome(final BufferedImage img, BiomeType biome, final boolean white) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        final byte biomeByte = (byte)biome.getInternalId();
        this.biomes.record(new Runnable(){

            @Override
            public void run() {
                byte[] biomeArr = HeightMapMCAGenerator.this.biomes.get();
                int index = 0;
                for (int z = 0; z < HeightMapMCAGenerator.this.getLength(); ++z) {
                    int x = 0;
                    while (x < HeightMapMCAGenerator.this.getWidth()) {
                        int height = img.getRGB(x, z) & 0xFF;
                        if (height == 255 || height > 0 && !white && ThreadLocalRandom.current().nextInt(256) <= height) {
                            biomeArr[index] = biomeByte;
                        }
                        ++x;
                        ++index;
                    }
                }
            }
        });
    }

    @Override
    public BufferedImage draw() {
        return new CFIDrawer(this).draw();
    }

    public void setBiomePriority(int value) {
        this.primitives.biomePriority = value * 65536 / 100 - 32768;
    }

    public int getBiomePriority() {
        return (this.primitives.biomePriority + 32768) * 100 / 65536;
    }

    public void setBlockAndBiomeColor(BufferedImage img, Mask mask, BufferedImage imgMask, boolean whiteOnly) {
        if (mask == null && imgMask == null) {
            this.setBlockAndBiomeColor(img);
            return;
        }
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        TextureUtil textureUtil = this.getTextureUtil();
        int widthIndex = img.getWidth() - 1;
        int heightIndex = img.getHeight() - 1;
        int maxIndex = this.getArea() - 1;
        this.biomes.record(() -> this.floor.record(() -> this.main.record(() -> {
            char[] mainArr = this.main.get();
            char[] floorArr = this.floor.get();
            byte[] biomesArr = this.biomes.get();
            int index = 0;
            char[] buffer = new char[2];
            for (int z = 0; z < img.getHeight(); ++z) {
                this.mutable.mutZ(z);
                int x = 0;
                while (x < img.getWidth()) {
                    block8: {
                        int height;
                        block7: {
                            if (mask == null) break block7;
                            this.mutable.mutX(z);
                            this.mutable.mutY(this.heights.getByte(index) & 0xFF);
                            if (!mask.test(this.mutable)) break block8;
                        }
                        if (imgMask == null || (height = imgMask.getRGB(x, z) & 0xFF) == 255 || height > 0 && whiteOnly && ThreadLocalRandom.current().nextInt(256) <= height) {
                            int color = img.getRGB(x, z);
                            if (textureUtil.getIsBlockCloserThanBiome(buffer, color, this.primitives.biomePriority)) {
                                char combined;
                                mainArr[index] = combined = buffer[0];
                                floorArr[index] = combined;
                            }
                            biomesArr[index] = (byte)buffer[1];
                        }
                    }
                    ++x;
                    ++index;
                }
            }
        })));
    }

    public void setBlockAndBiomeColor(BufferedImage img) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        TextureUtil textureUtil = this.getTextureUtil();
        int heightIndex = img.getHeight() - 1;
        this.biomes.record(() -> this.floor.record(() -> this.main.record(() -> {
            char[] mainArr = this.main.get();
            char[] floorArr = this.floor.get();
            byte[] biomesArr = this.biomes.get();
            char[] buffer = new char[2];
            int index = 0;
            for (int y = 0; y < img.getHeight(); ++y) {
                int x = 0;
                while (x < img.getWidth()) {
                    int color = img.getRGB(x, y);
                    if (textureUtil.getIsBlockCloserThanBiome(buffer, color, this.primitives.biomePriority)) {
                        char combined;
                        mainArr[index] = combined = buffer[0];
                        floorArr[index] = combined;
                    }
                    biomesArr[index] = (byte)buffer[1];
                    ++x;
                    ++index;
                }
            }
        })));
    }

    public void setBiomeColor(BufferedImage img) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        TextureUtil textureUtil = this.getTextureUtil();
        this.biomes.record(() -> {
            byte[] biomesArr = this.biomes.get();
            int index = 0;
            for (int y = 0; y < img.getHeight(); ++y) {
                for (int x = 0; x < img.getWidth(); ++x) {
                    int color = img.getRGB(x, y);
                    TextureUtil.BiomeColor biome = textureUtil.getNearestBiome(color);
                    if (biome != null) {
                        biomesArr[index] = (byte)biome.id;
                    }
                    ++index;
                }
            }
        });
    }

    public void setColor(BufferedImage img, BufferedImage mask, boolean white) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        if (mask.getWidth() != this.getWidth() || mask.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.primitives.modifiedMain = true;
        TextureUtil textureUtil = this.getTextureUtil();
        this.floor.record(() -> this.main.record(() -> {
            char[] mainArr = this.main.get();
            char[] floorArr = this.floor.get();
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                int x = 0;
                while (x < this.getWidth()) {
                    int color;
                    BlockType block;
                    int height = mask.getRGB(x, z) & 0xFF;
                    if ((height == 255 || height > 0 && !white && ThreadLocalRandom.current().nextInt(256) <= height) && (block = textureUtil.getNearestBlock(color = img.getRGB(x, z))) != null) {
                        char combined;
                        mainArr[index] = combined = block.getDefaultState().getOrdinalChar();
                        floorArr[index] = combined;
                    }
                    ++x;
                    ++index;
                }
            }
        }));
    }

    public void setColor(BufferedImage img, Mask mask) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.primitives.modifiedMain = true;
        TextureUtil textureUtil = this.getTextureUtil();
        this.floor.record(() -> this.main.record(() -> {
            char[] mainArr = this.main.get();
            char[] floorArr = this.floor.get();
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                this.mutable.mutZ(z);
                int x = 0;
                while (x < this.getWidth()) {
                    int color;
                    BlockType block;
                    this.mutable.mutX(x);
                    this.mutable.mutY(this.heights.getByte(index) & 0xFF);
                    if (mask.test(this.mutable) && (block = textureUtil.getNearestBlock(color = img.getRGB(x, z))) != null) {
                        char combined;
                        mainArr[index] = combined = block.getDefaultState().getOrdinalChar();
                        floorArr[index] = combined;
                    }
                    ++x;
                    ++index;
                }
            }
        }));
    }

    public void setColor(BufferedImage img) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.primitives.modifiedMain = true;
        TextureUtil textureUtil = this.getTextureUtil();
        this.floor.record(() -> this.main.record(() -> {
            char[] mainArr = this.main.get();
            char[] floorArr = this.floor.get();
            int index = 0;
            for (int z = 0; z < img.getHeight(); ++z) {
                for (int x = 0; x < img.getWidth(); ++x) {
                    int color = img.getRGB(x, z);
                    BlockType block = textureUtil.getNearestBlock(color);
                    if (block != null) {
                        char combined;
                        mainArr[index] = combined = block.getDefaultState().getOrdinalChar();
                        floorArr[index] = combined;
                    }
                    ++index;
                }
            }
        }));
    }

    public void setColorWithGlass(BufferedImage img) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        TextureUtil textureUtil = this.getTextureUtil();
        this.floor.record(() -> this.main.record(() -> {
            char[] mainArr = this.main.get();
            char[] floorArr = this.floor.get();
            int index = 0;
            for (int y = 0; y < img.getHeight(); ++y) {
                for (int x = 0; x < img.getWidth(); ++x) {
                    int color = img.getRGB(x, y);
                    BlockType[] layer = textureUtil.getNearestLayer(color);
                    if (layer != null) {
                        floorArr[index] = layer[0].getDefaultState().getOrdinalChar();
                        mainArr[index] = layer[1].getDefaultState().getOrdinalChar();
                    }
                    ++index;
                }
            }
        }));
    }

    public void setBiome(Mask mask, BiomeType biome) {
        int index = 0;
        byte biomeByte = (byte)biome.getInternalId();
        for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                this.mutable.mutX(x);
                this.mutable.mutY(y);
                if (mask.test(this.mutable)) {
                    this.biomes.setByte(index, biomeByte);
                }
                ++x;
                ++index;
            }
        }
    }

    public void setOverlay(BufferedImage img, Pattern pattern, boolean white) {
        if (pattern instanceof BlockStateHolder) {
            this.setOverlay(img, ((BlockStateHolder)pattern).getOrdinalChar(), white);
        } else if (pattern instanceof BlockType) {
            this.setOverlay(img, ((BlockType)pattern).getDefaultState().getOrdinalChar(), white);
        } else {
            if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
                throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
            }
            if (this.overlay == null) {
                this.overlay = new DifferentialArray<char[]>(new char[this.getArea()]);
            }
            this.overlay.record(() -> {
                ArrayFilterBlock filter = new ArrayFilterBlock(this, this.overlay.get(), this.heights.get(), this.getWidth(), this.getLength(), 1);
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        int height = img.getRGB(x, z) & 0xFF;
                        if (height == 255 || height > 0 && !white && ThreadLocalRandom.current().nextInt(256) <= height) {
                            filter.init(x, z, index);
                            pattern.apply(this, filter, filter);
                        }
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setMain(BufferedImage img, Pattern pattern, boolean white) {
        if (pattern instanceof BlockStateHolder) {
            this.setMain(img, ((BlockStateHolder)pattern).getOrdinalChar(), white);
        } else {
            if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
                throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
            }
            this.primitives.modifiedMain = true;
            this.main.record(() -> {
                ArrayFilterBlock filter = new ArrayFilterBlock(this, this.main.get(), this.heights.get(), this.getWidth(), this.getLength(), -1);
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        int height = img.getRGB(x, z) & 0xFF;
                        if (height == 255 || height > 0 && !white && ThreadLocalRandom.current().nextInt(256) <= height) {
                            filter.init(x, z, index);
                            pattern.apply(this, filter, filter);
                        }
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setFloor(BufferedImage img, Pattern pattern, boolean white) {
        if (pattern instanceof BlockStateHolder) {
            this.setFloor(img, ((BlockStateHolder)pattern).getOrdinalChar(), white);
        } else {
            if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
                throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
            }
            this.floor.record(() -> {
                ArrayFilterBlock filter = new ArrayFilterBlock(this, this.floor.get(), this.heights.get(), this.getWidth(), this.getLength(), 1);
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        int height = img.getRGB(x, z) & 0xFF;
                        if (height == 255 || height > 0 && !white && ThreadLocalRandom.current().nextInt(256) <= height) {
                            filter.init(x, z, index);
                            pattern.apply(this, filter, filter);
                        }
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setColumn(BufferedImage img, Pattern pattern, boolean white) {
        if (pattern instanceof BlockStateHolder) {
            this.setColumn(img, ((BlockStateHolder)pattern).getOrdinalChar(), white);
        } else {
            if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
                throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
            }
            this.primitives.modifiedMain = true;
            this.main.record(() -> this.floor.record(() -> {
                ArrayFilterBlock filterFloor = new ArrayFilterBlock(this, this.floor.get(), this.heights.get(), this.getWidth(), this.getLength(), 0);
                ArrayFilterBlock filterMain = new ArrayFilterBlock(this, this.main.get(), this.heights.get(), this.getWidth(), this.getLength(), -1);
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        int height = img.getRGB(x, z) & 0xFF;
                        if (height == 255 || height > 0 && !white && ThreadLocalRandom.current().nextInt(256) <= height) {
                            filterFloor.init(x, z, index);
                            filterMain.init(x, z, index);
                            pattern.apply(this, filterFloor, filterFloor);
                            pattern.apply(this, filterMain, filterMain);
                        }
                        ++x;
                        ++index;
                    }
                }
            }));
        }
    }

    public void setOverlay(Mask mask, Pattern pattern) {
        if (pattern instanceof BlockStateHolder) {
            this.setOverlay(mask, ((BlockStateHolder)pattern).getOrdinalChar());
        } else {
            if (this.overlay == null) {
                this.overlay = new DifferentialArray<char[]>(new char[this.getArea()]);
            }
            this.overlay.record(() -> {
                ArrayFilterBlock filter = new ArrayFilterBlock(this, this.overlay.get(), this.heights.get(), this.getWidth(), this.getLength(), 1);
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        filter.init(x, z, index);
                        if (mask.test(filter)) {
                            pattern.apply(this, filter, filter);
                        }
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setFloor(Mask mask, Pattern pattern) {
        if (pattern instanceof BlockStateHolder) {
            this.setFloor(mask, ((BlockStateHolder)pattern).getOrdinalChar());
        } else {
            this.floor.record(() -> {
                ArrayFilterBlock filter = new ArrayFilterBlock(this, this.floor.get(), this.heights.get(), this.getWidth(), this.getLength(), 0);
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        filter.init(x, z, index);
                        if (mask.test(filter)) {
                            pattern.apply(this, filter, filter);
                        }
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setMain(Mask mask, Pattern pattern) {
        if (pattern instanceof BlockStateHolder) {
            this.setMain(mask, ((BlockStateHolder)pattern).getOrdinalChar());
        } else {
            this.main.record(() -> {
                ArrayFilterBlock filter = new ArrayFilterBlock(this, this.main.get(), this.heights.get(), this.getWidth(), this.getLength(), -1);
                this.primitives.modifiedMain = true;
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        if (mask.test(filter)) {
                            pattern.apply(this, filter, filter);
                        }
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setColumn(Mask mask, Pattern pattern) {
        if (pattern instanceof BlockStateHolder) {
            this.setColumn(mask, ((BlockStateHolder)pattern).getOrdinalChar());
        } else {
            this.floor.record(() -> this.main.record(() -> {
                ArrayFilterBlock floorFilter = new ArrayFilterBlock(this, this.floor.get(), this.heights.get(), this.getWidth(), this.getLength(), 0);
                ArrayFilterBlock mainFilter = new ArrayFilterBlock(this, this.main.get(), this.heights.get(), this.getWidth(), this.getLength(), -1);
                this.primitives.modifiedMain = true;
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        floorFilter.init(x, z, index);
                        mainFilter.init(x, z, index);
                        if (mask.test(mainFilter)) {
                            pattern.apply(this, mainFilter, mainFilter);
                        }
                        if (mask.test(floorFilter)) {
                            pattern.apply(this, floorFilter, floorFilter);
                        }
                        ++x;
                        ++index;
                    }
                }
            }));
        }
    }

    public void setBiome(BiomeType biome) {
        this.biomes.record(() -> Arrays.fill(this.biomes.get(), (byte)biome.getInternalId()));
    }

    public void setFloor(Pattern value) {
        if (value instanceof BlockStateHolder) {
            this.setFloor(((BlockStateHolder)value).getOrdinalChar());
        } else {
            this.floor.record(() -> {
                ArrayFilterBlock filter = new ArrayFilterBlock(this, this.floor.get(), this.heights.get(), this.getWidth(), this.getLength(), 0);
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        filter.init(x, z, index);
                        value.apply(this, filter, filter);
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setColumn(Pattern value) {
        if (value instanceof BlockStateHolder) {
            this.setColumn(((BlockStateHolder)value).getOrdinalChar());
        } else {
            this.main.record(() -> this.floor.record(() -> {
                ArrayFilterBlock floorFilter = new ArrayFilterBlock(this, this.floor.get(), this.heights.get(), this.getWidth(), this.getLength(), 0);
                ArrayFilterBlock mainFilter = new ArrayFilterBlock(this, this.main.get(), this.heights.get(), this.getWidth(), this.getLength(), -1);
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        floorFilter.init(x, z, index);
                        mainFilter.init(x, z, index);
                        value.apply(this, floorFilter, floorFilter);
                        value.apply(this, mainFilter, mainFilter);
                        ++x;
                        ++index;
                    }
                }
            }));
        }
    }

    public void setMain(Pattern value) {
        if (value instanceof BlockStateHolder) {
            this.setMain(((BlockStateHolder)value).getOrdinalChar());
        } else {
            this.main.record(() -> {
                ArrayFilterBlock filter = new ArrayFilterBlock(this, this.main.get(), this.heights.get(), this.getWidth(), this.getLength(), -1);
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        filter.init(x, z, index);
                        value.apply(this, filter, filter);
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setOverlay(Pattern value) {
        if (this.overlay == null) {
            this.overlay = new DifferentialArray<char[]>(new char[this.getArea()]);
        }
        if (value instanceof BlockStateHolder) {
            this.setOverlay(((BlockStateHolder)value).getOrdinalChar());
        } else {
            this.overlay.record(() -> {
                ArrayFilterBlock filter = new ArrayFilterBlock(this, this.overlay.get(), this.heights.get(), this.getWidth(), this.getLength(), 1);
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        filter.init(x, z, index);
                        value.apply(this, filter, filter);
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setHeight(int x, int z, int height) {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            return;
        }
        this.heights.setByte(index, (byte)height);
    }

    public void setHeight(int index, int height) {
        this.heights.setByte(index, (byte)height);
    }

    public void setHeights(int value) {
        this.heights.record(() -> Arrays.fill(this.heights.get(), (byte)value));
    }

    @Override
    public boolean shouldWrite(int chunkX, int chunkZ) {
        return true;
    }

    @Override
    public MCAChunk write(MCAChunk chunk, int csx, int cex, int csz, int cez) {
        byte[] heights = this.heights.get();
        byte[] biomes = this.biomes.get();
        char[] main = this.main.get();
        char[] floor = this.floor.get();
        char[] overlay = this.overlay != null ? this.overlay.get() : null;
        try {
            int layer;
            boolean hasFloorThickness;
            int maxIndex;
            boolean hasOverlay;
            int index;
            int globalIndex;
            int[] indexes = (int[])FaweCache.IMP.INDEX_STORE.get();
            int maxY = 0;
            int minY = Integer.MAX_VALUE;
            int[] heightMap = (int[])FaweCache.IMP.HEIGHT_STORE.get();
            for (int z = csz; z <= cez; ++z) {
                globalIndex = z * this.getWidth() + csx;
                index = (z & 0xF) << 4;
                int x = csx;
                while (x <= cex) {
                    int height;
                    indexes[index] = globalIndex;
                    heightMap[index] = height = heights[globalIndex] & 0xFF;
                    maxY = Math.max(maxY, height);
                    minY = Math.min(minY, height);
                    ++x;
                    ++index;
                    ++globalIndex;
                }
            }
            boolean bl = hasOverlay = this.overlay != null;
            if (hasOverlay) {
                ++maxY;
            }
            int maxLayer = maxY >> 4;
            for (int layer2 = 0; layer2 <= maxLayer; ++layer2) {
                chunk.hasSections[layer2] = true;
            }
            if (this.primitives.waterHeight != 0) {
                maxIndex = this.primitives.waterHeight << 8;
                Arrays.fill(chunk.blocks, 0, maxIndex, this.primitives.waterOrdinal);
            }
            if (this.primitives.modifiedMain) {
                for (int z = csz; z <= cez; ++z) {
                    index = (z & 0xF) << 4;
                    int x = csx;
                    while (x <= cex) {
                        globalIndex = indexes[index];
                        char mainCombined = main[globalIndex];
                        for (int y = 0; y < minY; ++y) {
                            chunk.blocks[index + (y << 8)] = mainCombined;
                        }
                        ++x;
                        ++index;
                    }
                }
            } else {
                maxIndex = minY << 8;
                Arrays.fill(chunk.blocks, 0, maxIndex, '\u0210');
            }
            boolean bl2 = hasFloorThickness = this.primitives.floorThickness != 0 || this.primitives.worldThickness != 0;
            if (this.primitives.worldThickness != 0) {
                int endLayer = minY - this.primitives.worldThickness + 1 >> 4;
                for (layer = 0; layer < endLayer; ++layer) {
                    chunk.hasSections[layer] = false;
                }
            }
            for (int z = csz; z <= cez; ++z) {
                index = (z & 0xF) << 4;
                int x = csx;
                while (x <= cex) {
                    int height;
                    globalIndex = indexes[index];
                    int maxMainY = height = heightMap[index];
                    int minMainY = minY;
                    char mainCombined = main[globalIndex];
                    char floorCombined = floor[globalIndex];
                    if (hasFloorThickness) {
                        int y;
                        if (x > 0) {
                            maxMainY = Math.min(heights[globalIndex - 1] & 0xFF, maxMainY);
                        }
                        if (x < this.getWidth() - 1) {
                            maxMainY = Math.min(heights[globalIndex + 1] & 0xFF, maxMainY);
                        }
                        if (z > 0) {
                            maxMainY = Math.min(heights[globalIndex - this.getWidth()] & 0xFF, maxMainY);
                        }
                        if (z < this.getLength() - 1) {
                            maxMainY = Math.min(heights[globalIndex + this.getWidth()] & 0xFF, maxMainY);
                        }
                        int min = maxMainY;
                        if (this.primitives.floorThickness != 0) {
                            for (y = maxMainY = Math.max(0, maxMainY - (this.primitives.floorThickness - 1)); y <= height; ++y) {
                                chunk.blocks[index + (y << 8)] = floorCombined;
                            }
                        } else {
                            chunk.blocks[index + (height << 8)] = floorCombined;
                        }
                        if (this.primitives.worldThickness != 0) {
                            minMainY = Math.max(minY, min - this.primitives.worldThickness + 1);
                            for (y = minY; y < minMainY; ++y) {
                                chunk.blocks[index + (y << 8)] = '\u0001';
                            }
                        }
                    } else {
                        chunk.blocks[index + (height << 8)] = floorCombined;
                    }
                    for (int y = minMainY; y < maxMainY; ++y) {
                        chunk.blocks[index + (y << 8)] = mainCombined;
                    }
                    if (hasOverlay) {
                        char overlayCombined = overlay[globalIndex];
                        int overlayIndex = index + (height + 1 << 8);
                        chunk.blocks[overlayIndex] = overlayCombined;
                    }
                    if (this.primitives.bedrockOrdinal != '\u0000') {
                        chunk.blocks[index] = this.primitives.bedrockOrdinal;
                    }
                    ++x;
                    ++index;
                }
            }
            char[][][] localBlocks = this.getChunkArray(chunk.getX(), chunk.getZ());
            if (localBlocks != null) {
                index = 0;
                for (layer = 0; layer < 16; ++layer) {
                    int by = layer << 4;
                    int ty = by + 15;
                    int y = by;
                    while (y <= ty) {
                        char[][] yBlocks = localBlocks[y];
                        if (yBlocks != null) {
                            chunk.hasSections[layer] = true;
                            for (int z = 0; z < yBlocks.length; ++z) {
                                char[] zBlocks = yBlocks[z];
                                if (zBlocks == null) continue;
                                int zIndex = index + (z << 4);
                                int x = 0;
                                while (x < zBlocks.length) {
                                    char combined = zBlocks[x];
                                    if (combined != '\u0000') {
                                        chunk.blocks[zIndex] = combined;
                                    }
                                    ++x;
                                    ++zIndex;
                                }
                            }
                        }
                        ++y;
                        index += 256;
                    }
                }
            }
            for (int i = 0; i < 256; ++i) {
                byte biomeId = biomes[indexes[i]];
                if (biomeId == 0) continue;
                chunk.biomes[i] = BiomeTypes.get(biomeId);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return chunk;
    }

    private void setUnsafe(char[][][] map, char combined, int x, int y, int z) {
        char[] zMap;
        Object yMap = map[y];
        if (yMap == null) {
            char[][] cArrayArray = new char[16][];
            yMap = cArrayArray;
            map[y] = cArrayArray;
        }
        if ((zMap = yMap[z]) == null) {
            zMap = new char[16];
            yMap[z] = zMap;
        }
        zMap[x] = combined;
    }

    private int get(char[][][] map, int x, int y, int z) {
        char[][] yMap = map[y];
        if (yMap == null) {
            return 0;
        }
        char[] zMap = yMap[z & 0xF];
        if (zMap == null) {
            return 0;
        }
        return zMap[x & 0xF];
    }

    private void setOverlay(Mask mask, int combined) {
        int index = 0;
        if (this.overlay == null) {
            this.overlay = new DifferentialArray<char[]>(new char[this.getArea()]);
        }
        for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                this.mutable.mutX(x);
                this.mutable.mutY(y);
                if (mask.test(this.mutable)) {
                    this.overlay.setInt(index, combined);
                }
                ++x;
                ++index;
            }
        }
    }

    private void setFloor(Mask mask, int combined) {
        int index = 0;
        for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                this.mutable.mutX(x);
                this.mutable.mutY(y);
                if (mask.test(this.mutable)) {
                    this.floor.setInt(index, combined);
                }
                ++x;
                ++index;
            }
        }
    }

    private void setMain(Mask mask, int combined) {
        this.primitives.modifiedMain = true;
        int index = 0;
        for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                this.mutable.mutX(x);
                this.mutable.mutY(y);
                if (mask.test(this.mutable)) {
                    this.main.setInt(index, combined);
                }
                ++x;
                ++index;
            }
        }
    }

    private void setColumn(Mask mask, int combined) {
        this.primitives.modifiedMain = true;
        int index = 0;
        for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                this.mutable.mutX(x);
                this.mutable.mutY(y);
                if (mask.test(this.mutable)) {
                    this.floor.setInt(index, combined);
                    this.main.setInt(index, combined);
                }
                ++x;
                ++index;
            }
        }
    }

    private void setFloor(char value) {
        this.floor.record(() -> Arrays.fill(this.floor.get(), value));
    }

    private void setColumn(char value) {
        this.setFloor(value);
        this.setMain(value);
    }

    private void setMain(char value) {
        this.primitives.modifiedMain = true;
        this.main.record(() -> Arrays.fill(this.main.get(), value));
    }

    private void setOverlay(char value) {
        if (this.overlay == null) {
            this.overlay = new DifferentialArray<char[]>(new char[this.getArea()]);
        }
        this.overlay.record(() -> Arrays.fill(this.overlay.get(), value));
    }

    private void setOverlay(BufferedImage img, char combined, boolean white) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        if (this.overlay == null) {
            this.overlay = new DifferentialArray<char[]>(new char[this.getArea()]);
        }
        this.overlay.record(() -> {
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                int x = 0;
                while (x < this.getWidth()) {
                    int height = img.getRGB(x, z) & 0xFF;
                    if (height == 255 || height > 0 && white && ThreadLocalRandom.current().nextInt(256) <= height) {
                        this.overlay.get()[index] = combined;
                    }
                    ++x;
                    ++index;
                }
            }
        });
    }

    private void setMain(BufferedImage img, char combined, boolean white) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.primitives.modifiedMain = true;
        this.main.record(() -> {
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                int x = 0;
                while (x < this.getWidth()) {
                    int height = img.getRGB(x, z) & 0xFF;
                    if (height == 255 || height > 0 && !white && ThreadLocalRandom.current().nextInt(256) <= height) {
                        this.main.get()[index] = combined;
                    }
                    ++x;
                    ++index;
                }
            }
        });
    }

    private void setFloor(BufferedImage img, char combined, boolean white) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.floor.record(() -> {
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                int x = 0;
                while (x < this.getWidth()) {
                    int height = img.getRGB(x, z) & 0xFF;
                    if (height == 255 || height > 0 && !white && ThreadLocalRandom.current().nextInt(256) <= height) {
                        this.floor.get()[index] = combined;
                    }
                    ++x;
                    ++index;
                }
            }
        });
    }

    private void setColumn(BufferedImage img, char combined, boolean white) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.primitives.modifiedMain = true;
        this.main.record(() -> this.floor.record(() -> {
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                int x = 0;
                while (x < this.getWidth()) {
                    int height = img.getRGB(x, z) & 0xFF;
                    if (height == 255 || height > 0 && !white && ThreadLocalRandom.current().nextInt(256) <= height) {
                        this.main.get()[index] = combined;
                        this.floor.get()[index] = combined;
                    }
                    ++x;
                    ++index;
                }
            }
        }));
    }

    @Override
    public int getMaxY() {
        return 255;
    }

    @Override
    public String getName() {
        File folder = this.getFolder();
        if (folder != null) {
            String name = folder.getName();
            if (name.equalsIgnoreCase("region")) {
                return folder.getParentFile().getName();
            }
            return name;
        }
        return Integer.toString(this.hashCode());
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, boolean notifyAndLight) throws WorldEditException {
        return this.setBlock(position, block);
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tile) throws WorldEditException {
        return false;
    }

    @Override
    public int getBlockLightLevel(BlockVector3 position) {
        return 0;
    }

    @Override
    public boolean clearContainerBlockContents(BlockVector3 position) {
        return false;
    }

    @Override
    public boolean regenerate(Region region, EditSession editSession) {
        return false;
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, BlockVector3 position) throws MaxChangedBlocksException {
        return false;
    }

    @Override
    public void dropItem(Vector3 position, BaseItemStack item) {
    }

    @Override
    public boolean playEffect(Vector3 position, int type, int data) {
        return false;
    }

    @Override
    public boolean notifyAndLightBlock(BlockVector3 position, BlockState previousType) throws WorldEditException {
        return false;
    }

    @Override
    public BlockVector3 getSpawnPosition() {
        return null;
    }

    @Override
    public IChunkGet get(int x, int z) {
        LoggerFactory.getLogger(HeightMapMCAGenerator.class).debug("Should not be using buffering with HMMG");
        return new FallbackChunkGet(this, x, z);
    }

    public final class CFIPrimitives
    implements Cloneable {
        int waterHeight;
        int floorThickness;
        int worldThickness;
        boolean randomVariation = true;
        int biomePriority;
        char waterOrdinal = BlockTypes.WATER.getDefaultState().getOrdinalChar();
        char bedrockOrdinal = BlockTypes.BEDROCK.getDefaultState().getOrdinalChar();
        boolean modifiedMain;

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CFIPrimitives)) {
                return false;
            }
            try {
                for (Field field : CFIPrimitives.class.getDeclaredFields()) {
                    if (field.get(this) == field.get(obj)) continue;
                    return false;
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return true;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

