/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush.visualization.cfi;

import com.boydti.fawe.jnbt.anvil.MCAChunk;
import com.boydti.fawe.object.collection.CleanableThreadLocal;
import com.boydti.fawe.object.io.BufferedRandomAccessFile;
import com.boydti.fawe.util.MainUtil;
import com.sk89q.worldedit.bukkit.fastutil.io.FastByteArrayOutputStream;
import com.sk89q.worldedit.extent.Extent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;

public abstract class MCAWriter
implements Extent {
    private File folder;
    private final int length;
    private final int width;
    private final int area;
    private int OX;
    private int OZ;

    public MCAWriter(int width, int length, File regionFolder) {
        this.folder = regionFolder;
        this.width = width;
        this.length = length;
        this.area = width * length;
    }

    public final File getFolder() {
        return this.folder;
    }

    public void setFolder(File folder) {
        this.folder = folder;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getLength() {
        return this.length;
    }

    public void setMCAOffset(int mcaOX, int mcaOZ) {
        this.OX = mcaOX << 9;
        this.OZ = mcaOZ << 9;
    }

    public int getOffsetX() {
        return this.OX;
    }

    public int getOffsetZ() {
        return this.OZ;
    }

    public final int getArea() {
        return this.area;
    }

    public abstract boolean shouldWrite(int var1, int var2);

    public abstract MCAChunk write(MCAChunk var1, int var2, int var3, int var4, int var5);

    private static CleanableThreadLocal<MCAChunk> createCache() {
        return new CleanableThreadLocal<MCAChunk>(() -> {
            MCAChunk chunk = new MCAChunk();
            Arrays.fill(chunk.blocks, '\u0001');
            return chunk;
        });
    }

    public void generate() throws IOException {
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        ForkJoinPool pool = new ForkJoinPool();
        int tcx = this.width - 1 >> 4;
        int tcz = this.length - 1 >> 4;
        try (CleanableThreadLocal<MCAChunk> chunkStore = MCAWriter.createCache();){
            ThreadLocal<byte[]> byteStore1 = ThreadLocal.withInitial(() -> new byte[500000]);
            ThreadLocal<byte[]> byteStore2 = ThreadLocal.withInitial(() -> new byte[500000]);
            ThreadLocal<Deflater> deflateStore = ThreadLocal.withInitial(() -> new Deflater(1, false));
            byte[] fileBuf = new byte[65536];
            int mcaXMin = 0;
            int mcaZMin = 0;
            int mcaXMax = mcaXMin + (this.width - 1 >> 9);
            int mcaZMax = mcaZMin + (this.length - 1 >> 9);
            byte[] header = new byte[4096];
            for (int mcaZ = mcaXMin; mcaZ <= mcaZMax; ++mcaZ) {
                for (int mcaX = mcaXMin; mcaX <= mcaXMax; ++mcaX) {
                    File file = new File(this.folder, "r." + (mcaX + (this.getOffsetX() >> 9)) + "." + (mcaZ + (this.getOffsetZ() >> 9)) + ".mca");
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    BufferedRandomAccessFile raf = new BufferedRandomAccessFile(file, "rw", fileBuf);
                    byte[][] compressed = new byte[1024][];
                    int bx = mcaX << 9;
                    int bz = mcaZ << 9;
                    int scx = bx >> 4;
                    int ecx = Math.min(scx + 31, tcx);
                    int scz = bz >> 4;
                    int ecz = Math.min(scz + 31, tcz);
                    for (int cz = scz; cz <= ecz; ++cz) {
                        int csz = cz << 4;
                        int cez = Math.min(csz + 15, this.length - 1);
                        for (int cx = scx; cx <= ecx; ++cx) {
                            int csx = cx << 4;
                            int cex = Math.min(csx + 15, this.width - 1);
                            int fcx = cx;
                            int fcz = cz;
                            if (!this.shouldWrite(cx, cz)) continue;
                            pool.submit(() -> {
                                try {
                                    MCAChunk chunk = (MCAChunk)chunkStore.get();
                                    chunk.reset();
                                    chunk.setPosition(fcx, fcz);
                                    chunk = this.write(chunk, csx, cex, csz, cez);
                                    if (chunk != null) {
                                        chunk.setPosition(fcx + (this.getOffsetX() >> 4), fcz + (this.getOffsetZ() >> 4));
                                        FastByteArrayOutputStream uncompressed = chunk.toBytes((byte[])byteStore1.get());
                                        int len = uncompressed.length;
                                        uncompressed.reset();
                                        MainUtil.compress(uncompressed.array, len, (byte[])byteStore2.get(), uncompressed, (Deflater)deflateStore.get());
                                        byte[] clone = Arrays.copyOf(uncompressed.array, uncompressed.length);
                                        compressed[(fcx & 0x1F) + ((fcz & 0x1F) << 5)] = clone;
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            });
                        }
                    }
                    pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    pool.submit(() -> {
                        try {
                            int totalLength = 8192;
                            for (byte[] compressedBytes : compressed) {
                                if (compressedBytes == null) continue;
                                int blocks = (4095 + compressedBytes.length + 5) / 4096 * 4096;
                                totalLength += blocks;
                            }
                            raf.setLength(totalLength);
                            int offset = 8192;
                            for (int i = 0; i < compressed.length; ++i) {
                                byte[] compressedBytes = compressed[i];
                                if (compressedBytes == null) continue;
                                int index = i << 2;
                                int offsetMedium = offset >> 12;
                                int blocks = (4095 + compressedBytes.length + 5) / 4096;
                                header[index] = (byte)(offsetMedium >> 16);
                                header[index + 1] = (byte)(offsetMedium >> 8);
                                header[index + 2] = (byte)(offsetMedium >> 0);
                                header[index + 3] = (byte)blocks;
                                raf.seek(offset);
                                raf.writeInt(compressedBytes.length + 1);
                                raf.write(2);
                                raf.write(compressedBytes);
                                offset += blocks * 4096;
                            }
                            raf.seek(0L);
                            raf.write(header);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            try {
                                raf.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
            pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            pool.shutdown();
            CleanableThreadLocal.clean(byteStore1);
            CleanableThreadLocal.clean(byteStore2);
            CleanableThreadLocal.clean(deflateStore);
        }
    }
}

