/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.change;

import com.boydti.fawe.object.brush.visualization.cfi.HeightMapMCAGenerator;
import com.boydti.fawe.util.ExtentTraverser;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;

public class CFIChange
implements Change {
    private final File file;

    public CFIChange(File file) {
        Preconditions.checkNotNull((Object)file);
        this.file = file;
    }

    private HeightMapMCAGenerator getQueue(UndoContext context) {
        ExtentTraverser<HeightMapMCAGenerator> found = new ExtentTraverser<Extent>(context.getExtent()).find(HeightMapMCAGenerator.class);
        if (found != null) {
            return found.get();
        }
        LoggerFactory.getLogger(CFIChange.class).debug("FAWE does not support: " + context.getExtent() + " for " + this.getClass() + " (bug Empire92)");
        return null;
    }

    @Override
    public void undo(UndoContext context) throws WorldEditException {
        HeightMapMCAGenerator queue = this.getQueue(context);
        if (queue != null) {
            try {
                queue.undoChanges(this.file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            queue.update();
        }
    }

    @Override
    public void redo(UndoContext context) throws WorldEditException {
        HeightMapMCAGenerator queue = this.getQueue(context);
        if (queue != null) {
            try {
                queue.redoChanges(this.file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            queue.update();
        }
    }
}

