/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.changeset;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.IBatchProcessor;
import com.boydti.fawe.beta.IChunk;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.beta.implementation.processors.ProcessorScope;
import com.boydti.fawe.object.HistoryExtent;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.TaskManager;
import com.google.common.util.concurrent.Futures;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.history.change.BlockChange;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.history.change.EntityCreate;
import com.sk89q.worldedit.history.change.EntityRemove;
import com.sk89q.worldedit.history.changeset.ChangeSet;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractChangeSet
implements ChangeSet,
IBatchProcessor {
    private final World world;
    protected AtomicInteger waitingCombined = new AtomicInteger(0);
    protected AtomicInteger waitingAsync = new AtomicInteger(0);
    protected boolean closed;

    public AbstractChangeSet(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public void closeAsync() {
        if (this.closed) {
            return;
        }
        this.waitingAsync.incrementAndGet();
        TaskManager.IMP.async(() -> {
            this.waitingAsync.decrementAndGet();
            AtomicInteger atomicInteger = this.waitingAsync;
            synchronized (atomicInteger) {
                this.waitingAsync.notifyAll();
            }
            try {
                this.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush() {
        try {
            AtomicInteger atomicInteger;
            if (!Fawe.isMainThread()) {
                while (this.waitingAsync.get() > 0) {
                    atomicInteger = this.waitingAsync;
                    synchronized (atomicInteger) {
                        this.waitingAsync.wait(1000L);
                    }
                }
            }
            while (this.waitingCombined.get() > 0) {
                atomicInteger = this.waitingCombined;
                synchronized (atomicInteger) {
                    this.waitingCombined.wait(1000L);
                }
            }
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.closed = true;
        }
    }

    public abstract void add(int var1, int var2, int var3, int var4, int var5);

    @Override
    public Iterator<Change> backwardIterator() {
        return this.getIterator(false);
    }

    @Override
    public Iterator<Change> forwardIterator() {
        return this.getIterator(true);
    }

    @Override
    public Extent construct(Extent child) {
        return new HistoryExtent(child, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        void var10_18;
        Set<CompoundTag> ents;
        Set<UUID> entRemoves;
        int bx = chunk.getX() << 4;
        int bz = chunk.getZ() << 4;
        Map<BlockVector3, CompoundTag> tilesFrom = get.getTiles();
        Map<BlockVector3, CompoundTag> tilesTo = set.getTiles();
        if (!tilesFrom.isEmpty()) {
            for (Map.Entry<BlockVector3, CompoundTag> entry : tilesFrom.entrySet()) {
                BlockState toBlock;
                BlockVector3 blockVector3 = entry.getKey();
                BlockState fromBlock = get.getBlock(blockVector3.getX() & 0xF, blockVector3.getY(), blockVector3.getZ() & 0xF);
                if (fromBlock == (toBlock = set.getBlock(blockVector3.getX() & 0xF, blockVector3.getY(), blockVector3.getZ() & 0xF)) && !tilesTo.containsKey(blockVector3)) continue;
                this.addTileRemove(entry.getValue());
            }
        }
        if (!tilesTo.isEmpty()) {
            for (Map.Entry<BlockVector3, CompoundTag> entry : tilesTo.entrySet()) {
                BlockVector3 blockVector3 = entry.getKey();
                this.addTileCreate(MainUtil.setPosition(entry.getValue(), blockVector3.getX() + bx, blockVector3.getY(), blockVector3.getZ() + bz));
            }
        }
        if (!(entRemoves = set.getEntityRemoves()).isEmpty()) {
            for (UUID uUID : entRemoves) {
                CompoundTag found = get.getEntity(uUID);
                if (found == null) continue;
                this.addEntityRemove(found);
            }
        }
        if (!(ents = set.getEntities()).isEmpty()) {
            for (CompoundTag tag : ents) {
                this.addEntityCreate(tag);
            }
        }
        boolean bl = false;
        while (var10_18 < 16) {
            if (set.hasSection((int)var10_18)) {
                char[] blocksGet = get.load((int)var10_18);
                if (blocksGet == null) {
                    blocksGet = FaweCache.IMP.EMPTY_CHAR_4096;
                }
                char[] blocksSet = set.load((int)var10_18);
                void by = var10_18 << 4;
                int index = 0;
                for (int y = 0; y < 16; ++y) {
                    int yy = y + by;
                    for (int z = 0; z < 16; ++z) {
                        int zz = z + bz;
                        int x = 0;
                        while (x < 16) {
                            int xx = bx + x;
                            char from = blocksGet[index];
                            if (from == '\u0000') {
                                from = '\u0001';
                            }
                            char combinedFrom = from;
                            char combinedTo = blocksSet[index];
                            if (combinedTo != '\u0000') {
                                this.add(xx, yy, zz, (int)combinedFrom, combinedTo);
                            }
                            ++x;
                            ++index;
                        }
                    }
                }
            }
            ++var10_18;
        }
        BiomeType[] biomeTypeArray = set.getBiomes();
        if (biomeTypeArray != null) {
            int index = 0;
            for (int y = 0; y < 64; ++y) {
                for (int z = 0; z < 4; ++z) {
                    int x = 0;
                    while (x < 4) {
                        BiomeType oldBiome;
                        BiomeType newBiome = biomeTypeArray[index];
                        if (newBiome != null && (oldBiome = get.getBiomeType(x, y, z)) != newBiome) {
                            this.addBiomeChange(bx + (x << 2), y << 2, bz + (z << 2), oldBiome, newBiome);
                        }
                        ++x;
                        ++index;
                    }
                }
            }
        }
        return set;
    }

    @Override
    public Future<IChunkSet> postProcessSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        return this.addWriteTask(() -> this.processSet(chunk, get, set));
    }

    @Override
    public ProcessorScope getScope() {
        return ProcessorScope.READING_SET_BLOCKS;
    }

    public abstract void addTileCreate(CompoundTag var1);

    public abstract void addTileRemove(CompoundTag var1);

    public abstract void addEntityRemove(CompoundTag var1);

    public abstract void addEntityCreate(CompoundTag var1);

    public abstract void addBiomeChange(int var1, int var2, int var3, BiomeType var4, BiomeType var5);

    public Iterator<Change> getIterator(BlockBag blockBag, int mode, boolean redo) {
        return this.getIterator(redo);
    }

    public abstract Iterator<Change> getIterator(boolean var1);

    public EditSession toEditSession(Player player) {
        return this.toEditSession(player, null);
    }

    public EditSession toEditSession(Player player, Region[] regions) {
        EditSessionBuilder builder = new EditSessionBuilder(this.getWorld()).player(player).autoQueue(false).fastmode(false).checkMemory(false).changeSet(this).limitUnlimited();
        if (regions != null) {
            builder.allowedRegions(regions);
        } else {
            builder.allowedRegionsEverywhere();
        }
        EditSession editSession = builder.build();
        editSession.setSize(1);
        return editSession;
    }

    public void add(EntityCreate change) {
        CompoundTag tag = change.state.getNbtData();
        this.addEntityCreate(MainUtil.setEntityInfo(tag, change.getEntity()));
    }

    public void add(EntityRemove change) {
        CompoundTag tag = change.state.getNbtData();
        this.addEntityRemove(MainUtil.setEntityInfo(tag, change.getEntity()));
    }

    @Override
    public void add(Change change) {
        if (change.getClass() == BlockChange.class) {
            this.add((BlockChange)change);
        } else if (change.getClass() == EntityCreate.class) {
            this.add((EntityCreate)change);
        } else if (change.getClass() == EntityRemove.class) {
            this.add((EntityRemove)change);
        } else {
            LoggerFactory.getLogger(AbstractChangeSet.class).debug("Unknown change: " + change.getClass());
        }
    }

    public void add(BlockChange change) {
        try {
            BlockVector3 loc = change.getPosition();
            BaseBlock from = change.getPrevious();
            BaseBlock to = change.getCurrent();
            this.add(loc, from, to);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.waitingCombined.get() == 0 && this.waitingAsync.get() == 0 && this.size() == 0;
    }

    public void add(BlockVector3 loc, BaseBlock from, BaseBlock to) {
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        this.add(x, y, z, from, to);
    }

    public void add(int x, int y, int z, BaseBlock from, BaseBlock to) {
        try {
            CompoundTag nbt;
            if (from.hasNbtData()) {
                nbt = from.getNbtData();
                assert (nbt != null);
                this.addTileRemove(MainUtil.setPosition(nbt, x, y, z));
            }
            if (to.hasNbtData()) {
                nbt = to.getNbtData();
                assert (nbt != null);
                this.addTileCreate(MainUtil.setPosition(nbt, x, y, z));
            }
            int combinedFrom = from.getOrdinal();
            int combinedTo = to.getOrdinal();
            this.add(x, y, z, combinedFrom, combinedTo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void add(int x, int y, int z, int combinedFrom, BaseBlock to) {
        try {
            if (to.hasNbtData()) {
                CompoundTag nbt = to.getNbtData();
                assert (nbt != null);
                this.addTileCreate(MainUtil.setPosition(nbt, x, y, z));
            }
            int combinedTo = to.getInternalId();
            this.add(x, y, z, combinedFrom, combinedTo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Future<?> addWriteTask(Runnable writeTask) {
        return this.addWriteTask(writeTask, Fawe.isMainThread());
    }

    public Future<?> addWriteTask(Runnable writeTask, boolean completeNow) {
        this.waitingCombined.incrementAndGet();
        Runnable wrappedTask = () -> {
            try {
                writeTask.run();
            }
            finally {
                if (this.waitingCombined.decrementAndGet() <= 0) {
                    AtomicInteger atomicInteger = this.waitingAsync;
                    synchronized (atomicInteger) {
                        this.waitingAsync.notifyAll();
                    }
                    atomicInteger = this.waitingCombined;
                    synchronized (atomicInteger) {
                        this.waitingCombined.notifyAll();
                    }
                }
            }
        };
        if (completeNow) {
            wrappedTask.run();
            return Futures.immediateCancelledFuture();
        }
        return Fawe.get().getQueueHandler().submit(wrappedTask);
    }
}

