/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.changeset;

import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.change.MutableBiomeChange;
import com.boydti.fawe.object.change.MutableBlockChange;
import com.boydti.fawe.object.change.MutableEntityChange;
import com.boydti.fawe.object.change.MutableFullBlockChange;
import com.boydti.fawe.object.change.MutableTileChange;
import com.boydti.fawe.object.changeset.AbstractChangeSet;
import com.boydti.fawe.object.changeset.SimpleChangeSetSummary;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MathMan;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class FaweStreamChangeSet
extends AbstractChangeSet {
    public static final int HEADER_SIZE = 9;
    private int mode;
    private final int compression;
    protected FaweStreamIdDelegate idDel;
    protected FaweStreamPositionDelegate posDel;
    protected int blockSize;
    public int entityCreateSize;
    public int entityRemoveSize;
    public int tileCreateSize;
    public int tileRemoveSize;
    private int originX;
    private int originZ;

    public FaweStreamChangeSet(World world) {
        this(world, Settings.IMP.HISTORY.COMPRESSION_LEVEL, Settings.IMP.HISTORY.STORE_REDO, Settings.IMP.HISTORY.SMALL_EDITS);
    }

    public FaweStreamChangeSet(World world, int compression, boolean storeRedo, boolean smallLoc) {
        super(world);
        this.compression = compression;
        this.init(storeRedo, smallLoc);
    }

    private void init(boolean storeRedo, boolean smallLoc) {
        this.mode = storeRedo ? (smallLoc ? 4 : 3) : (smallLoc ? 1 : 2);
    }

    protected void setupStreamDelegates(int mode) {
        this.mode = mode;
        this.idDel = mode == 3 || mode == 4 ? new FaweStreamIdDelegate(){

            @Override
            public void writeChange(FaweOutputStream stream, int combinedFrom, int combinedTo) throws IOException {
                stream.writeVarInt(combinedFrom);
                stream.writeVarInt(combinedTo);
            }

            @Override
            public void readCombined(FaweInputStream is, MutableBlockChange change, boolean dir) throws IOException {
                if (dir) {
                    is.readVarInt();
                    change.ordinal = is.readVarInt();
                } else {
                    change.ordinal = is.readVarInt();
                    is.readVarInt();
                }
            }

            @Override
            public void readCombined(FaweInputStream is, MutableFullBlockChange change) throws IOException {
                change.from = is.readVarInt();
                change.to = is.readVarInt();
            }
        } : new FaweStreamIdDelegate(){

            @Override
            public void writeChange(FaweOutputStream stream, int combinedFrom, int to) throws IOException {
                stream.writeVarInt(combinedFrom);
            }

            @Override
            public void readCombined(FaweInputStream in, MutableBlockChange change, boolean dir) throws IOException {
                int from1 = in.read();
                int from2 = in.read();
                change.ordinal = in.readVarInt();
            }

            @Override
            public void readCombined(FaweInputStream is, MutableFullBlockChange change) throws IOException {
                change.from = is.readVarInt();
                change.to = BlockTypes.AIR.getInternalId();
            }
        };
        this.posDel = mode == 1 || mode == 4 ? new FaweStreamPositionDelegate(){
            int lx;
            int ly;
            int lz;
            byte[] buffer = new byte[4];

            @Override
            public void write(OutputStream out, int x, int y, int z) throws IOException {
                this.lx = x;
                int rx = -this.lx + this.lx;
                this.ly = y;
                int ry = -this.ly + this.ly;
                this.lz = z;
                int rz = -this.lz + this.lz;
                byte b1 = (byte)ry;
                byte b2 = (byte)rx;
                byte b3 = (byte)rz;
                int x16 = rx >> 8 & 0xF;
                int z16 = rz >> 8 & 0xF;
                byte b4 = MathMan.pair16(x16, z16);
                out.write(b1);
                out.write(b2);
                out.write(b3);
                out.write(b4);
            }

            @Override
            public int readX(FaweInputStream in) throws IOException {
                in.readFully(this.buffer);
                return this.lx += (this.buffer[1] & 0xFF) + (MathMan.unpair16x(this.buffer[3]) << 8) << 20 >> 20;
            }

            @Override
            public int readY(FaweInputStream in) {
                return (this.ly += this.buffer[0]) & 0xFF;
            }

            @Override
            public int readZ(FaweInputStream in) throws IOException {
                return this.lz += (this.buffer[2] & 0xFF) + (MathMan.unpair16y(this.buffer[3]) << 8) << 20 >> 20;
            }
        } : new FaweStreamPositionDelegate(){
            final byte[] buffer = new byte[5];
            int lx;
            int ly;
            int lz;

            @Override
            public void write(OutputStream stream, int x, int y, int z) throws IOException {
                this.lx = x;
                int rx = -this.lx + this.lx;
                this.ly = y;
                int ry = -this.ly + this.ly;
                this.lz = z;
                int rz = -this.lz + this.lz;
                stream.write(rx & 0xFF);
                stream.write(rx >> 8 & 0xFF);
                stream.write(rz & 0xFF);
                stream.write(rz >> 8 & 0xFF);
                stream.write((byte)ry);
            }

            @Override
            public int readX(FaweInputStream is) throws IOException {
                is.readFully(this.buffer);
                this.lx = this.lx + (this.buffer[0] & 0xFF) + (this.buffer[1] << 8);
                return this.lx;
            }

            @Override
            public int readY(FaweInputStream is) throws IOException {
                return (this.ly += this.buffer[4]) & 0xFF;
            }

            @Override
            public int readZ(FaweInputStream is) throws IOException {
                this.lz = this.lz + (this.buffer[2] & 0xFF) + (this.buffer[3] << 8);
                return this.lz;
            }
        };
    }

    public void writeHeader(OutputStream os, int x, int y, int z) throws IOException {
        os.write(this.mode);
        this.setOrigin(x, z);
        os.write((byte)(x >> 24));
        os.write((byte)(x >> 16));
        os.write((byte)(x >> 8));
        os.write((byte)x);
        os.write((byte)(z >> 24));
        os.write((byte)(z >> 16));
        os.write((byte)(z >> 8));
        os.write((byte)z);
        this.setupStreamDelegates(this.mode);
    }

    public void readHeader(InputStream is) throws IOException {
        int mode = is.read();
        int x = (is.read() << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
        int z = (is.read() << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
        this.setOrigin(x, z);
        this.setupStreamDelegates(mode);
    }

    public FaweOutputStream getCompressedOS(OutputStream os) throws IOException {
        return MainUtil.getCompressedOS(os, this.compression);
    }

    @Override
    public boolean isEmpty() {
        if (this.blockSize > 0) {
            return false;
        }
        if (this.waitingCombined.get() != 0 || this.waitingAsync.get() != 0) {
            return false;
        }
        this.flush();
        return this.blockSize == 0;
    }

    @Override
    public int size() {
        this.flush();
        return this.blockSize;
    }

    public abstract int getCompressedSize();

    public abstract long getSizeInMemory();

    public long getSizeOnDisk() {
        return 0L;
    }

    public abstract FaweOutputStream getBlockOS(int var1, int var2, int var3) throws IOException;

    public abstract FaweOutputStream getBiomeOS() throws IOException;

    public abstract NBTOutputStream getEntityCreateOS() throws IOException;

    public abstract NBTOutputStream getEntityRemoveOS() throws IOException;

    public abstract NBTOutputStream getTileCreateOS() throws IOException;

    public abstract NBTOutputStream getTileRemoveOS() throws IOException;

    public abstract FaweInputStream getBlockIS() throws IOException;

    public abstract FaweInputStream getBiomeIS() throws IOException;

    public abstract NBTInputStream getEntityCreateIS() throws IOException;

    public abstract NBTInputStream getEntityRemoveIS() throws IOException;

    public abstract NBTInputStream getTileCreateIS() throws IOException;

    public abstract NBTInputStream getTileRemoveIS() throws IOException;

    public void setOrigin(int x, int z) {
        this.originX = x;
        this.originZ = z;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginZ() {
        return this.originZ;
    }

    @Override
    public void add(int x, int y, int z, int combinedFrom, int combinedTo) {
        ++this.blockSize;
        try {
            FaweOutputStream stream = this.getBlockOS(x, y, z);
            this.posDel.write(stream, x - this.originX, y, z - this.originZ);
            this.idDel.writeChange(stream, combinedFrom, combinedTo);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addBiomeChange(int x, int y, int z, BiomeType from, BiomeType to) {
        ++this.blockSize;
        try {
            FaweOutputStream os = this.getBiomeOS();
            os.write((byte)(x >> 24));
            os.write((byte)(x >> 16));
            os.write((byte)(x >> 8));
            os.write((byte)x);
            os.write((byte)(z >> 24));
            os.write((byte)(z >> 16));
            os.write((byte)(z >> 8));
            os.write((byte)z);
            os.write((byte)y);
            os.writeVarInt(from.getInternalId());
            os.writeVarInt(to.getInternalId());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTileCreate(CompoundTag tag) {
        if (tag == null) {
            return;
        }
        ++this.blockSize;
        try {
            NBTOutputStream nbtos = this.getTileCreateOS();
            nbtos.writeTag(tag);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTileRemove(CompoundTag tag) {
        if (tag == null) {
            return;
        }
        ++this.blockSize;
        try {
            NBTOutputStream nbtos = this.getTileRemoveOS();
            nbtos.writeTag(tag);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addEntityRemove(CompoundTag tag) {
        if (tag == null) {
            return;
        }
        ++this.blockSize;
        try {
            NBTOutputStream nbtos = this.getEntityRemoveOS();
            nbtos.writeTag(tag);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addEntityCreate(CompoundTag tag) {
        if (tag == null) {
            return;
        }
        ++this.blockSize;
        try {
            NBTOutputStream nbtos = this.getEntityCreateOS();
            nbtos.writeTag(tag);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Iterator<MutableBlockChange> getBlockIterator(final boolean dir) throws IOException {
        final FaweInputStream is = this.getBlockIS();
        if (is == null) {
            return Collections.emptyIterator();
        }
        final MutableBlockChange change = new MutableBlockChange(0, 0, 0, BlockTypes.AIR.getInternalId());
        return new Iterator<MutableBlockChange>(){
            private MutableBlockChange last = this.read();

            public MutableBlockChange read() {
                try {
                    change.x = FaweStreamChangeSet.this.posDel.readX(is) + FaweStreamChangeSet.this.originX;
                    change.y = FaweStreamChangeSet.this.posDel.readY(is);
                    change.z = FaweStreamChangeSet.this.posDel.readZ(is) + FaweStreamChangeSet.this.originZ;
                    FaweStreamChangeSet.this.idDel.readCombined(is, change, dir);
                    return change;
                }
                catch (EOFException eOFException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    e.printStackTrace();
                }
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.last != null || (this.last = this.read()) != null;
            }

            @Override
            public MutableBlockChange next() {
                MutableBlockChange tmp = this.last;
                if (tmp == null) {
                    tmp = this.read();
                }
                this.last = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("CANNOT REMOVE");
            }
        };
    }

    public Iterator<MutableBiomeChange> getBiomeIterator(boolean dir) throws IOException {
        final FaweInputStream is = this.getBiomeIS();
        if (is == null) {
            return Collections.emptyIterator();
        }
        final MutableBiomeChange change = new MutableBiomeChange();
        return new Iterator<MutableBiomeChange>(){
            private MutableBiomeChange last = new MutableBiomeChange();

            public MutableBiomeChange read() {
                try {
                    int int1 = is.read();
                    if (int1 != -1) {
                        int x = (int1 << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
                        int z = (is.read() << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
                        int y = is.read();
                        int from = is.readVarInt();
                        int to = is.readVarInt();
                        change.setBiome(x, y, z, from, to);
                        return change;
                    }
                }
                catch (EOFException int1) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    e.printStackTrace();
                }
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.last != null || (this.last = this.read()) != null;
            }

            @Override
            public MutableBiomeChange next() {
                MutableBiomeChange tmp = this.last;
                if (tmp == null) {
                    tmp = this.read();
                }
                this.last = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("CANNOT REMOVE");
            }
        };
    }

    @Override
    public Iterator<Change> getIterator(BlockBag blockBag, int mode, boolean redo) {
        if (blockBag != null && mode > 0) {
            try {
                return this.getFullBlockIterator(blockBag, mode, redo);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.getIterator(redo);
    }

    public Iterator<MutableFullBlockChange> getFullBlockIterator(BlockBag blockBag, int inventory, boolean dir) throws IOException {
        final FaweInputStream is = new FaweInputStream(this.getBlockIS());
        final MutableFullBlockChange change = new MutableFullBlockChange(blockBag, inventory, dir);
        return new Iterator<MutableFullBlockChange>(){
            private MutableFullBlockChange last = this.read();

            public MutableFullBlockChange read() {
                try {
                    change.x = FaweStreamChangeSet.this.posDel.readX(is) + FaweStreamChangeSet.this.originX;
                    change.y = FaweStreamChangeSet.this.posDel.readY(is);
                    change.z = FaweStreamChangeSet.this.posDel.readZ(is) + FaweStreamChangeSet.this.originZ;
                    FaweStreamChangeSet.this.idDel.readCombined(is, change);
                    return change;
                }
                catch (EOFException eOFException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    e.printStackTrace();
                }
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.last != null || (this.last = this.read()) != null;
            }

            @Override
            public MutableFullBlockChange next() {
                MutableFullBlockChange tmp = this.last;
                if (tmp == null) {
                    tmp = this.read();
                }
                this.last = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("CANNOT REMOVE");
            }
        };
    }

    public Iterator<MutableEntityChange> getEntityIterator(final NBTInputStream is, boolean create) {
        if (is == null) {
            return Collections.emptyIterator();
        }
        final MutableEntityChange change = new MutableEntityChange(null, create);
        try {
            return new Iterator<MutableEntityChange>(){
                private MutableEntityChange last = this.read();

                public MutableEntityChange read() {
                    try {
                        change.tag = (CompoundTag)is.readTag();
                        return change;
                    }
                    catch (Exception exception) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.last != null || (this.last = this.read()) != null;
                }

                @Override
                public MutableEntityChange next() {
                    MutableEntityChange tmp = this.last;
                    if (tmp == null) {
                        tmp = this.read();
                    }
                    this.last = null;
                    return tmp;
                }

                @Override
                public void remove() {
                    throw new IllegalArgumentException("CANNOT REMOVE");
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Iterator<MutableTileChange> getTileIterator(final NBTInputStream is, boolean create) {
        if (is == null) {
            return Collections.emptyIterator();
        }
        final MutableTileChange change = new MutableTileChange(null, create);
        try {
            return new Iterator<MutableTileChange>(){
                private MutableTileChange last = this.read();

                public MutableTileChange read() {
                    try {
                        change.tag = (CompoundTag)is.readTag();
                        return change;
                    }
                    catch (Exception exception) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.last != null || (this.last = this.read()) != null;
                }

                @Override
                public MutableTileChange next() {
                    MutableTileChange tmp = this.last;
                    if (tmp == null) {
                        tmp = this.read();
                    }
                    this.last = null;
                    return tmp;
                }

                @Override
                public void remove() {
                    throw new IllegalArgumentException("CANNOT REMOVE");
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Iterator<Change> getIterator(boolean dir) {
        try {
            this.close();
            final Iterator<MutableTileChange> tileCreate = this.getTileIterator(this.getTileCreateIS(), true);
            final Iterator<MutableTileChange> tileRemove = this.getTileIterator(this.getTileRemoveIS(), false);
            final Iterator<MutableEntityChange> entityCreate = this.getEntityIterator(this.getEntityCreateIS(), true);
            final Iterator<MutableEntityChange> entityRemove = this.getEntityIterator(this.getEntityRemoveIS(), false);
            final Iterator<MutableBlockChange> blockChange = this.getBlockIterator(dir);
            final Iterator<MutableBiomeChange> biomeChange = this.getBiomeIterator(dir);
            return new Iterator<Change>(){
                Iterator<Change>[] iterators;
                int i;
                Iterator<Change> current;
                {
                    this.iterators = new Iterator[]{tileCreate, tileRemove, entityCreate, entityRemove, blockChange, biomeChange};
                    this.i = 0;
                    this.current = this.iterators[0];
                }

                @Override
                public boolean hasNext() {
                    if (this.current.hasNext()) {
                        return true;
                    }
                    if (this.i >= this.iterators.length - 1) {
                        return false;
                    }
                    this.current = this.iterators[++this.i];
                    return this.hasNext();
                }

                @Override
                public void remove() {
                    this.current.remove();
                }

                @Override
                public Change next() {
                    try {
                        return this.current.next();
                    }
                    catch (Throwable ignored) {
                        if (this.i >= this.iterators.length - 1) {
                            throw new NoSuchElementException("End of iterator");
                        }
                        this.current = this.iterators[++this.i];
                        return this.next();
                    }
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyIterator();
        }
    }

    @Override
    public Iterator<Change> backwardIterator() {
        return this.getIterator(false);
    }

    @Override
    public Iterator<Change> forwardIterator() {
        return this.getIterator(true);
    }

    protected SimpleChangeSetSummary summarizeShallow() {
        return new SimpleChangeSetSummary(this.getOriginX(), this.getOriginZ());
    }

    @Override
    public SimpleChangeSetSummary summarize(Region region, boolean shallow) {
        int ox = this.getOriginX();
        int oz = this.getOriginZ();
        SimpleChangeSetSummary summary = this.summarizeShallow();
        if (region != null && !region.contains(ox, oz)) {
            return summary;
        }
        try (FaweInputStream fis2 = this.getBlockIS();){
            if (!shallow) {
                int amount = (Settings.IMP.HISTORY.BUFFER_SIZE - 9) / 9;
                MutableFullBlockChange change = new MutableFullBlockChange(null, 0, false);
                for (int i = 0; i < amount; ++i) {
                    int x = this.posDel.readX(fis2) + ox;
                    int y = this.posDel.readY(fis2);
                    int z = this.posDel.readZ(fis2) + ox;
                    this.idDel.readCombined(fis2, change);
                    summary.add(x, z, change.to);
                }
            }
        }
        catch (EOFException fis2) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return summary;
    }

    public static interface FaweStreamIdDelegate {
        public void writeChange(FaweOutputStream var1, int var2, int var3) throws IOException;

        public void readCombined(FaweInputStream var1, MutableBlockChange var2, boolean var3) throws IOException;

        public void readCombined(FaweInputStream var1, MutableFullBlockChange var2) throws IOException;
    }

    public static interface FaweStreamPositionDelegate {
        public void write(OutputStream var1, int var2, int var3, int var4) throws IOException;

        public int readX(FaweInputStream var1) throws IOException;

        public int readY(FaweInputStream var1) throws IOException;

        public int readZ(FaweInputStream var1) throws IOException;
    }
}

