/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.changeset;

import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.changeset.FaweStreamChangeSet;
import com.boydti.fawe.object.io.FastByteArrayOutputStream;
import com.boydti.fawe.object.io.FastByteArraysInputStream;
import com.boydti.fawe.util.MainUtil;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.worldedit.world.World;
import java.io.IOException;

public class MemoryOptimizedHistory
extends FaweStreamChangeSet {
    private byte[][] ids;
    private FastByteArrayOutputStream idsStream;
    private FaweOutputStream idsStreamZip;
    private byte[][] biomes;
    private FastByteArrayOutputStream biomeStream;
    private FaweOutputStream biomeStreamZip;
    private byte[][] entC;
    private FastByteArrayOutputStream entCStream;
    private NBTOutputStream entCStreamZip;
    private byte[][] entR;
    private FastByteArrayOutputStream entRStream;
    private NBTOutputStream entRStreamZip;
    private byte[][] tileC;
    private FastByteArrayOutputStream tileCStream;
    private NBTOutputStream tileCStreamZip;
    private byte[][] tileR;
    private FastByteArrayOutputStream tileRStream;
    private NBTOutputStream tileRStreamZip;

    public MemoryOptimizedHistory(World world) {
        super(world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        super.flush();
        MemoryOptimizedHistory memoryOptimizedHistory = this;
        synchronized (memoryOptimizedHistory) {
            try {
                if (this.idsStream != null) {
                    this.idsStreamZip.flush();
                }
                if (this.biomeStream != null) {
                    this.biomeStreamZip.flush();
                }
                if (this.entCStream != null) {
                    this.entCStreamZip.flush();
                }
                if (this.entRStream != null) {
                    this.entRStreamZip.flush();
                }
                if (this.tileCStream != null) {
                    this.tileCStreamZip.flush();
                }
                if (this.tileRStream != null) {
                    this.tileRStreamZip.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        MemoryOptimizedHistory memoryOptimizedHistory = this;
        synchronized (memoryOptimizedHistory) {
            try {
                if (this.idsStream != null) {
                    this.idsStreamZip.close();
                    this.ids = this.idsStream.toByteArrays();
                    this.idsStream = null;
                    this.idsStreamZip = null;
                }
                if (this.biomeStream != null) {
                    this.biomeStreamZip.close();
                    this.biomes = this.biomeStream.toByteArrays();
                    this.biomeStream = null;
                    this.biomeStreamZip = null;
                }
                if (this.entCStream != null) {
                    this.entCStreamZip.close();
                    this.entC = this.entCStream.toByteArrays();
                    this.entCStream = null;
                    this.entCStreamZip = null;
                }
                if (this.entRStream != null) {
                    this.entRStreamZip.close();
                    this.entR = this.entRStream.toByteArrays();
                    this.entRStream = null;
                    this.entRStreamZip = null;
                }
                if (this.tileCStream != null) {
                    this.tileCStreamZip.close();
                    this.tileC = this.tileCStream.toByteArrays();
                    this.tileCStream = null;
                    this.tileCStreamZip = null;
                }
                if (this.tileRStream != null) {
                    this.tileRStreamZip.close();
                    this.tileR = this.tileRStream.toByteArrays();
                    this.tileRStream = null;
                    this.tileRStreamZip = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getCompressedSize() {
        if (this.ids == null) {
            return 0;
        }
        int count = 0;
        for (byte[] array : this.ids) {
            count += 4 + array.length;
        }
        return count;
    }

    @Override
    public long getSizeInMemory() {
        return 92 + this.getCompressedSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FaweOutputStream getBlockOS(int x, int y, int z) throws IOException {
        if (this.idsStreamZip != null) {
            return this.idsStreamZip;
        }
        MemoryOptimizedHistory memoryOptimizedHistory = this;
        synchronized (memoryOptimizedHistory) {
            this.setOrigin(x, z);
            this.idsStream = new FastByteArrayOutputStream(Settings.IMP.HISTORY.BUFFER_SIZE);
            this.idsStreamZip = this.getCompressedOS(this.idsStream);
            this.writeHeader(this.idsStreamZip, x, y, z);
            return this.idsStreamZip;
        }
    }

    @Override
    public FaweInputStream getBiomeIS() throws IOException {
        if (this.biomes == null) {
            return null;
        }
        return MainUtil.getCompressedIS(new FastByteArraysInputStream(this.biomes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FaweOutputStream getBiomeOS() throws IOException {
        if (this.biomeStreamZip != null) {
            return this.biomeStreamZip;
        }
        MemoryOptimizedHistory memoryOptimizedHistory = this;
        synchronized (memoryOptimizedHistory) {
            this.biomeStream = new FastByteArrayOutputStream(Settings.IMP.HISTORY.BUFFER_SIZE);
            this.biomeStreamZip = this.getCompressedOS(this.biomeStream);
            return this.biomeStreamZip;
        }
    }

    @Override
    public FaweInputStream getBlockIS() throws IOException {
        if (this.ids == null) {
            return null;
        }
        FaweInputStream result = MainUtil.getCompressedIS(new FastByteArraysInputStream(this.ids));
        this.readHeader(result);
        return result;
    }

    @Override
    public NBTOutputStream getEntityCreateOS() throws IOException {
        if (this.entCStreamZip != null) {
            return this.entCStreamZip;
        }
        this.entCStream = new FastByteArrayOutputStream(Settings.IMP.HISTORY.BUFFER_SIZE);
        this.entCStreamZip = new NBTOutputStream(this.getCompressedOS(this.entCStream));
        return this.entCStreamZip;
    }

    @Override
    public NBTOutputStream getEntityRemoveOS() throws IOException {
        if (this.entRStreamZip != null) {
            return this.entRStreamZip;
        }
        this.entRStream = new FastByteArrayOutputStream(Settings.IMP.HISTORY.BUFFER_SIZE);
        this.entRStreamZip = new NBTOutputStream(this.getCompressedOS(this.entRStream));
        return this.entRStreamZip;
    }

    @Override
    public NBTOutputStream getTileCreateOS() throws IOException {
        if (this.tileCStreamZip != null) {
            return this.tileCStreamZip;
        }
        this.tileCStream = new FastByteArrayOutputStream(Settings.IMP.HISTORY.BUFFER_SIZE);
        this.tileCStreamZip = new NBTOutputStream(this.getCompressedOS(this.tileCStream));
        return this.tileCStreamZip;
    }

    @Override
    public NBTOutputStream getTileRemoveOS() throws IOException {
        if (this.tileRStreamZip != null) {
            return this.tileRStreamZip;
        }
        this.tileRStream = new FastByteArrayOutputStream(Settings.IMP.HISTORY.BUFFER_SIZE);
        this.tileRStreamZip = new NBTOutputStream(this.getCompressedOS(this.tileRStream));
        return this.tileRStreamZip;
    }

    @Override
    public NBTInputStream getEntityCreateIS() throws IOException {
        return this.entC == null ? null : new NBTInputStream(MainUtil.getCompressedIS(new FastByteArraysInputStream(this.entC)));
    }

    @Override
    public NBTInputStream getEntityRemoveIS() throws IOException {
        return this.entR == null ? null : new NBTInputStream(MainUtil.getCompressedIS(new FastByteArraysInputStream(this.entR)));
    }

    @Override
    public NBTInputStream getTileCreateIS() throws IOException {
        return this.tileC == null ? null : new NBTInputStream(MainUtil.getCompressedIS(new FastByteArraysInputStream(this.tileC)));
    }

    @Override
    public NBTInputStream getTileRemoveIS() throws IOException {
        return this.tileR == null ? null : new NBTInputStream(MainUtil.getCompressedIS(new FastByteArraysInputStream(this.tileR)));
    }

    @Override
    public boolean isRecordingChanges() {
        return false;
    }

    @Override
    public void setRecordChanges(boolean recordChanges) {
    }
}

