/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.clipboard;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.jnbt.streamer.IntValueReader;
import com.boydti.fawe.object.IntTriple;
import com.boydti.fawe.object.clipboard.LinearClipboard;
import com.boydti.fawe.util.MainUtil;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DiskOptimizedClipboard
extends LinearClipboard
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(DiskOptimizedClipboard.class);
    private static final int HEADER_SIZE = 14;
    private final HashMap<IntTriple, CompoundTag> nbtMap;
    private final File file;
    private RandomAccessFile braf;
    private MappedByteBuffer byteBuffer;
    private FileChannel fileChannel;
    private boolean hasBiomes;
    private boolean canHaveBiomes = true;

    public DiskOptimizedClipboard(Region region, UUID uuid) {
        this(region.getDimensions(), MainUtil.getFile(Fawe.get() != null ? Fawe.imp().getDirectory() : new File("."), Settings.IMP.PATHS.CLIPBOARD + File.separator + uuid + ".bd"));
    }

    public DiskOptimizedClipboard(BlockVector3 dimensions) {
        this(dimensions, MainUtil.getFile(Fawe.imp() != null ? Fawe.imp().getDirectory() : new File("."), Settings.IMP.PATHS.CLIPBOARD + File.separator + UUID.randomUUID() + ".bd"));
    }

    public DiskOptimizedClipboard(BlockVector3 dimensions, File file) {
        super(dimensions);
        if (14L + ((long)this.getVolume() << 1) >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Dimensions too large for this clipboard format");
        }
        if (14L + ((long)this.getVolume() << 1) + (long)((this.getHeight() >> 2) + 1) * (long)((this.getLength() >> 2) + 1) * (long)((this.getWidth() >> 2) + 1) >= Integer.MAX_VALUE) {
            log.error("Dimensions are too large for biomes to be stored in a DiskOptimizedClipboard");
            this.canHaveBiomes = false;
        }
        this.nbtMap = new HashMap();
        try {
            this.file = file;
            try {
                if (!file.exists()) {
                    File parent = file.getParentFile();
                    if (parent != null) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.braf = new RandomAccessFile(file, "rw");
            long fileLength = (long)this.getVolume() * 2L + 14L;
            this.braf.setLength(0L);
            this.braf.setLength(fileLength);
            this.init();
            this.byteBuffer.putChar(2, (char)this.getWidth());
            this.byteBuffer.putChar(4, (char)this.getHeight());
            this.byteBuffer.putChar(6, (char)this.getLength());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public URI getURI() {
        return this.file.toURI();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BlockVector3 readSize(File file) {
        try (DataInputStream is = new DataInputStream(new FileInputStream(file));){
            is.skipBytes(2);
            BlockVector3 blockVector3 = BlockVector3.at(is.readChar(), is.readChar(), is.readChar());
            return blockVector3;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public DiskOptimizedClipboard(File file) {
        super(DiskOptimizedClipboard.readSize(file));
        this.nbtMap = new HashMap();
        try {
            this.file = file;
            this.braf = new RandomAccessFile(file, "rw");
            this.braf.setLength(file.length());
            this.init();
            if (this.braf.length() - 14L == ((long)this.getVolume() << 1) + (long)((this.getHeight() >> 2) + 1) * (long)((this.getLength() >> 2) + 1) * (long)((this.getWidth() >> 2) + 1)) {
                this.hasBiomes = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getFile() {
        return this.file;
    }

    private void init() throws IOException {
        if (this.fileChannel == null) {
            this.fileChannel = this.braf.getChannel();
            this.byteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, this.file.length());
        }
    }

    private boolean initBiome() {
        if (!this.canHaveBiomes) {
            return false;
        }
        if (!this.hasBiomes) {
            try {
                this.hasBiomes = true;
                this.close();
                this.braf = new RandomAccessFile(this.file, "rw");
                this.braf.setLength(14L + ((long)this.getVolume() << 1) + (long)((this.getHeight() >> 2) + 1) * (long)((this.getLength() >> 2) + 1) * (long)((this.getWidth() >> 2) + 1));
                this.init();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasBiomes() {
        return this.hasBiomes;
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        return this.setBiome(position.getX(), position.getY(), position.getZ(), biome);
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        this.setBiome(this.getBiomeIndex(x, y, z), biome);
        return true;
    }

    @Override
    public void setBiome(int index, BiomeType biome) {
        if (this.initBiome()) {
            try {
                this.byteBuffer.put(14 + (this.getVolume() << 1) + index, (byte)biome.getInternalId());
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println((long)(this.getHeight() >> 2) * (long)(this.getLength() >> 2) * (long)(this.getWidth() >> 2));
                System.out.println(index);
                e.printStackTrace();
            }
        }
    }

    @Override
    public BiomeType getBiome(int index) {
        if (!this.hasBiomes()) {
            return null;
        }
        int biomeId = this.byteBuffer.get(14 + (this.getVolume() << 1) + index) & 0xFF;
        return BiomeTypes.get(biomeId);
    }

    @Override
    public void streamBiomes(IntValueReader task) {
        if (!this.hasBiomes()) {
            return;
        }
        int mbbIndex = 14 + (this.getVolume() << 1);
        try {
            for (int y = 0; y < this.getHeight(); ++y) {
                for (int z = 0; z < this.getLength(); ++z) {
                    for (int x = 0; x < this.getWidth(); ++x) {
                        int biome = this.byteBuffer.get(mbbIndex + this.getBiomeIndex(x, y, z)) & 0xFF;
                        task.applyInt(this.getIndex(x, y, z), biome);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        return this.getBiome(this.getBiomeIndex(x, y, z));
    }

    @Override
    public BiomeType getBiome(BlockVector3 position) {
        return this.getBiome(this.getBiomeIndex(position.getX(), position.getY(), position.getZ()));
    }

    public BlockArrayClipboard toClipboard() {
        try {
            CuboidRegion region = new CuboidRegion(BlockVector3.at(0, 0, 0), BlockVector3.at(this.getWidth() - 1, this.getHeight() - 1, this.getLength() - 1));
            short ox = this.byteBuffer.getShort(8);
            short oy = this.byteBuffer.getShort(10);
            short oz = this.byteBuffer.getShort(12);
            BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)region, this);
            clipboard.setOrigin(BlockVector3.at(ox, oy, oz));
            return clipboard;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setOrigin(BlockVector3 offset) {
        super.setOrigin(offset);
        try {
            this.byteBuffer.putShort(8, (short)offset.getBlockX());
            this.byteBuffer.putShort(10, (short)offset.getBlockY());
            this.byteBuffer.putShort(12, (short)offset.getBlockZ());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void flush() {
        this.byteBuffer.force();
    }

    private void closeDirectBuffer(ByteBuffer cb) {
        if (cb == null || !cb.isDirect()) {
            return;
        }
        try {
            Method cleaner = cb.getClass().getMethod("cleaner", new Class[0]);
            cleaner.setAccessible(true);
            Method clean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
            clean.setAccessible(true);
            clean.invoke(cleaner.invoke((Object)cb, new Object[0]), new Object[0]);
        }
        catch (Exception ex) {
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                Object theUnsafe = theUnsafeField.get(null);
                Method invokeCleanerMethod = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                invokeCleanerMethod.invoke(theUnsafe, cb);
            }
            catch (Exception e) {
                System.gc();
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this.byteBuffer != null) {
                this.byteBuffer.force();
                this.fileChannel.close();
                this.braf.close();
                this.file.setWritable(true);
                this.closeDirectBuffer(this.byteBuffer);
                this.byteBuffer = null;
                this.fileChannel = null;
                this.braf = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Collection<CompoundTag> getTileEntities() {
        return this.nbtMap.values();
    }

    public int getIndex(int x, int y, int z) {
        return x + y * this.getArea() + z * this.getWidth();
    }

    public int getBiomeIndex(int x, int y, int z) {
        return (x >> 2) + (y >> 2) * (this.getWidth() >> 2) * (this.getLength() >> 2) + (z >> 2) * (this.getWidth() >> 2);
    }

    @Override
    public BaseBlock getFullBlock(int x, int y, int z) {
        return this.toBaseBlock(this.getBlock(x, y, z), x, y, z);
    }

    private BaseBlock toBaseBlock(BlockState state, int i) {
        if (state.getMaterial().hasContainer() && !this.nbtMap.isEmpty()) {
            CompoundTag nbt;
            if (this.nbtMap.size() < 4) {
                nbt = null;
                for (Map.Entry<IntTriple, CompoundTag> entry : this.nbtMap.entrySet()) {
                    IntTriple key = entry.getKey();
                    int index = this.getIndex(key.getX(), key.getY(), key.getZ());
                    if (index != i) continue;
                    nbt = entry.getValue();
                    break;
                }
            } else {
                int y = i / this.getArea();
                int newI = i - y * this.getArea();
                int z = newI / this.getWidth();
                int x = newI - z * this.getWidth();
                nbt = this.nbtMap.get(new IntTriple(x, y, z));
            }
            return state.toBaseBlock(nbt);
        }
        return state.toBaseBlock();
    }

    private BaseBlock toBaseBlock(BlockState state, int x, int y, int z) {
        if (state.getMaterial().hasContainer() && !this.nbtMap.isEmpty()) {
            CompoundTag nbt = this.nbtMap.get(new IntTriple(x, y, z));
            return state.toBaseBlock(nbt);
        }
        return state.toBaseBlock();
    }

    @Override
    public BaseBlock getFullBlock(int i) {
        return this.toBaseBlock(this.getBlock(i), i);
    }

    @Override
    public BlockState getBlock(int index) {
        try {
            int diskIndex = 14 + (index << 1);
            char ordinal = this.byteBuffer.getChar(diskIndex);
            return BlockState.getFromOrdinal(ordinal);
        }
        catch (IndexOutOfBoundsException diskIndex) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BlockTypes.AIR.getDefaultState();
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.getBlock(this.getIndex(x, y, z));
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tag) {
        HashMap<String, Tag> values = new HashMap<String, Tag>((Map<String, Tag>)tag.getValue());
        values.put("x", new IntTag(x));
        values.put("y", new IntTag(y));
        values.put("z", new IntTag(z));
        this.nbtMap.put(new IntTriple(x, y, z), new CompoundTag(values));
        return true;
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x, int y, int z, B block) {
        try {
            boolean hasNbt;
            int index = 14 + (this.getIndex(x, y, z) << 1);
            char ordinal = block.getOrdinalChar();
            if (ordinal == '\u0000') {
                ordinal = '\u0001';
            }
            this.byteBuffer.putChar(index, ordinal);
            boolean bl = hasNbt = block instanceof BaseBlock && block.hasNbtData();
            if (hasNbt) {
                this.setTile(x, y, z, block.getNbtData());
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int i, B block) {
        try {
            boolean hasNbt;
            char ordinal = block.getOrdinalChar();
            int index = 14 + (i << 1);
            this.byteBuffer.putChar(index, ordinal);
            boolean bl = hasNbt = block instanceof BaseBlock && block.hasNbtData();
            if (hasNbt) {
                int y = i / this.getArea();
                int newI = i - y * this.getArea();
                int z = newI / this.getWidth();
                int x = newI - z * this.getWidth();
                this.setTile(x, y, z, block.getNbtData());
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        BlockArrayClipboard.ClipboardEntity ret = new BlockArrayClipboard.ClipboardEntity(location, entity);
        this.entities.add(ret);
        return ret;
    }

    @Override
    public List<? extends Entity> getEntities() {
        return new ArrayList(this.entities);
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        return new ArrayList(this.entities.stream().filter(e -> region.contains(e.getLocation().toBlockPoint())).collect(Collectors.toList()));
    }

    @Override
    public void removeEntity(Entity entity) {
        if (!(entity instanceof BlockArrayClipboard.ClipboardEntity)) {
            Location loc = entity.getLocation();
            this.removeEntity(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), entity.getState().getNbtData().getUUID());
        } else {
            this.entities.remove(entity);
        }
    }

    @Override
    public void removeEntity(int x, int y, int z, UUID uuid) {
        Iterator iter = this.entities.iterator();
        while (iter.hasNext()) {
            BlockArrayClipboard.ClipboardEntity entity = (BlockArrayClipboard.ClipboardEntity)iter.next();
            UUID entUUID = entity.getState().getNbtData().getUUID();
            if (!uuid.equals(entUUID)) continue;
            iter.remove();
            return;
        }
    }
}

