/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.clipboard;

import com.boydti.fawe.beta.implementation.filter.block.AbstractFilterBlock;
import com.boydti.fawe.jnbt.streamer.IntValueReader;
import com.boydti.fawe.object.clipboard.SimpleClipboard;
import com.google.common.collect.ForwardingIterator;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.function.visitor.Order;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public abstract class LinearClipboard
extends SimpleClipboard {
    protected final HashSet<BlockArrayClipboard.ClipboardEntity> entities = new HashSet();

    public LinearClipboard(BlockVector3 dimensions) {
        super(dimensions);
    }

    public abstract <B extends BlockStateHolder<B>> boolean setBlock(int var1, B var2);

    public abstract BaseBlock getFullBlock(int var1);

    public abstract BlockState getBlock(int var1);

    public abstract void setBiome(int var1, BiomeType var2);

    public abstract BiomeType getBiome(int var1);

    public abstract void streamBiomes(IntValueReader var1);

    public abstract Collection<CompoundTag> getTileEntities();

    public void flush() {
    }

    protected void finalize() {
        this.close();
    }

    @Override
    @NotNull
    public Iterator<BlockVector3> iterator() {
        return this.iterator(Order.YZX);
    }

    @Override
    public Iterator<BlockVector3> iterator(Order order) {
        Region region = this.getRegion();
        switch (order) {
            case YZX: {
                if (!(region instanceof CuboidRegion)) break;
                final Iterator<BlockVector3> iter = ((CuboidRegion)region).iterator_old();
                final LinearFilter filter = new LinearFilter();
                return new ForwardingIterator<BlockVector3>(){

                    protected Iterator<BlockVector3> delegate() {
                        return iter;
                    }

                    public BlockVector3 next() {
                        return filter.next((BlockVector3)super.next());
                    }
                };
            }
        }
        return order.create(region);
    }

    @Override
    public void removeEntity(int x, int y, int z, UUID uuid) {
        Iterator<BlockArrayClipboard.ClipboardEntity> iter = this.entities.iterator();
        while (iter.hasNext()) {
            BlockArrayClipboard.ClipboardEntity entity = iter.next();
            UUID entUUID = entity.getState().getNbtData().getUUID();
            if (!uuid.equals(entUUID)) continue;
            iter.remove();
            return;
        }
    }

    private class LinearFilter
    extends AbstractFilterBlock {
        private int index = -1;
        private BlockVector3 position;

        private LinearFilter() {
        }

        private LinearFilter next(BlockVector3 position) {
            this.position = position;
            ++this.index;
            return this;
        }

        @Override
        public BaseBlock getFullBlock() {
            return LinearClipboard.this.getFullBlock(this.index);
        }

        @Override
        public void setFullBlock(BaseBlock block) {
            LinearClipboard.this.setBlock(this.index, block);
        }

        @Override
        public BlockVector3 getPosition() {
            return this.position;
        }

        @Override
        public Extent getExtent() {
            return LinearClipboard.this;
        }
    }
}

