/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.util.MainUtil;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class CleanableThreadLocal<T>
extends ThreadLocal<T>
implements Closeable {
    private final Supplier<T> supplier;
    private final Function<T, T> modifier;
    private LongAdder count = new LongAdder();

    public CleanableThreadLocal(Supplier<T> supplier) {
        this(supplier, Function.identity());
    }

    public CleanableThreadLocal(Supplier<T> supplier, Consumer<T> modifier) {
        this(supplier, (T t) -> {
            modifier.accept(t);
            return t;
        });
    }

    public CleanableThreadLocal(Supplier<T> supplier, Function<T, T> modifier) {
        this.supplier = supplier;
        this.modifier = modifier;
    }

    @Override
    protected final T initialValue() {
        T value = this.modifier.apply(this.init());
        if (value != null) {
            this.count.increment();
        }
        return value;
    }

    public T init() {
        return this.supplier.get();
    }

    public void clean() {
        if (this.count.sumThenReset() > 0L) {
            CleanableThreadLocal.clean(this);
        }
    }

    public List<T> getAll() {
        final ArrayList list = new ArrayList();
        CleanableThreadLocal.iterate(this, new Consumer<Object>(){
            Method methodGetEntry;
            Field fieldValue;

            @Override
            public void accept(Object tlm) {
                try {
                    Object entry;
                    if (this.methodGetEntry == null) {
                        this.methodGetEntry = tlm.getClass().getDeclaredMethod("getEntry", ThreadLocal.class);
                        this.methodGetEntry.setAccessible(true);
                    }
                    if ((entry = this.methodGetEntry.invoke(tlm, CleanableThreadLocal.this)) != null) {
                        Object value;
                        if (this.fieldValue == null) {
                            this.fieldValue = entry.getClass().getDeclaredField("value");
                            this.fieldValue.setAccessible(true);
                        }
                        if ((value = this.fieldValue.get(entry)) != null) {
                            list.add(value);
                        }
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return list;
    }

    public static <L> void iterate(ThreadLocal<L> instance, Consumer<Object> withMap) {
        try {
            Thread[] threads = MainUtil.getThreads();
            Field tl = Thread.class.getDeclaredField("threadLocals");
            tl.setAccessible(true);
            for (Thread thread : threads) {
                Object tlm;
                if (thread == null || (tlm = tl.get(thread)) == null) continue;
                withMap.accept(tlm);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <L> void clean(final ThreadLocal<L> instance) {
        CleanableThreadLocal.iterate(instance, new Consumer<Object>(){
            Method methodRemove;

            @Override
            public void accept(Object tlm) {
                try {
                    if (this.methodRemove == null) {
                        this.methodRemove = tlm.getClass().getDeclaredMethod("remove", ThreadLocal.class);
                        this.methodRemove.setAccessible(true);
                    }
                    if (this.methodRemove != null) {
                        try {
                            this.methodRemove.invoke(tlm, instance);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void cleanAll() {
        try {
            Thread thread = Thread.currentThread();
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Object threadLocalTable = threadLocalsField.get(thread);
            Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = threadLocalMapClass.getDeclaredField("table");
            tableField.setAccessible(true);
            Object table = tableField.get(threadLocalTable);
            Field referentField = Reference.class.getDeclaredField("referent");
            referentField.setAccessible(true);
            for (int i = 0; i < Array.getLength(table); ++i) {
                Object entry = Array.get(table, i);
                if (entry == null) continue;
                ThreadLocal threadLocal = (ThreadLocal)referentField.get(entry);
                CleanableThreadLocal.clean(threadLocal);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void finalize() throws Throwable {
        CleanableThreadLocal.clean(this);
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        this.clean();
    }
}

