/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.collection.DifferentialCollection;
import com.boydti.fawe.object.io.serialize.Serialize;
import com.boydti.fawe.util.MainUtil;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;

public final class DifferentialArray<T>
implements DifferentialCollection<T> {
    private final byte[] dataBytes;
    private byte[] changesBytes;
    private final int[] dataInts;
    private int[] changesInts;
    private final char[] dataChars;
    private char[] changesChars;
    @Serialize
    private final T data;
    private T changes;
    private boolean changed;
    private int length;

    public DifferentialArray(T array) {
        Preconditions.checkNotNull(array);
        Class<?> clazz = array.getClass();
        Preconditions.checkArgument((boolean)clazz.isArray(), (Object)"Data must be an array");
        Preconditions.checkArgument((boolean)clazz.getComponentType().isPrimitive(), (Object)"Data must be a primitive array");
        this.data = array;
        if (array instanceof byte[]) {
            this.dataBytes = (byte[])array;
            this.length = this.dataBytes.length;
        } else {
            this.dataBytes = null;
        }
        if (array instanceof int[]) {
            this.dataInts = (int[])array;
            this.length = this.dataInts.length;
        } else {
            this.dataInts = null;
        }
        if (array instanceof char[]) {
            this.dataChars = (char[])array;
            this.length = this.dataChars.length;
        } else {
            this.dataChars = null;
        }
    }

    public void record(Runnable task) {
        Object tmp;
        boolean changed;
        if (this.changes == null) {
            if (this.data instanceof byte[]) {
                this.changesBytes = new byte[this.length];
                this.changes = (T)this.changesBytes;
            } else if (this.data instanceof int[]) {
                this.changesInts = new int[this.length];
                this.changes = (T)this.changesInts;
            } else if (this.data instanceof char[]) {
                this.changesChars = new char[this.length];
                this.changes = (T)this.changesChars;
            }
        }
        if (changed = this.changed) {
            tmp = MainUtil.copyNd(this.data);
        } else {
            tmp = this.changes;
            System.arraycopy(this.data, 0, tmp, 0, Array.getLength(this.data));
        }
        Throwable caught = null;
        try {
            task.run();
        }
        catch (Throwable e) {
            caught = e;
            task.run();
        }
        if (tmp instanceof int[]) {
            int i;
            int[] tmpInts = (int[])tmp;
            for (i = 0; i < tmpInts.length; ++i) {
                int tmpInt = tmpInts[i];
                int dataInt = this.dataInts[i];
                if (tmpInt != dataInt) {
                    this.changed = true;
                    int n = i;
                    tmpInts[n] = tmpInts[n] - dataInt;
                    continue;
                }
                tmpInts[i] = 0;
            }
            if (changed) {
                for (i = 0; i < tmpInts.length; ++i) {
                    int n = i;
                    this.changesInts[n] = this.changesInts[n] + tmpInts[i];
                }
            }
        } else if (tmp instanceof char[]) {
            int i;
            char[] tmpChars = (char[])tmp;
            for (i = 0; i < tmpChars.length; ++i) {
                char tmpChar = tmpChars[i];
                char dataChar = this.dataChars[i];
                if (tmpChar != dataChar) {
                    this.changed = true;
                    int n = i;
                    tmpChars[n] = (char)(tmpChars[n] - dataChar);
                    continue;
                }
                tmpChars[i] = '\u0000';
            }
            if (changed) {
                for (i = 0; i < tmpChars.length; ++i) {
                    int n = i;
                    this.changesChars[n] = (char)(this.changesChars[n] + tmpChars[i]);
                }
            }
        } else if (tmp instanceof byte[]) {
            int i;
            byte[] tmpBytes = (byte[])tmp;
            for (i = 0; i < tmpBytes.length; ++i) {
                byte tmpByte = tmpBytes[i];
                byte dataByte = this.dataBytes[i];
                if (tmpByte != dataByte) {
                    this.changed = true;
                    int n = i;
                    tmpBytes[n] = (byte)(tmpBytes[n] - dataByte);
                    continue;
                }
                tmpBytes[i] = 0;
            }
            if (changed) {
                for (i = 0; i < tmpBytes.length; ++i) {
                    int n = i;
                    this.changesBytes[n] = (byte)(this.changesBytes[n] + tmpBytes[i]);
                }
            }
        }
        if (caught != null) {
            if (caught instanceof RuntimeException) {
                throw (RuntimeException)caught;
            }
            throw new RuntimeException(caught);
        }
    }

    @Override
    public void flushChanges(FaweOutputStream out) throws IOException {
        boolean modified = this.isModified();
        out.writeBoolean(modified);
        if (modified) {
            if (this.dataBytes != null) {
                out.write(this.changesBytes);
            } else if (this.dataInts != null) {
                for (int c : this.changesInts) {
                    out.writeVarInt(c);
                }
            } else if (this.dataChars != null) {
                for (char c : this.changesChars) {
                    out.writeChar(c);
                }
            }
        }
        this.clearChanges();
    }

    @Override
    public void undoChanges(FaweInputStream in) throws IOException {
        boolean modified = in.readBoolean();
        if (modified) {
            if (this.dataBytes != null) {
                int i;
                if (this.changesBytes != null) {
                    for (i = 0; i < this.dataBytes.length; ++i) {
                        int n = i;
                        this.dataBytes[n] = (byte)(this.dataBytes[n] + this.changesBytes[i]);
                    }
                }
                i = 0;
                while (i < this.dataBytes.length) {
                    int read = in.read();
                    int n = i++;
                    this.dataBytes[n] = (byte)(this.dataBytes[n] + read);
                }
            } else if (this.dataInts != null) {
                int i;
                if (this.changesInts != null) {
                    for (i = 0; i < this.dataInts.length; ++i) {
                        int n = i;
                        this.dataInts[n] = this.dataInts[n] + this.changesInts[i];
                    }
                }
                i = 0;
                while (i < this.changesInts.length) {
                    int n = i++;
                    this.dataInts[n] = this.dataInts[n] + in.readVarInt();
                }
            } else if (this.dataChars != null) {
                int i;
                if (this.changesChars != null) {
                    for (i = 0; i < this.dataChars.length; ++i) {
                        int n = i;
                        this.dataChars[n] = (char)(this.dataChars[n] + this.changesChars[i]);
                    }
                }
                i = 0;
                while (i < this.dataChars.length) {
                    int n = i++;
                    this.dataChars[n] = (char)(this.dataChars[n] + in.readChar());
                }
            }
        }
        this.clearChanges();
    }

    @Override
    public void redoChanges(FaweInputStream in) throws IOException {
        boolean modified = in.readBoolean();
        if (modified) {
            if (this.dataBytes != null) {
                int i = 0;
                while (i < this.dataBytes.length) {
                    int read = in.read();
                    int n = i++;
                    this.dataBytes[n] = (byte)(this.dataBytes[n] - read);
                }
            } else if (this.dataInts != null) {
                int i = 0;
                while (i < this.dataChars.length) {
                    int n = i++;
                    this.dataInts[n] = this.dataInts[n] - in.readVarInt();
                }
            } else if (this.dataChars != null) {
                int i = 0;
                while (i < this.dataChars.length) {
                    int n = i++;
                    this.dataChars[n] = (char)(this.dataChars[n] - in.readChar());
                }
            }
        }
        this.clearChanges();
    }

    public void clearChanges() {
        if (this.changed) {
            this.changed = false;
            if (this.changes != null) {
                if (this.changesBytes != null) {
                    Arrays.fill(this.changesBytes, (byte)0);
                }
                if (this.changesChars != null) {
                    Arrays.fill(this.changesChars, '\u0000');
                }
                if (this.changesInts != null) {
                    Arrays.fill(this.changesInts, 0);
                }
            }
        }
    }

    public byte[] getByteArray() {
        return this.dataBytes;
    }

    public char[] getCharArray() {
        return this.dataChars;
    }

    public int[] getIntArray() {
        return this.dataInts;
    }

    public boolean isModified() {
        return this.changed;
    }

    @Override
    public T get() {
        return this.data;
    }

    public byte getByte(int index) {
        return this.dataBytes[index];
    }

    public char getChar(int index) {
        return this.dataChars[index];
    }

    public int getInt(int index) {
        return this.dataInts[index];
    }

    public void setByte(int index, byte value) {
        this.changed = true;
        try {
            int n = index;
            this.changesBytes[n] = (byte)(this.changesBytes[n] + (this.dataBytes[index] - value));
        }
        catch (NullPointerException ignored) {
            this.changesBytes = new byte[this.dataBytes.length];
            this.changes = (T)this.changesBytes;
            int n = index;
            this.changesBytes[n] = (byte)(this.changesBytes[n] + (this.dataBytes[index] - value));
        }
        this.dataBytes[index] = value;
    }

    public void setInt(int index, int value) {
        this.changed = true;
        try {
            int n = index;
            this.changesInts[n] = this.changesInts[n] + (this.dataInts[index] - value);
        }
        catch (NullPointerException ignored) {
            this.changesInts = new int[this.dataInts.length];
            this.changes = (T)this.changesInts;
            int n = index;
            this.changesInts[n] = this.changesInts[n] + (this.dataInts[index] - value);
        }
        this.dataInts[index] = value;
    }

    public void setChar(int index, char value) {
        this.changed = true;
        try {
            int n = index;
            this.changesChars[n] = (char)(this.changesChars[n] + (this.dataChars[index] - value));
        }
        catch (NullPointerException ignored) {
            this.changesChars = new char[this.dataChars.length];
            this.changes = (T)this.changesChars;
            int n = index;
            this.changesChars[n] = (char)(this.changesChars[n] + (this.dataChars[index] - value));
        }
        this.dataChars[index] = value;
    }
}

