/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.collection.DifferentialCollection;
import java.io.IOException;
import java.lang.reflect.Array;

public final class DifferentialBlockBuffer
implements DifferentialCollection<char[][][][][]> {
    private final int width;
    private final int length;
    private final int t1;
    private final int t2;
    private char[][][][][] data;
    private char[][][][][] changes;

    public DifferentialBlockBuffer(int width, int length) {
        this.width = width;
        this.length = length;
        this.t1 = length + 15 >> 4;
        this.t2 = width + 15 >> 4;
    }

    @Override
    public char[][][][][] get() {
        return this.data;
    }

    @Override
    public void flushChanges(FaweOutputStream out) throws IOException {
        boolean modified = this.isModified();
        out.writeBoolean(modified);
        if (modified) {
            this.writeArray(this.changes, 0, 0, out);
        }
        this.clearChanges();
    }

    private void writeArray(Object arr, int level, int index, FaweOutputStream out) throws IOException {
        if (level == 4) {
            if (arr != null) {
                int[] level4 = (int[])arr;
                out.writeVarInt(level4.length);
                for (int c : level4) {
                    out.writeVarInt(c);
                }
            } else {
                out.writeVarInt(0);
            }
        } else {
            int len = arr == null ? 0 : Array.getLength(arr);
            out.writeVarInt(len);
            for (int i = 0; i < len; ++i) {
                Object elem = Array.get(arr, i);
                this.writeArray(elem, level + 1, i, out);
            }
        }
    }

    @Override
    public void undoChanges(FaweInputStream in) throws IOException {
        if (this.changes != null && this.changes.length != 0) {
            throw new IllegalStateException("There are uncommitted changes, please flush first");
        }
        boolean modified = in.readBoolean();
        if (modified) {
            int len = in.readVarInt();
            if (len == 0) {
                this.data = null;
            } else {
                for (int i = 0; i < len; ++i) {
                    this.readArray(this.data, i, 1, in);
                }
            }
        }
        this.clearChanges();
    }

    @Override
    public void redoChanges(FaweInputStream in) throws IOException {
        this.clearChanges();
        throw new UnsupportedOperationException("Not implemented");
    }

    private void readArray(Object dataElem, int index, int level, FaweInputStream in) throws IOException {
        int len = in.readVarInt();
        if (level == 4) {
            int[][] castedElem = (int[][])dataElem;
            if (len == 0) {
                castedElem[index] = null;
            } else {
                int[] current = castedElem[index];
                for (int i = 0; i < len; ++i) {
                    current[i] = in.readVarInt();
                }
            }
        } else if (len == 0) {
            Array.set(dataElem, index, null);
        } else {
            Object nextElem = Array.get(dataElem, index);
            for (int i = 0; i < len; ++i) {
                this.readArray(nextElem, i, level + 1, in);
            }
        }
    }

    public boolean isModified() {
        return this.changes != null;
    }

    public void clearChanges() {
        this.changes = null;
    }

    public void set(int x, int y, int z, char combined) {
        char[] zMap;
        Object yMap;
        Object arr2;
        Object arr;
        if (combined == '\u0000') {
            combined = '\u0001';
        }
        int localX = x & 0xF;
        int localZ = z & 0xF;
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (this.data == null) {
            this.data = new char[this.t1][][][][];
            this.changes = new char[0][][][][];
        }
        if ((arr = this.data[chunkZ]) == null) {
            char[][][][] cArrayArray = new char[this.t2][][][];
            this.data[chunkZ] = cArrayArray;
            arr = cArrayArray;
        }
        if ((arr2 = arr[chunkX]) == null) {
            char[][][] cArrayArray = new char[256][][];
            arr[chunkX] = cArrayArray;
            arr2 = cArrayArray;
        }
        if ((yMap = arr2[y]) == null) {
            char[][] cArrayArray = new char[16][];
            yMap = cArrayArray;
            arr2[y] = cArrayArray;
        }
        if ((zMap = yMap[localZ]) == null) {
            zMap = new char[16];
            yMap[localZ] = zMap;
            if (this.changes == null) {
                this.changes = new char[this.t1][][][][];
            } else if (this.changes != null && this.changes.length != 0) {
                this.initialChange(this.changes, chunkX, chunkZ, localX, localZ, y, -combined);
            }
        } else {
            if (this.changes == null || this.changes.length == 0) {
                this.changes = new char[this.t1][][][][];
            }
            this.appendChange(this.changes, chunkX, chunkZ, localX, localZ, y, (char)(zMap[localX] - combined));
        }
        zMap[localX] = combined;
    }

    private void initialChange(char[][][][][] src, int chunkX, int chunkZ, int localX, int localZ, int y, char combined) {
        char[][][][] arr = src[chunkZ];
        if (arr == null) {
            src[chunkZ] = new char[0][][][];
            return;
        }
        if (arr.length == 0) {
            return;
        }
        char[][][] arr2 = arr[chunkX];
        if (arr2 == null) {
            arr[chunkX] = new char[0][][];
            return;
        }
        if (arr2.length == 0) {
            return;
        }
        char[][] yMap = arr2[y];
        if (yMap == null) {
            arr2[y] = new char[0][];
            return;
        }
        if (yMap.length == 0) {
            return;
        }
        char[] zMap = yMap[localZ];
        if (zMap == null) {
            yMap[localZ] = new char[0];
            return;
        }
        if (zMap.length == 0) {
            return;
        }
        char current = zMap[localX];
        zMap[localX] = combined;
    }

    private void appendChange(char[][][][][] src, int chunkX, int chunkZ, int localX, int localZ, int y, char combined) {
        char[] zMap;
        Object yMap;
        Object arr2;
        Object arr = src[chunkZ];
        if (arr == null || ((char[][][][])arr).length == 0) {
            char[][][][] cArrayArray = new char[this.t2][][][];
            src[chunkZ] = cArrayArray;
            arr = cArrayArray;
        }
        if ((arr2 = arr[chunkX]) == null || ((char[][][])arr2).length == 0) {
            char[][][] cArrayArray = new char[256][][];
            arr[chunkX] = cArrayArray;
            arr2 = cArrayArray;
        }
        if ((yMap = arr2[y]) == null || ((char[][])yMap).length == 0) {
            char[][] cArrayArray = new char[16][];
            yMap = cArrayArray;
            arr2[y] = cArrayArray;
        }
        if ((zMap = yMap[localZ]) == null || zMap.length == 0) {
            zMap = new char[16];
            yMap[localZ] = zMap;
        }
        zMap[localX] = combined;
    }
}

