/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.object.collection.RandomCollection;
import com.boydti.fawe.object.random.SimpleRandom;
import com.boydti.fawe.util.MathMan;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public class FastRandomCollection<T>
extends RandomCollection<T> {
    private final T[] values;

    private FastRandomCollection(T[] values, SimpleRandom random) {
        super(random);
        this.values = values;
    }

    public static <T> Optional<RandomCollection<T>> create(Map<T, Double> weights, SimpleRandom random) {
        int max = 0;
        int[] counts = new int[weights.size()];
        Double[] weightDoubles = weights.values().toArray(new Double[0]);
        for (int i = 0; i < weightDoubles.length; ++i) {
            int weight;
            counts[i] = weight = (int)(weightDoubles[i] * 100.0);
            if ((double)weight != weightDoubles[i] * 100.0) {
                return Optional.empty();
            }
            if (weight <= max) continue;
            max = weight;
        }
        int gcd = MathMan.gcd(counts);
        if (max / gcd > 100000) {
            return Optional.empty();
        }
        ArrayList<T> parsed = new ArrayList<T>();
        for (Map.Entry<T, Double> entry : weights.entrySet()) {
            int num = (int)(100.0 * entry.getValue());
            for (int j = 0; j < num / gcd; ++j) {
                parsed.add(entry.getKey());
            }
        }
        Object[] values = parsed.toArray();
        FastRandomCollection<Object> fastRandomCollection = new FastRandomCollection<Object>(values, random);
        return Optional.of(fastRandomCollection);
    }

    @Override
    public T next(int x, int y, int z) {
        return this.values[this.getRandom().nextInt(x, y, z, this.values.length)];
    }
}

