/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.object.collection.AdaptedSetCollection;
import com.boydti.fawe.object.collection.MutablePair;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IAdaptedMap<K, V, K2, V2>
extends Map<K, V> {
    public Map<K2, V2> getParent();

    public K2 adaptKey(K var1);

    public V2 adaptValue(V var1);

    public K adaptKey2(K2 var1);

    public V adaptValue2(V2 var1);

    @Override
    default public int size() {
        return this.getParent().size();
    }

    @Override
    default public boolean isEmpty() {
        return this.getParent().isEmpty();
    }

    @Override
    default public boolean containsKey(Object key) {
        return this.getParent().containsKey(this.adaptKey(key));
    }

    @Override
    default public boolean containsValue(Object value) {
        return this.getParent().containsValue(this.adaptValue(value));
    }

    @Override
    default public V get(Object key) {
        return this.adaptValue2(this.getParent().get(this.adaptKey(key)));
    }

    @Override
    @Nullable
    default public V put(K key, V value) {
        return this.adaptValue2(this.getParent().put(this.adaptKey(key), this.adaptValue(value)));
    }

    @Override
    default public V remove(Object key) {
        return this.adaptValue2(this.getParent().remove(this.adaptKey(key)));
    }

    @Override
    default public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    default public void clear() {
        this.getParent().clear();
    }

    @Override
    @NotNull
    default public Set<K> keySet() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        return new AdaptedSetCollection(this.getParent().keySet(), this::adaptKey2);
    }

    @Override
    @NotNull
    default public Collection<V> values() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        return new AdaptedSetCollection(this.getParent().values(), this::adaptValue2);
    }

    @Override
    @NotNull
    default public Set<Map.Entry<K, V>> entrySet() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        return new AdaptedSetCollection(this.getParent().entrySet(), new Function<Map.Entry<K2, V2>, Map.Entry<K, V>>(){
            private MutablePair<K, V> entry = new MutablePair();

            public Map.Entry<K, V> apply(@javax.annotation.Nullable Map.Entry<K2, V2> input) {
                this.entry.setKey(IAdaptedMap.this.adaptKey2(input.getKey()));
                this.entry.setValue(IAdaptedMap.this.adaptValue2(input.getValue()));
                return this.entry;
            }
        });
    }
}

