/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.object.collection.CleanableThreadLocal;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;

public class IterableThreadLocal<T>
extends ThreadLocal<T>
implements Iterable<T> {
    private final ConcurrentLinkedDeque<T> allValues = new ConcurrentLinkedDeque();
    private final Supplier<T> supplier;

    public IterableThreadLocal(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final T initialValue() {
        T value = this.init();
        if (value != null) {
            IterableThreadLocal iterableThreadLocal = this;
            synchronized (iterableThreadLocal) {
                this.allValues.add(value);
            }
        }
        return value;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.getAll().iterator();
    }

    public T init() {
        return this.supplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        if (!this.allValues.isEmpty()) {
            IterableThreadLocal iterableThreadLocal = this;
            synchronized (iterableThreadLocal) {
                CleanableThreadLocal.clean(this);
                this.allValues.clear();
            }
        }
    }

    public final Collection<T> getAll() {
        return Collections.unmodifiableCollection(this.allValues);
    }

    protected void finalize() throws Throwable {
        CleanableThreadLocal.clean(this);
        super.finalize();
    }
}

