/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.object.collection.SparseBitSet;
import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.MutableBlockVector2;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LocalBlockVector2DSet
implements Set<BlockVector2> {
    private final SparseBitSet set;
    private final MutableBlockVector2 mutable = new MutableBlockVector2();

    public LocalBlockVector2DSet() {
        this.set = new SparseBitSet();
    }

    public SparseBitSet getBitSet() {
        return this.set;
    }

    @Override
    public int size() {
        return this.set.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public boolean contains(int x, int y) {
        return this.set.get(MathMan.pairSearchCoords(x, y));
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof BlockVector2) {
            BlockVector2 v = (BlockVector2)o;
            return this.contains(v.getBlockX(), v.getBlockZ());
        }
        return false;
    }

    public boolean containsRadius(int x, int y, int radius) {
        int size = this.size();
        if (size == 0) {
            return false;
        }
        if (radius <= 0 || size == 1) {
            return this.contains(x, y);
        }
        int length = (radius << 1) + 1;
        if (this.size() < length * length) {
            int index = -1;
            boolean count = false;
            while ((index = this.set.nextSetBit(index + 1)) != -1) {
                int curx = MathMan.unpairSearchCoordsX(index);
                int cury = MathMan.unpairSearchCoordsY(index);
                if (Math.abs(curx - x) > radius || Math.abs(cury - y) > radius) continue;
                return true;
            }
            return false;
        }
        int bcx = Math.max(0, x - radius >> 4);
        int bcy = Math.max(0, y - radius >> 4);
        int tcx = Math.min(2047, x + radius >> 4);
        int tcy = Math.min(2047, y + radius >> 4);
        for (int cy = bcy; cy <= tcy; ++cy) {
            for (int cx = bcx; cx <= tcx; ++cx) {
                int index = MathMan.pairSearchCoords(cx << 4, cy << 4) - 1;
                int endIndex = index + 256;
                while ((index = this.set.nextSetBit(index + 1)) != -1 && index <= endIndex) {
                    int curx = MathMan.unpairSearchCoordsX(index);
                    int cury = MathMan.unpairSearchCoordsY(index);
                    if (Math.abs(curx - x) > radius || Math.abs(cury - y) > radius) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public BlockVector2 getIndex(int getIndex) {
        int size = this.size();
        if (getIndex > size) {
            return null;
        }
        int index = -1;
        for (int i = 0; i <= getIndex; ++i) {
            index = this.set.nextSetBit(index + 1);
        }
        if (index != -1) {
            int x = MathMan.unpairSearchCoordsX(index);
            int y = MathMan.unpairSearchCoordsY(index);
            return this.mutable.setComponents(x, y);
        }
        return null;
    }

    @Override
    public Iterator<BlockVector2> iterator() {
        return new Iterator<BlockVector2>(){
            int index;
            int previous;
            {
                this.index = LocalBlockVector2DSet.this.set.nextSetBit(0);
                this.previous = -1;
            }

            @Override
            public void remove() {
                LocalBlockVector2DSet.this.set.clear(this.previous);
            }

            @Override
            public boolean hasNext() {
                return this.index != -1;
            }

            @Override
            public BlockVector2 next() {
                if (this.index != -1) {
                    int x = MathMan.unpairSearchCoordsX(this.index);
                    int y = MathMan.unpairSearchCoordsY(this.index);
                    LocalBlockVector2DSet.this.mutable.setComponents(x, y);
                    this.previous = this.index;
                    this.index = LocalBlockVector2DSet.this.set.nextSetBit(this.index + 1);
                    return LocalBlockVector2DSet.this.mutable;
                }
                return null;
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array == null || array.length < size) {
            array = new BlockVector2[size];
        }
        int index = 0;
        for (int i = 0; i < size; ++i) {
            index = this.set.nextSetBit(index);
            int x = MathMan.unpairSearchCoordsX(index);
            int y = MathMan.unpairSearchCoordsY(index);
            array[i] = BlockVector2.at(x, y);
            ++index;
        }
        return array;
    }

    public boolean add(int x, int y) {
        if (x < 0 || x > 32766 || y < 0 || y > 32766) {
            throw new UnsupportedOperationException("LocalVector2DSet can only contain Vector2Ds within 1024 blocks (cuboid) of the first entry. ");
        }
        int index = this.getIndex(x, y);
        if (this.set.get(index)) {
            return false;
        }
        this.set.set(index);
        return true;
    }

    @Override
    public boolean add(BlockVector2 vector) {
        return this.add(vector.getBlockX(), vector.getBlockZ());
    }

    private int getIndex(BlockVector2 vector) {
        return MathMan.pairSearchCoords(vector.getBlockX(), vector.getBlockZ());
    }

    private int getIndex(int x, int y) {
        return MathMan.pairSearchCoords(x, y);
    }

    public boolean remove(int x, int y) {
        if (x < 0 || x > 32766 || y < 0 || y > 32766) {
            return false;
        }
        int index = MathMan.pairSearchCoords(x, y);
        boolean value = this.set.get(index);
        if (value) {
            this.set.clear(index);
        }
        return value;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof BlockVector2) {
            BlockVector2 v = (BlockVector2)o;
            return this.remove(v.getBlockX(), v.getBlockZ());
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    @Override
    public boolean addAll(Collection<? extends BlockVector2> c) {
        return c.stream().map(this::add).reduce(false, (a, b) -> a != false || b != false);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        boolean result = false;
        int size = this.size();
        int index = -1;
        for (int i = 0; i < size; ++i) {
            index = this.set.nextSetBit(index + 1);
            int x = MathMan.unpairSearchCoordsX(index);
            int y = MathMan.unpairSearchCoordsY(index);
            this.mutable.setComponents(x, y);
            if (c.contains(this.mutable)) continue;
            result = true;
            this.set.clear(index);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return c.stream().map(this::remove).reduce(false, (a, b) -> a != false || b != false);
    }

    @Override
    public void clear() {
        this.set.clear();
    }
}

