/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.object.collection.SparseBitSet;
import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector3;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LocalBlockVectorSet
implements Set<BlockVector3> {
    private int offsetX;
    private int offsetZ;
    private final SparseBitSet set;

    public LocalBlockVectorSet() {
        this.offsetZ = Integer.MAX_VALUE;
        this.offsetX = Integer.MAX_VALUE;
        this.set = new SparseBitSet();
    }

    public LocalBlockVectorSet(int x, int z, SparseBitSet set) {
        this.offsetX = x;
        this.offsetZ = z;
        this.set = set;
    }

    @Override
    public int size() {
        return this.set.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public boolean contains(int x, int y, int z) {
        return this.set.get(MathMan.tripleSearchCoords(x - this.offsetX, y, z - this.offsetZ));
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof BlockVector3) {
            BlockVector3 v = (BlockVector3)o;
            return this.contains(v.getBlockX(), v.getBlockY(), v.getBlockZ());
        }
        return false;
    }

    public LocalBlockVectorSet clone() {
        return new LocalBlockVectorSet(this.offsetX, this.offsetZ, this.set.clone());
    }

    public boolean containsRadius(int x, int y, int z, int radius) {
        if (radius <= 0) {
            return this.contains(x, y, z);
        }
        int length = radius * 2;
        if (this.size() < length * length * length) {
            int index = -1;
            while ((index = this.set.nextSetBit(index + 1)) != -1) {
                int b1 = (byte)(index >> 0) & 0xFF;
                int b2 = (byte)(index >> 8) & 0x7F;
                int b3 = (byte)(index >> 15) & 0xFF;
                int b4 = (byte)(index >> 23) & 0xFF;
                if (Math.abs(this.offsetX + (b3 + (MathMan.unpair8x(b2) << 8) << 21 >> 21) - x) > radius || Math.abs(this.offsetZ + (b4 + (MathMan.unpair8y(b2) << 8) << 21 >> 21) - z) > radius || Math.abs(b1 - y) > radius) continue;
                return true;
            }
            return false;
        }
        for (int xx = -radius; xx <= radius; ++xx) {
            for (int yy = -radius; yy <= radius; ++yy) {
                for (int zz = -radius; zz <= radius; ++zz) {
                    if (!this.contains(x + xx, y + yy, z + zz)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void addOffset(int x, int z) {
        this.offsetX += x;
        this.offsetZ += z;
    }

    public void setOffset(int x, int z) {
        this.offsetX = x;
        this.offsetZ = z;
    }

    protected BlockVector3 getIndex(int getIndex) {
        int size = this.size();
        if (getIndex > size) {
            return null;
        }
        int index = -1;
        for (int i = 0; i <= getIndex; ++i) {
            index = this.set.nextSetBit(index + 1);
        }
        if (index != -1) {
            int b1 = (byte)(index >> 0) & 0xFF;
            int b2 = (byte)(index >> 8) & 0x7F;
            int b3 = (byte)(index >> 15) & 0xFF;
            int b4 = (byte)(index >> 23) & 0xFF;
            int x = this.offsetX + (b3 + (MathMan.unpair8x(b2) << 8) << 21 >> 21);
            int z = this.offsetZ + (b4 + (MathMan.unpair8y(b2) << 8) << 21 >> 21);
            return MutableBlockVector3.get(x, b1, z);
        }
        return null;
    }

    @Override
    @NotNull
    public Iterator<BlockVector3> iterator() {
        return new Iterator<BlockVector3>(){
            int index;
            int previous;
            MutableBlockVector3 mutable;
            {
                this.index = LocalBlockVectorSet.this.set.nextSetBit(0);
                this.previous = -1;
                this.mutable = new MutableBlockVector3(0, 0, 0);
            }

            @Override
            public void remove() {
                LocalBlockVectorSet.this.set.clear(this.previous);
            }

            @Override
            public boolean hasNext() {
                return this.index != -1;
            }

            @Override
            public BlockVector3 next() {
                if (this.index != -1) {
                    int b1 = this.index & 0xFF;
                    int b2 = (byte)(this.index >> 8) & 0x7F;
                    int b3 = (byte)(this.index >> 15) & 0xFF;
                    int b4 = (byte)(this.index >> 23) & 0xFF;
                    this.mutable.mutX(LocalBlockVectorSet.this.offsetX + (b3 + (MathMan.unpair8x(b2) << 8) << 21 >> 21));
                    this.mutable.mutY(b1);
                    this.mutable.mutZ(LocalBlockVectorSet.this.offsetZ + (b4 + (MathMan.unpair8y(b2) << 8) << 21 >> 21));
                    this.previous = this.index;
                    this.index = LocalBlockVectorSet.this.set.nextSetBit(this.index + 1);
                    return this.mutable;
                }
                return null;
            }
        };
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    @Override
    @NotNull
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array == null || array.length < size) {
            array = new BlockVector3[size];
        }
        int index = 0;
        for (int i = 0; i < size; ++i) {
            index = this.set.nextSetBit(index);
            int b1 = index & 0xFF;
            int b2 = (byte)(index >> 8) & 0x7F;
            int b3 = (byte)(index >> 15) & 0xFF;
            int b4 = (byte)(index >> 23) & 0xFF;
            int x = this.offsetX + (b3 + (MathMan.unpair8x(b2) << 8) << 21 >> 21);
            int z = this.offsetZ + (b4 + (MathMan.unpair8y(b2) << 8) << 21 >> 21);
            array[i] = BlockVector3.at(x, b1, z);
            ++index;
        }
        return array;
    }

    public boolean canAdd(int x, int y, int z) {
        if (this.offsetX == Integer.MAX_VALUE) {
            return false;
        }
        int relX = x - this.offsetX;
        int relZ = z - this.offsetZ;
        if (relX > 1023 || relX < -1024 || relZ > 1023 || relZ < -1024) {
            return false;
        }
        return y >= 0 && y <= 256;
    }

    public boolean add(int x, int y, int z) {
        if (this.offsetX == Integer.MAX_VALUE) {
            this.offsetX = x;
            this.offsetZ = z;
        }
        int relX = x - this.offsetX;
        int relZ = z - this.offsetZ;
        if (relX > 1023 || relX < -1024 || relZ > 1023 || relZ < -1024) {
            throw new UnsupportedOperationException("LocalVectorSet can only contain vectors within 1024 blocks (cuboid) of the first entry. ");
        }
        if (y < 0 || y > 255) {
            throw new UnsupportedOperationException("LocalVectorSet can only contain vectors from y elem:[0,255]");
        }
        int index = this.getIndex(x, y, z);
        if (this.set.get(index)) {
            return false;
        }
        this.set.set(index);
        return true;
    }

    @Override
    public boolean add(BlockVector3 vector) {
        return this.add(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    private int getIndex(BlockVector3 vector) {
        return MathMan.tripleSearchCoords(vector.getBlockX() - this.offsetX, vector.getBlockY(), vector.getBlockZ() - this.offsetZ);
    }

    private int getIndex(int x, int y, int z) {
        return MathMan.tripleSearchCoords(x - this.offsetX, y, z - this.offsetZ);
    }

    public boolean remove(int x, int y, int z) {
        int relX = x - this.offsetX;
        int relZ = z - this.offsetZ;
        if (relX > 1023 || relX < -1024 || relZ > 1023 || relZ < -1024) {
            return false;
        }
        int index = MathMan.tripleSearchCoords(relX, y, relZ);
        boolean value = this.set.get(index);
        this.set.clear(index);
        return value;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof BlockVector3) {
            BlockVector3 v = (BlockVector3)o;
            return this.remove(v.getBlockX(), v.getBlockY(), v.getBlockZ());
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends BlockVector3> c) {
        boolean result = false;
        for (BlockVector3 blockVector3 : c) {
            result |= this.add(blockVector3);
        }
        return result;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        boolean result = false;
        int size = this.size();
        int index = -1;
        MutableBlockVector3 mVec = MutableBlockVector3.get(0, 0, 0);
        for (int i = 0; i < size; ++i) {
            index = this.set.nextSetBit(index + 1);
            int b1 = index & 0xFF;
            int b2 = (byte)(index >> 8) & 0x7F;
            int b3 = (byte)(index >> 15) & 0xFF;
            int b4 = (byte)(index >> 23) & 0xFF;
            mVec.mutX(this.offsetX + (b3 + (MathMan.unpair8x(b2) << 8) << 21 >> 21));
            mVec.mutY(b1);
            mVec.mutZ(this.offsetZ + (b4 + (MathMan.unpair8y(b2) << 8) << 21 >> 21));
            if (c.contains(mVec)) continue;
            result = true;
            this.set.clear(index);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    public void forEach(BlockVectorSetVisitor visitor) {
        int size = this.size();
        int index = -1;
        MutableBlockVector3 mVec = MutableBlockVector3.get(0, 0, 0);
        for (int i = 0; i < size; ++i) {
            index = this.set.nextSetBit(index + 1);
            int b1 = index & 0xFF;
            int b2 = (byte)(index >> 8) & 0x7F;
            int b3 = (byte)(index >> 15) & 0xFF;
            int b4 = (byte)(index >> 23) & 0xFF;
            int x = this.offsetX + (b3 + (MathMan.unpair8x(b2) << 8) << 21 >> 21);
            int z = this.offsetZ + (b4 + (MathMan.unpair8y(b2) << 8) << 21 >> 21);
            visitor.run(x, b1, z, index);
        }
    }

    @Override
    public void clear() {
        this.offsetZ = Integer.MAX_VALUE;
        this.offsetX = Integer.MAX_VALUE;
        this.set.clear();
    }

    public static interface BlockVectorSetVisitor {
        public void run(int var1, int var2, int var3, int var4);
    }
}

