/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.object.collection.BlockSet;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector2;
import com.sk89q.worldedit.math.MutableBlockVector3;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class MemBlockSet
extends BlockSet {
    public static final int BITS_PER_WORD = 6;
    public static final int WORDS = FaweCache.IMP.BLOCKS_PER_LAYER >> 6;
    public static final IRow NULL_ROW_X = new NullRowX();
    public static final IRow NULL_ROW_Z = new NullRowZ();
    public static final IRow NULL_ROW_Y = new NullRowY();
    public final IRow[] rows;
    public final MutableBlockVector3 mutable;

    public MemBlockSet() {
        this(16, 0, 0);
    }

    public MemBlockSet(int size, int offsetX, int offsetZ) {
        super(offsetX, offsetZ);
        this.rows = new IRow[size];
        for (int i = 0; i < size; ++i) {
            this.rows[i] = NULL_ROW_X;
        }
        this.mutable = new MutableBlockVector3();
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return this.rows[(x -= this.getBlockOffsetX()) >> 4].get(this.rows, x, y, (z -= this.getBlockOffsetZ()) - this.getBlockOffsetZ());
    }

    @Override
    public boolean add(int x, int y, int z) {
        return this.rows[(x -= this.getBlockOffsetX()) >> 4].add(this.rows, x, y, (z -= this.getBlockOffsetZ()) - this.getBlockOffsetZ());
    }

    @Override
    public void set(int x, int y, int z) {
        this.rows[(x -= this.getBlockOffsetX()) >> 4].set(this.rows, x, y, (z -= this.getBlockOffsetZ()) - this.getBlockOffsetZ());
    }

    @Override
    public void clear(int x, int y, int z) {
        this.rows[(x -= this.getBlockOffsetX()) >> 4].clear(this.rows, x, y, (z -= this.getBlockOffsetZ()) - this.getBlockOffsetZ());
    }

    @Override
    public boolean remove(int x, int y, int z) {
        return this.rows[(x -= this.getBlockOffsetX()) >> 4].remove(this.rows, x, y, (z -= this.getBlockOffsetZ()) - this.getBlockOffsetZ());
    }

    @Override
    public BlockVector3 getMinimumPoint() {
        return BlockVector3.at(this.getMinX(), this.getMinimumY(), this.getMinZ());
    }

    @Override
    public BlockVector3 getMaximumPoint() {
        return BlockVector3.at(this.getMaxX(), this.getMaximumY(), this.getMaxZ());
    }

    @Override
    public Set<BlockVector2> getChunks() {
        return new AbstractSet<BlockVector2>(){

            @Override
            @NotNull
            public Iterator<BlockVector2> iterator() {
                return new Iterator<BlockVector2>(){
                    private MutableBlockVector2 mutable = new MutableBlockVector2();
                    private boolean hasNext;
                    private int X;
                    private int Z;
                    private int setX;
                    private int setZ;
                    {
                        this.init();
                    }

                    private void init() {
                        while (this.X < MemBlockSet.this.rows.length) {
                            IRow nullRowX = MemBlockSet.this.rows[this.X];
                            if (nullRowX instanceof RowX) {
                                RowX rowx = (RowX)nullRowX;
                                while (this.Z < rowx.rows.length) {
                                    IRow nullRowZ = rowx.rows[this.Z];
                                    if (nullRowZ instanceof RowZ) {
                                        this.setX = this.X;
                                        this.setZ = this.Z++;
                                        this.hasNext = true;
                                        return;
                                    }
                                    ++this.Z;
                                }
                                this.Z = 0;
                            }
                            ++this.X;
                        }
                        this.hasNext = false;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public BlockVector2 next() {
                        this.mutable.setComponents(this.setX + MemBlockSet.this.getBlockOffsetX(), this.setZ + MemBlockSet.this.getBlockOffsetZ());
                        this.init();
                        return this.mutable;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("This set is immutable.");
                    }
                };
            }

            @Override
            public int size() {
                int size = 0;
                for (IRow nullRowX : MemBlockSet.this.rows) {
                    if (!(nullRowX instanceof RowX)) continue;
                    RowX rowx = (RowX)nullRowX;
                    for (int Z = 0; Z < rowx.rows.length; ++Z) {
                        IRow nullRowZ = rowx.rows[Z];
                        if (!(nullRowZ instanceof RowZ)) continue;
                        ++size;
                    }
                }
                return size;
            }

            @Override
            public boolean isEmpty() {
                return MemBlockSet.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                BlockVector2 other;
                IRow rowx;
                if (o instanceof BlockVector2 && (rowx = MemBlockSet.this.rows[(other = (BlockVector2)o).getX() - MemBlockSet.this.getChunkOffsetX()]) instanceof RowX) {
                    return ((RowX)rowx).rows[other.getZ() - MemBlockSet.this.getChunkOffsetZ()] instanceof RowZ;
                }
                return false;
            }
        };
    }

    @Override
    public Set<BlockVector3> getChunkCubes() {
        return new AbstractSet<BlockVector3>(){

            @Override
            public Iterator<BlockVector3> iterator() {
                return new Iterator<BlockVector3>(){
                    private MutableBlockVector3 mutable = new MutableBlockVector3();
                    private boolean hasNext;
                    private int X;
                    private int Z;
                    private int Y;
                    private int setX;
                    private int setY;
                    private int setZ;
                    {
                        this.init();
                    }

                    private void init() {
                        while (this.X < MemBlockSet.this.rows.length) {
                            IRow nullRowX = MemBlockSet.this.rows[this.X];
                            if (nullRowX instanceof RowX) {
                                RowX rowx = (RowX)nullRowX;
                                while (this.Z < rowx.rows.length) {
                                    IRow nullRowZ = rowx.rows[this.Z];
                                    if (nullRowZ instanceof RowZ) {
                                        RowZ rowz = (RowZ)nullRowZ;
                                        while (this.Y < rowz.rows.length) {
                                            IRow nullRowY = rowz.rows[this.Y];
                                            if (nullRowY instanceof RowY) {
                                                this.setX = this.X;
                                                this.setY = this.Y;
                                                this.setZ = this.Z++;
                                                this.hasNext = true;
                                            }
                                            ++this.Y;
                                        }
                                        this.Y = 0;
                                    }
                                    ++this.Z;
                                }
                                this.Z = 0;
                            }
                            ++this.X;
                        }
                        this.hasNext = false;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public BlockVector3 next() {
                        this.mutable.setComponents(this.setX + MemBlockSet.this.getBlockOffsetX(), this.setY, this.setZ + MemBlockSet.this.getBlockOffsetX());
                        this.init();
                        return this.mutable;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("This set is immutable.");
                    }
                };
            }

            @Override
            public int size() {
                int size = 0;
                for (IRow nullRowX : MemBlockSet.this.rows) {
                    if (!(nullRowX instanceof RowX)) continue;
                    RowX rowx = (RowX)nullRowX;
                    for (int Z = 0; Z < rowx.rows.length; ++Z) {
                        IRow nullRowZ = rowx.rows[Z];
                        if (!(nullRowZ instanceof RowZ)) continue;
                        RowZ rowz = (RowZ)nullRowZ;
                        for (int Y = 0; Y < rowz.rows.length; ++Y) {
                            IRow nullRowY = rowz.rows[Y];
                            if (!(nullRowY instanceof RowY)) continue;
                            ++size;
                        }
                    }
                }
                return size;
            }

            @Override
            public boolean isEmpty() {
                return MemBlockSet.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                IRow rowz;
                BlockVector3 other;
                IRow rowx;
                if (o instanceof BlockVector3 && (rowx = MemBlockSet.this.rows[(other = (BlockVector3)o).getX() - MemBlockSet.this.getChunkOffsetX()]) instanceof RowX && (rowz = ((RowX)rowx).rows[other.getZ()]) instanceof RowZ) {
                    return ((RowZ)rowz).rows[other.getY() - MemBlockSet.this.getChunkOffsetZ()] instanceof RowY;
                }
                return false;
            }
        };
    }

    @Override
    public int getMinimumY() {
        int maxY = 15;
        int maxy = 16;
        int by = Integer.MAX_VALUE;
        for (IRow nullRowX : this.rows) {
            if (!(nullRowX instanceof RowX)) continue;
            RowX rowx = (RowX)nullRowX;
            block1: for (int Z = 0; Z < rowx.rows.length; ++Z) {
                IRow nullRowZ = rowx.rows[Z];
                if (!(nullRowZ instanceof RowZ)) continue;
                RowZ rowz = (RowZ)nullRowZ;
                for (int Y = 0; Y <= maxY; ++Y) {
                    IRow nullRowY = rowz.rows[Y];
                    if (!(nullRowY instanceof RowY)) continue;
                    RowY rowY = (RowY)nullRowY;
                    int localMaxy = Y == maxY ? maxy : 15;
                    int i = 0;
                    for (int y = 0; y < localMaxy; ++y) {
                        int xz = 0;
                        while (xz < 4) {
                            long val = rowY.bits[i];
                            if (val != 0L) {
                                if (y == 0) {
                                    maxY = Y - 1;
                                    maxy = 16;
                                } else {
                                    maxY = Y;
                                    maxy = y;
                                }
                                by = (Y << 4) + y;
                                if (by != 0) continue block1;
                                return 0;
                            }
                            ++xz;
                            ++i;
                        }
                    }
                }
            }
        }
        return by;
    }

    @Override
    public int getMaximumY() {
        int maxY = 0;
        int maxy = 0;
        int by = Integer.MIN_VALUE;
        for (IRow nullRowX : this.rows) {
            if (!(nullRowX instanceof RowX)) continue;
            RowX rowx = (RowX)nullRowX;
            block1: for (int Z = 0; Z < rowx.rows.length; ++Z) {
                IRow nullRowZ = rowx.rows[Z];
                if (!(nullRowZ instanceof RowZ)) continue;
                RowZ rowz = (RowZ)nullRowZ;
                for (int Y = 15; Y >= maxY; --Y) {
                    IRow nullRowY = rowz.rows[Y];
                    if (!(nullRowY instanceof RowY)) continue;
                    RowY rowY = (RowY)nullRowY;
                    int localMaxy = Y == maxY ? maxy : 0;
                    int i = 63;
                    for (int y = 15; y >= localMaxy; --y) {
                        int xz = 3;
                        while (xz >= 0) {
                            long val = rowY.bits[i];
                            if (val != 0L) {
                                if (y == 15) {
                                    maxY = Y + 1;
                                    maxy = 0;
                                } else {
                                    maxY = Y;
                                    maxy = y + 1;
                                }
                                by = (Y << 4) + y;
                                if (by != FaweCache.IMP.WORLD_MAX_Y) continue block1;
                                return FaweCache.IMP.WORLD_MAX_Y;
                            }
                            --xz;
                            --i;
                        }
                    }
                }
            }
        }
        return by;
    }

    public int getMaxZ() {
        int maxChunkZ = 0;
        int maxz = -1;
        int tz = Integer.MIN_VALUE;
        block0: for (int X = this.rows.length - 1; X >= 0; --X) {
            IRow nullRowX = this.rows[X];
            if (!(nullRowX instanceof RowX)) continue;
            RowX rowx = (RowX)nullRowX;
            for (int Z = rowx.rows.length - 1; Z >= maxChunkZ; --Z) {
                IRow nullRowZ = rowx.rows[Z];
                if (!(nullRowZ instanceof RowZ)) continue;
                RowZ rowz = (RowZ)nullRowZ;
                if (Z != maxChunkZ) {
                    maxChunkZ = Z;
                    maxz = -1;
                }
                for (int Y = rowz.rows.length - 1; Y >= 0; --Y) {
                    IRow nullRowY = rowz.rows[Y];
                    if (!(nullRowY instanceof RowY)) continue;
                    RowY rowY = (RowY)nullRowY;
                    int y = 15;
                    int i1 = 63;
                    while (y >= 0) {
                        int z = 12;
                        int i = i1;
                        while (z > maxz - 3) {
                            long bitBuffer = rowY.bits[i];
                            if (bitBuffer != 0L) {
                                int highest = this.highestBit(bitBuffer);
                                maxz = z + (highest >> 4);
                                if (maxz == 15) {
                                    tz = (maxChunkZ << 4) + 15;
                                    ++maxChunkZ;
                                    continue block0;
                                }
                                tz = Math.max(tz, (maxChunkZ << 4) + maxz);
                                break;
                            }
                            z -= 4;
                            --i;
                        }
                        --y;
                        i1 -= 4;
                    }
                }
                continue block0;
            }
        }
        return tz + this.getBlockOffsetZ();
    }

    public int getMaxX() {
        for (int X = this.rows.length - 1; X >= 0; --X) {
            IRow nullRowX = this.rows[X];
            if (!(nullRowX instanceof RowX)) continue;
            int tx = X << 4;
            RowX rowx = (RowX)nullRowX;
            long or = 0L;
            for (int Z = rowx.rows.length - 1; Z >= 0; --Z) {
                IRow nullRowZ = rowx.rows[Z];
                if (!(nullRowZ instanceof RowZ)) continue;
                RowZ rowz = (RowZ)nullRowZ;
                for (int Y = rowz.rows.length - 1; Y >= 0; --Y) {
                    IRow nullRowY = rowz.rows[Y];
                    if (!(nullRowY instanceof RowY)) continue;
                    RowY rowY = (RowY)nullRowY;
                    or |= Arrays.stream(rowY.bits).reduce(0L, (a, b) -> a | b);
                    if (this.highestBit(or = or & 0xFFFFL | or >> 16 & 0xFFFFL | or >> 32 & 0xFFFFL | or >> 48 & 0xFFFFL) != 15) continue;
                    return tx + 15;
                }
            }
            int highest = this.highestBit(or);
            if (highest == 64) continue;
            return tx + highest + this.getBlockOffsetX();
        }
        return Integer.MAX_VALUE;
    }

    public int getMinZ() {
        int maxChunkZ = this.rows.length - 1;
        int maxz = 16;
        int bz = Integer.MAX_VALUE;
        block0: for (IRow nullRowX : this.rows) {
            if (!(nullRowX instanceof RowX)) continue;
            RowX rowx = (RowX)nullRowX;
            for (int Z = 0; Z <= maxChunkZ; ++Z) {
                IRow nullRowZ = rowx.rows[Z];
                if (!(nullRowZ instanceof RowZ)) continue;
                RowZ rowz = (RowZ)nullRowZ;
                if (Z != maxChunkZ) {
                    maxChunkZ = Z;
                    maxz = 16;
                }
                for (int Y = 0; Y < rowz.rows.length; ++Y) {
                    IRow nullRowY = rowz.rows[Y];
                    if (!(nullRowY instanceof RowY)) continue;
                    RowY rowY = (RowY)nullRowY;
                    int y = 0;
                    int i1 = 0;
                    while (y < 16) {
                        int z = 0;
                        int i = i1;
                        while (z < maxz) {
                            long bitBuffer = rowY.bits[i];
                            if (bitBuffer != 0L) {
                                int lowest = this.lowestBit(bitBuffer);
                                maxz = z + (lowest >> 4);
                                if (maxz == 0) {
                                    bz = maxChunkZ << 4;
                                    --maxChunkZ;
                                    continue block0;
                                }
                                bz = Math.min(bz, (maxChunkZ << 4) + maxz);
                                break;
                            }
                            z += 4;
                            ++i;
                        }
                        ++y;
                        i1 += 4;
                    }
                }
                continue block0;
            }
        }
        return bz + this.getBlockOffsetZ();
    }

    public int getMinX() {
        for (int X = 0; X < this.rows.length; ++X) {
            IRow nullRowX = this.rows[X];
            if (!(nullRowX instanceof RowX)) continue;
            int bx = X << 4;
            RowX rowx = (RowX)nullRowX;
            long or = 0L;
            for (int Z = 0; Z < rowx.rows.length; ++Z) {
                IRow nullRowZ = rowx.rows[Z];
                if (!(nullRowZ instanceof RowZ)) continue;
                RowZ rowz = (RowZ)nullRowZ;
                for (int Y = 0; Y < rowz.rows.length; ++Y) {
                    IRow nullRowY = rowz.rows[Y];
                    if (!(nullRowY instanceof RowY)) continue;
                    RowY rowY = (RowY)nullRowY;
                    or |= Arrays.stream(rowY.bits).reduce(0L, (a, b) -> a | b);
                    if (this.lowestBit(or = or & 0xFFFFL | or >> 16 & 0xFFFFL | or >> 32 & 0xFFFFL | or >> 48 & 0xFFFFL) != 0) continue;
                    return bx;
                }
            }
            int lowest = this.lowestBit(or);
            if (lowest == 64) continue;
            return bx + lowest + this.getBlockOffsetX();
        }
        return Integer.MAX_VALUE;
    }

    public void iterate(BlockIterator iterator) {
        for (int X = 0; X < this.rows.length; ++X) {
            IRow nullRowX = this.rows[X];
            if (!(nullRowX instanceof RowX)) continue;
            int bx = this.getBlockOffsetX() + (X << 4);
            RowX rowx = (RowX)nullRowX;
            for (int Z = 0; Z < rowx.rows.length; ++Z) {
                IRow nullRowZ = rowx.rows[Z];
                if (!(nullRowZ instanceof RowZ)) continue;
                int bz = this.getBlockOffsetZ() + (Z << 4);
                RowZ rowz = (RowZ)nullRowZ;
                for (int Y = 0; Y < rowz.rows.length; ++Y) {
                    IRow nullRowY = rowz.rows[Y];
                    if (!(nullRowY instanceof RowY)) continue;
                    int by = Y << 4;
                    RowY rowY = (RowY)nullRowY;
                    int i = 0;
                    for (int y = 0; y < 16; ++y) {
                        int z = 0;
                        while (z < 16) {
                            long bitBuffer = rowY.bits[i];
                            if (bitBuffer != 0L) {
                                if (bitBuffer == -1L) {
                                    for (int zz = z; zz < z + 4; ++zz) {
                                        for (int x = 0; x < 16; ++x) {
                                            iterator.apply(bx + x, by + y, bz + zz);
                                        }
                                    }
                                } else {
                                    long lowBit;
                                    do {
                                        lowBit = Long.lowestOneBit(bitBuffer);
                                        int bitIndex = Long.bitCount(lowBit - 1L);
                                        int x = bitIndex & 0xF;
                                        int zz = z + (bitIndex >> 4);
                                        iterator.apply(bx + x, by + y, bz + zz);
                                    } while ((bitBuffer ^= lowBit) != 0L);
                                }
                            }
                            z += 4;
                            ++i;
                        }
                    }
                }
            }
        }
    }

    @Override
    public Iterator<BlockVector3> iterator() {
        return new Iterator<BlockVector3>(){
            private int bx;
            private int by;
            private int bz;
            private int zz;
            private int yy;
            private RowX rowX;
            private RowZ rowZ;
            private long[] bits;
            private int bitsIndex = 0;
            private int yIndex = 0;
            private int zIndex = 0;
            private int xIndex = 0;
            private long bitBuffer = 0L;
            private boolean next;
            {
                if (this.nextRowX() && this.nextRowZ() && this.nextRowY()) {
                    this.next = this.nextLong();
                }
            }

            private boolean nextRowX() {
                while (this.xIndex < MemBlockSet.this.rows.length) {
                    IRow nullRowX;
                    this.bx = MemBlockSet.this.getBlockOffsetX() + (this.xIndex << 4);
                    if (!((nullRowX = MemBlockSet.this.rows[this.xIndex++]) instanceof RowX)) continue;
                    this.rowX = (RowX)nullRowX;
                    return true;
                }
                return false;
            }

            private boolean nextRowZ() {
                while (this.zIndex < this.rowX.rows.length) {
                    this.bz = MemBlockSet.this.getBlockOffsetZ() + (this.zIndex << 4);
                    IRow nullRowZ = this.rowX.rows[this.zIndex++];
                    if (!(nullRowZ instanceof RowZ)) continue;
                    this.rowZ = (RowZ)nullRowZ;
                    return true;
                }
                if (this.nextRowX()) {
                    this.zIndex = 0;
                    return this.nextRowZ();
                }
                return false;
            }

            private boolean nextRowY() {
                while (this.yIndex < this.rowZ.rows.length) {
                    IRow nullRowY;
                    this.by = this.yIndex << 4;
                    if (!((nullRowY = this.rowZ.rows[this.yIndex++]) instanceof RowY)) continue;
                    RowY rowY = (RowY)nullRowY;
                    this.bits = rowY.bits;
                    return true;
                }
                if (this.nextRowZ()) {
                    this.yIndex = 0;
                    return this.nextRowY();
                }
                return false;
            }

            private boolean nextLong() {
                if (this.bitBuffer == 0L) {
                    do {
                        this.bitBuffer = this.bits[this.bitsIndex++];
                        if (this.bitsIndex != this.bits.length) continue;
                        this.bitsIndex = 0;
                        if (this.nextRowY()) continue;
                        this.next = false;
                        return false;
                    } while (this.bitBuffer == 0L);
                    this.zz = this.bz + (this.bitsIndex - 1 << 2 & 0xF);
                    this.yy = this.by + (this.bitsIndex - 1 >> 2);
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.next;
            }

            @Override
            public BlockVector3 next() {
                long lowBit = Long.lowestOneBit(this.bitBuffer);
                int bitIndex = Long.bitCount(lowBit - 1L);
                MemBlockSet.this.mutable.setComponents(this.bx + (bitIndex & 0xF), this.yy, this.zz + bitIndex);
                this.bitBuffer ^= lowBit;
                this.nextLong();
                return MemBlockSet.this.mutable;
            }

            @Override
            public void remove() {
                MemBlockSet.this.remove(MemBlockSet.this.mutable);
            }
        };
    }

    @Override
    public boolean isEmpty() {
        for (IRow nullRowX : this.rows) {
            if (!(nullRowX instanceof RowX)) continue;
            RowX rowx = (RowX)nullRowX;
            for (int Z = 0; Z < rowx.rows.length; ++Z) {
                IRow nullRowZ = rowx.rows[Z];
                if (!(nullRowZ instanceof RowZ)) continue;
                RowZ rowz = (RowZ)nullRowZ;
                for (int Y = 0; Y < 16; ++Y) {
                    IRow nullRowY = rowz.rows[Y];
                    if (!(nullRowY instanceof RowY)) continue;
                    RowY rowY = (RowY)nullRowY;
                    for (long bit : rowY.bits) {
                        if (bit == 0L) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public int size() {
        return (int)this.sizeLong();
    }

    public long sizeLong() {
        long total = 0L;
        long lastBit = 0L;
        int lastCount = 0;
        for (IRow nullRowX : this.rows) {
            if (!(nullRowX instanceof RowX)) continue;
            RowX rowx = (RowX)nullRowX;
            for (int z = 0; z < rowx.rows.length; ++z) {
                IRow nullRowZ = rowx.rows[z];
                if (!(nullRowZ instanceof RowZ)) continue;
                RowZ rowz = (RowZ)nullRowZ;
                for (int y = 0; y < 16; ++y) {
                    IRow nullRowY = rowz.rows[y];
                    if (!(nullRowY instanceof RowY)) continue;
                    RowY rowY = (RowY)nullRowY;
                    for (long bit : rowY.bits) {
                        if (bit == 0L) continue;
                        if (bit == -1L) {
                            total += 64L;
                            continue;
                        }
                        if (bit == lastBit) {
                            total += (long)lastCount;
                            continue;
                        }
                        lastBit = bit;
                        lastCount = Long.bitCount(bit);
                        total += (long)lastCount;
                    }
                }
            }
        }
        return total;
    }

    @Override
    public void clear() {
        Arrays.fill(this.rows, NULL_ROW_X);
    }

    private static IRow[] resize(IRow[] arr, IRow def) {
        int len = arr.length;
        int newLen = len == 1 ? 1 : Integer.highestOneBit(len - 1) * 2;
        IRow[] copy = (IRow[])Arrays.copyOf(arr, newLen, IRow[].class);
        for (int i = len; i < newLen; ++i) {
            copy[i] = def;
        }
        return copy;
    }

    public static final class RowY
    implements IRow {
        private final long[] bits = new long[WORDS];

        public long[] getBits() {
            return this.bits;
        }

        @Override
        public boolean get(IRow[] parent, int x, int y, int z) {
            int i = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
            return (this.bits[i >> 6] & 1L << (i & 0x3F)) != 0L;
        }

        @Override
        public void set(IRow[] parent, int x, int y, int z) {
            int i = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
            int n = i >> 6;
            this.bits[n] = this.bits[n] | 1L << (i & 0x3F);
        }

        @Override
        public boolean add(IRow[] parent, int x, int y, int z) {
            int i = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
            int offset = i >> 6;
            long value = this.bits[offset];
            long mask = 1L << (i & 0x3F);
            if ((value & mask) == 0L) {
                this.bits[offset] = value | mask;
                return true;
            }
            return false;
        }

        @Override
        public void clear(IRow[] parent, int x, int y, int z) {
            int i = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
            int n = i >> 6;
            this.bits[n] = this.bits[n] & (1L << (i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public boolean remove(IRow[] rows, int x, int y, int z) {
            int i = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
            int offset = i >> 6;
            long value = this.bits[offset];
            long mask = 1L << (i & 0x3F);
            if ((value & mask) != 0L) {
                this.bits[offset] = value & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                return true;
            }
            return false;
        }
    }

    public static final class RowZ
    implements IRow {
        public final IRow[] rows;

        public RowZ() {
            this.rows = new IRow[FaweCache.IMP.CHUNK_LAYERS];
            this.reset();
        }

        public IRow getRow(int i) {
            return this.rows[i];
        }

        @Override
        public boolean get(IRow[] parent, int x, int y, int z) {
            return this.rows[y >> 4].get(this.rows, x, y, z);
        }

        @Override
        public void set(IRow[] parent, int x, int y, int z) {
            this.rows[y >> 4].set(this.rows, x, y, z);
        }

        @Override
        public boolean add(IRow[] parent, int x, int y, int z) {
            return this.rows[y >> 4].add(this.rows, x, y, z);
        }

        @Override
        public void clear(IRow[] parent, int x, int y, int z) {
            this.rows[y >> 4].set(this.rows, x, y, z);
        }

        @Override
        public boolean remove(IRow[] parent, int x, int y, int z) {
            return this.rows[y >> 4].remove(this.rows, x, y, z);
        }

        public boolean isEmpty() {
            for (IRow row : this.rows) {
                if (!(row instanceof RowY)) continue;
                return false;
            }
            return true;
        }

        public void reset(int layer) {
            this.rows[layer] = NULL_ROW_Y;
        }

        public void reset() {
            for (int i = 0; i < FaweCache.IMP.CHUNK_LAYERS; ++i) {
                this.rows[i] = NULL_ROW_Y;
            }
        }
    }

    public static final class RowX
    implements IRow {
        private final IRow[] rows;

        public RowX(int size) {
            this.rows = new IRow[size];
            for (int i = 0; i < size; ++i) {
                this.rows[i] = NULL_ROW_Z;
            }
        }

        @Override
        public boolean get(IRow[] parent, int x, int y, int z) {
            return this.rows[z >> 4].get(this.rows, x, y, z);
        }

        @Override
        public void set(IRow[] parent, int x, int y, int z) {
            this.rows[z >> 4].set(this.rows, x, y, z);
        }

        @Override
        public boolean add(IRow[] parent, int x, int y, int z) {
            return this.rows[z >> 4].add(this.rows, x, y, z);
        }

        @Override
        public void clear(IRow[] parent, int x, int y, int z) {
            this.rows[z >> 4].clear(this.rows, x, y, z);
        }

        @Override
        public boolean remove(IRow[] parent, int x, int y, int z) {
            return this.rows[z >> 4].remove(this.rows, x, y, z);
        }
    }

    public static final class NullRowY
    implements IRow {
        @Override
        public void set(IRow[] parent, int x, int y, int z) {
            RowY row = new RowY();
            parent[y >> 4] = row;
            row.set(parent, x, y, z);
        }
    }

    public static final class NullRowZ
    implements IRow {
        @Override
        public void set(IRow[] parent, int x, int y, int z) {
            RowZ row = new RowZ();
            parent[z >> 4] = row;
            row.set(parent, x, y, z);
        }
    }

    public static final class NullRowX
    implements IRow {
        @Override
        public void set(IRow[] parent, int x, int y, int z) {
            RowX row = new RowX(parent.length);
            parent[x >> 4] = row;
            row.set(parent, x, y, z);
        }
    }

    public static interface IRow {
        default public boolean get(IRow[] rows, int x, int y, int z) {
            return false;
        }

        public void set(IRow[] var1, int var2, int var3, int var4);

        default public boolean add(IRow[] rows, int x, int y, int z) {
            this.set(rows, x, y, z);
            return true;
        }

        default public boolean remove(IRow[] rows, int x, int y, int z) {
            this.remove(rows, x, y, z);
            return false;
        }

        default public void clear(IRow[] rows, int x, int y, int z) {
        }
    }

    public static interface BlockIterator {
        public void apply(int var1, int var2, int var3);
    }
}

