/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.sk89q.worldedit.bukkit.fastutil.HashCommon;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class ObjObjMap<K, V> {
    private static final Object FREE_KEY = new Object();
    private static final Object REMOVED_KEY = new Object();
    private Object[] m_data;
    private Object m_nullValue;
    private boolean m_hasNull;
    private final float m_fillFactor;
    private int m_threshold;
    private int m_size;
    private int m_mask;
    private int m_mask2;

    public ObjObjMap(int size, float fillFactor) {
        if (fillFactor <= 0.0f || fillFactor >= 1.0f) {
            throw new IllegalArgumentException("FillFactor must be in (0, 1)");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive!");
        }
        int capacity = HashCommon.arraySize(size, fillFactor);
        this.m_mask = capacity - 1;
        this.m_mask2 = capacity * 2 - 1;
        this.m_fillFactor = fillFactor;
        this.m_data = new Object[capacity * 2];
        Arrays.fill(this.m_data, FREE_KEY);
        this.m_threshold = (int)((float)capacity * fillFactor);
    }

    public V get(@Nonnull K key) {
        int ptr = (key.hashCode() & this.m_mask) << 1;
        Object k = this.m_data[ptr];
        if (k == key) {
            return (V)this.m_data[ptr + 1];
        }
        while ((k = this.m_data[ptr = ptr + 2 & this.m_mask2]) != key) {
        }
        return (V)this.m_data[ptr + 1];
    }

    public V put(K key, V value) {
        if (key == null) {
            return this.insertNullKey(value);
        }
        int ptr = this.getStartIndex(key) << 1;
        Object k = this.m_data[ptr];
        if (k == FREE_KEY) {
            this.m_data[ptr] = key;
            this.m_data[ptr + 1] = value;
            if (this.m_size >= this.m_threshold) {
                this.rehash(this.m_data.length * 2);
            } else {
                ++this.m_size;
            }
            return null;
        }
        if (k == key) {
            Object ret = this.m_data[ptr + 1];
            this.m_data[ptr + 1] = value;
            return (V)ret;
        }
        int firstRemoved = -1;
        if (k == REMOVED_KEY) {
            firstRemoved = ptr;
        }
        while (true) {
            if ((k = this.m_data[ptr = ptr + 2 & this.m_mask2]) == FREE_KEY) {
                if (firstRemoved != -1) {
                    ptr = firstRemoved;
                }
                this.m_data[ptr] = key;
                this.m_data[ptr + 1] = value;
                if (this.m_size >= this.m_threshold) {
                    this.rehash(this.m_data.length * 2);
                } else {
                    ++this.m_size;
                }
                return null;
            }
            if (k == key) {
                Object ret = this.m_data[ptr + 1];
                this.m_data[ptr + 1] = value;
                return (V)ret;
            }
            if (k != REMOVED_KEY || firstRemoved != -1) continue;
            firstRemoved = ptr;
        }
    }

    public V remove(K key) {
        if (key == null) {
            return this.removeNullKey();
        }
        int ptr = this.getStartIndex(key) << 1;
        Object k = this.m_data[ptr];
        if (k == FREE_KEY) {
            return null;
        }
        if (k == key) {
            --this.m_size;
            this.m_data[ptr] = this.m_data[ptr + 2 & this.m_mask2] == FREE_KEY ? FREE_KEY : REMOVED_KEY;
            Object ret = this.m_data[ptr + 1];
            this.m_data[ptr + 1] = null;
            return (V)ret;
        }
        do {
            if ((k = this.m_data[ptr = ptr + 2 & this.m_mask2]) != FREE_KEY) continue;
            return null;
        } while (k != key);
        --this.m_size;
        this.m_data[ptr] = this.m_data[ptr + 2 & this.m_mask2] == FREE_KEY ? FREE_KEY : REMOVED_KEY;
        Object ret = this.m_data[ptr + 1];
        this.m_data[ptr + 1] = null;
        return (V)ret;
    }

    private V insertNullKey(V value) {
        if (this.m_hasNull) {
            Object ret = this.m_nullValue;
            this.m_nullValue = value;
            return (V)ret;
        }
        this.m_nullValue = value;
        ++this.m_size;
        return null;
    }

    private V removeNullKey() {
        if (this.m_hasNull) {
            Object ret = this.m_nullValue;
            this.m_nullValue = null;
            this.m_hasNull = false;
            --this.m_size;
            return (V)ret;
        }
        return null;
    }

    public int size() {
        return this.m_size;
    }

    private void rehash(int newCapacity) {
        this.m_threshold = (int)((float)(newCapacity / 2) * this.m_fillFactor);
        this.m_mask = newCapacity / 2 - 1;
        this.m_mask2 = newCapacity - 1;
        int oldCapacity = this.m_data.length;
        Object[] oldData = this.m_data;
        this.m_data = new Object[newCapacity];
        Arrays.fill(this.m_data, FREE_KEY);
        this.m_size = this.m_hasNull ? 1 : 0;
        for (int i = 0; i < oldCapacity; i += 2) {
            Object oldKey = oldData[i];
            if (oldKey == FREE_KEY || oldKey == REMOVED_KEY) continue;
            this.put(oldKey, oldData[i + 1]);
        }
    }

    public int getStartIndex(Object key) {
        return key.hashCode() & this.m_mask;
    }
}

