/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.object.collection.FastRandomCollection;
import com.boydti.fawe.object.collection.SimpleRandomCollection;
import com.boydti.fawe.object.random.SimpleRandom;
import com.google.common.base.Preconditions;
import java.util.Map;

public abstract class RandomCollection<T> {
    private SimpleRandom random;

    protected RandomCollection(SimpleRandom random) {
        this.random = random;
    }

    public static <T> RandomCollection<T> of(Map<T, Double> weights, SimpleRandom random) {
        Preconditions.checkNotNull((Object)random);
        return FastRandomCollection.create(weights, random).orElse(new SimpleRandomCollection<T>(weights, random));
    }

    public void setRandom(SimpleRandom random) {
        Preconditions.checkNotNull((Object)random);
        this.random = random;
    }

    public SimpleRandom getRandom() {
        return this.random;
    }

    public abstract T next(int var1, int var2, int var3);
}

