/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.util.MathMan;

public class SummedAreaTable {
    private final char[] source;
    private final long[] summed;
    private final int length;
    private final int width;
    private final int area;
    private final int radius;
    private final float areaInverse;
    private final float[] areaInverses;

    public SummedAreaTable(long[] buffer, char[] matrix, int width, int radius) {
        this.source = matrix;
        this.summed = buffer;
        this.width = width;
        this.length = buffer.length / width;
        this.radius = radius;
        this.area = MathMan.sqr(radius * 2 + 1);
        this.areaInverse = 1.0f / (float)this.area;
        this.areaInverses = new float[this.area - 2];
        for (int area = 2; area < this.area; ++area) {
            this.areaInverses[area - 2] = 1.0f / (float)area;
        }
    }

    public void processSummedAreaTable() {
        int rowSize = this.source.length / this.width;
        int index = 0;
        for (int i = 0; i < rowSize; ++i) {
            int j = 0;
            while (j < this.width) {
                long val;
                this.summed[index] = val = this.getVal(i, j, index, this.source[index]);
                ++j;
                ++index;
            }
        }
    }

    private long getSum(int index) {
        if (index < 0) {
            return 0L;
        }
        return this.summed[index];
    }

    public int average(int x, int z, int index) {
        int minX = Math.max(0, x - this.radius) - x;
        int minZ = Math.max(0, z - this.radius) - z;
        int maxX = Math.min(this.width - 1, x + this.radius) - x;
        int maxZ = Math.min(this.length - 1, z + this.radius) - z;
        int maxzwi = maxZ * this.width;
        int XZ = index + maxzwi + maxX;
        int area = (maxX - minX + 1) * (maxZ - minZ + 1);
        long total = this.getSum(XZ);
        int minzw = minZ * this.width;
        int Z = index + minzw + maxX;
        if (x > this.radius) {
            int X = index + minX + maxzwi;
            int M = index + minzw + minX;
            total -= this.summed[X - 1];
            total += this.getSum(M - this.width - 1);
        }
        total -= this.getSum(Z - this.width);
        if (area == this.area) {
            return (int)((float)total * this.areaInverse);
        }
        return Math.round((float)total * this.areaInverses[area - 2]);
    }

    private long getVal(int row, int col, int index, long curr) {
        if (index == 0) {
            return curr;
        }
        if (row == 0 && col != 0) {
            long leftSum = this.summed[index - 1];
            return curr + leftSum;
        }
        if (row != 0 && col == 0) {
            long topSum = this.summed[index - this.width];
            return curr + topSum;
        }
        long leftSum = this.summed[index - 1];
        long topSum = this.summed[index - this.width];
        long topLeftSum = this.summed[index - this.width - 1];
        return curr + leftSum + topSum - topLeftSum;
    }
}

