/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.boydti.fawe.beta.IChunk;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.object.FaweLimit;
import com.boydti.fawe.object.extent.FaweRegionExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIntersection;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Future;

public class MultiRegionExtent
extends FaweRegionExtent {
    private final RegionIntersection intersection;
    private final Region[] regions;
    private Region region;
    private int index = 0;

    public MultiRegionExtent(Extent extent, FaweLimit limit, Region[] regions) {
        super(extent, limit);
        this.region = regions[0];
        this.regions = regions;
        this.intersection = new RegionIntersection(Arrays.asList(regions));
    }

    @Override
    public boolean contains(int x, int y, int z) {
        if (this.region.contains(x, y, z)) {
            return true;
        }
        for (int i = 0; i < this.regions.length; ++i) {
            Region current;
            if (i == this.index || !(current = this.regions[i]).contains(x, y, z)) continue;
            this.region = current;
            this.index = i;
            return true;
        }
        return false;
    }

    @Override
    public boolean processGet(int chunkX, int chunkZ) {
        for (Region region : this.regions) {
            if (!region.containsChunk(chunkX, chunkZ)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(int x, int z) {
        if (this.region.contains(x, z)) {
            return true;
        }
        for (int i = 0; i < this.regions.length; ++i) {
            Region current;
            if (i == this.index || !(current = this.regions[i]).contains(x, z)) continue;
            this.region = current;
            this.index = i;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Region> getRegions() {
        return Arrays.asList(this.regions);
    }

    @Override
    public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        return this.intersection.processSet(chunk, get, set);
    }

    @Override
    public Future<IChunkSet> postProcessSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        return this.intersection.postProcessSet(chunk, get, set);
    }
}

