/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.boydti.fawe.object.extent.RandomTransform;
import com.boydti.fawe.object.extent.ResettableExtent;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Collection;
import javax.annotation.Nullable;

public class MultiTransform
extends RandomTransform {
    private ResettableExtent[] extents;

    public MultiTransform(Collection<ResettableExtent> extents) {
        for (ResettableExtent extent : extents) {
            this.add(extent, 1.0);
        }
    }

    public MultiTransform() {
        this.extents = new ResettableExtent[0];
    }

    @Override
    public void add(ResettableExtent extent, double chance) {
        super.add(extent, chance);
        this.extents = this.getExtents().toArray(new ResettableExtent[0]);
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(int x, int y, int z, T block) throws WorldEditException {
        boolean result = false;
        for (ResettableExtent extent : this.extents) {
            result |= extent.setBlock(x, y, z, block);
        }
        return result;
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 location, T block) throws WorldEditException {
        boolean result = false;
        for (ResettableExtent extent : this.extents) {
            result |= extent.setBlock(location, block);
        }
        return result;
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        boolean result = false;
        for (ResettableExtent extent : this.extents) {
            result |= extent.setBiome(position, biome);
        }
        return result;
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        Entity created = null;
        for (ResettableExtent extent : this.extents) {
            created = extent.createEntity(location, entity);
        }
        return created;
    }
}

