/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.boydti.fawe.object.extent.ResettableExtent;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import javax.annotation.Nullable;

public class ScaleTransform
extends ResettableExtent {
    private final double dx;
    private final double dy;
    private final double dz;
    private transient MutableBlockVector3 mutable = new MutableBlockVector3();
    private transient int maxy;
    private transient BlockVector3 min;

    public ScaleTransform(Extent parent, double dx, double dy, double dz) {
        super(parent);
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.maxy = parent.getMaximumPoint().getBlockY();
    }

    @Override
    public ResettableExtent setExtent(Extent extent) {
        this.min = null;
        this.maxy = extent.getMaximumPoint().getBlockY();
        this.mutable = new MutableBlockVector3();
        return super.setExtent(extent);
    }

    private BlockVector3 getPos(BlockVector3 pos) {
        if (this.min == null) {
            this.min = pos;
        }
        this.mutable.mutX((double)this.min.getX() + (double)(pos.getX() - this.min.getX()) * this.dx);
        this.mutable.mutY((double)this.min.getY() + (double)(pos.getY() - this.min.getY()) * this.dy);
        this.mutable.mutZ((double)this.min.getZ() + (double)(pos.getZ() - this.min.getZ()) * this.dz);
        return this.mutable;
    }

    private BlockVector3 getPos(int x, int y, int z) {
        if (this.min == null) {
            this.min = BlockVector3.at(x, y, z);
        }
        this.mutable.mutX((double)this.min.getX() + (double)(x - this.min.getX()) * this.dx);
        this.mutable.mutY((double)this.min.getY() + (double)(y - this.min.getY()) * this.dy);
        this.mutable.mutZ((double)this.min.getZ() + (double)(z - this.min.getZ()) * this.dz);
        return this.mutable;
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        boolean result = false;
        MutableBlockVector3 pos = new MutableBlockVector3(this.getPos(location));
        double sx = pos.getX();
        double sy = pos.getY();
        double sz = pos.getZ();
        double ex = sx + this.dx;
        double ey = Math.min((double)this.maxy, sy + this.dy);
        double ez = sz + this.dz;
        pos.mutY(sy);
        while ((double)pos.getY() < ey) {
            pos.mutZ(sz);
            while ((double)pos.getZ() < ez) {
                pos.mutX(sx);
                while ((double)pos.getX() < ex) {
                    result |= super.setBlock(pos, block);
                    pos.mutX(pos.getX() + 1);
                }
                pos.mutZ(pos.getZ() + 1);
            }
            pos.mutY(pos.getY() + 1);
        }
        return result;
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        boolean result = false;
        MutableBlockVector3 pos = new MutableBlockVector3(this.getPos(position));
        double sx = pos.getX();
        double sy = pos.getY();
        double sz = pos.getZ();
        double ex = sx + this.dx;
        double ey = Math.min((double)this.maxy, sy + this.dy);
        double ez = sz + this.dz;
        pos.mutY(sy);
        while ((double)pos.getY() < ey) {
            pos.mutZ(sz);
            while ((double)pos.getZ() < ez) {
                pos.mutX(sx);
                while ((double)pos.getX() < ex) {
                    result |= super.setBiome(pos, biome);
                    pos.mutX(pos.getX() + 1);
                }
                pos.mutZ(pos.getZ() + 1);
            }
            pos.mutY(pos.getY() + 1);
        }
        return result;
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x1, int y1, int z1, B block) throws WorldEditException {
        boolean result = false;
        MutableBlockVector3 pos = new MutableBlockVector3(this.getPos(x1, y1, z1));
        double sx = pos.getX();
        double sy = pos.getY();
        double sz = pos.getZ();
        double ex = (double)pos.getX() + this.dx;
        double ey = Math.min((double)this.maxy, sy + this.dy);
        double ez = (double)pos.getZ() + this.dz;
        pos.mutY(sy);
        while ((double)pos.getY() < ey) {
            pos.mutZ(sz);
            while ((double)pos.getZ() < ez) {
                pos.mutX(sx);
                while ((double)pos.getX() < ex) {
                    result |= super.setBlock(pos, block);
                    pos.mutX(pos.getX() + 1);
                }
                pos.mutZ(pos.getZ() + 1);
            }
            pos.mutY(pos.getY() + 1);
        }
        return result;
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        Location newLoc = new Location(location.getExtent(), this.getPos(location.getBlockX(), location.getBlockY(), location.getBlockZ()).toVector3(), location.getYaw(), location.getPitch());
        return super.createEntity(newLoc, entity);
    }
}

