/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.function.block;

import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector3;

public class BiomeCopy
implements RegionFunction {
    protected final Extent source;
    protected final Extent destination;
    private final MutableBlockVector3 mutableVector;

    public BiomeCopy(Extent source, Extent destination) {
        this.source = source;
        this.destination = destination;
        this.mutableVector = new MutableBlockVector3();
        this.mutableVector.setComponents(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Override
    public boolean apply(BlockVector3 position) throws WorldEditException {
        int x = position.getBlockX();
        int y = position.getBlockY();
        int z = position.getBlockZ();
        if (x != this.mutableVector.getBlockX() || z != this.mutableVector.getBlockZ() || y != this.mutableVector.getBlockY()) {
            this.mutableVector.setComponents(x, y, z);
            return this.destination.setBiome(this.mutableVector, this.source.getBiome(this.mutableVector));
        }
        return false;
    }
}

