/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.mask;

import com.boydti.fawe.object.mask.CachedMask;
import com.boydti.fawe.object.mask.ResettableMask;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector3;

public class AdjacentAnyMask
extends AbstractMask
implements ResettableMask {
    private final CachedMask mask;
    private final MutableBlockVector3 mutable;

    public AdjacentAnyMask(Mask mask) {
        this.mask = CachedMask.cache(mask);
        this.mutable = new MutableBlockVector3();
    }

    @Override
    public void reset() {
        this.mutable.setComponents(0, 0, 0);
    }

    public CachedMask getParentMask() {
        return this.mask;
    }

    @Override
    public boolean test(BlockVector3 v) {
        return this.direction(v) != null;
    }

    public BlockVector3 direction(BlockVector3 v) {
        int z;
        int y;
        int x = v.getBlockX();
        if (this.mask.test(x + 1, y = v.getBlockY(), z = v.getBlockZ())) {
            return this.mutable.setComponents(1, 0, 0);
        }
        if (this.mask.test(x - 1, y, z)) {
            return this.mutable.setComponents(-1, 0, 0);
        }
        if (this.mask.test(x, y, z + 1)) {
            return this.mutable.setComponents(0, 0, 1);
        }
        if (this.mask.test(x, y, z - 1)) {
            return this.mutable.setComponents(0, 0, -1);
        }
        if (y < 256 && this.mask.test(x, y + 1, z)) {
            return this.mutable.setComponents(0, 1, 0);
        }
        if (y > 0 && this.mask.test(x, y - 1, z)) {
            return this.mutable.setComponents(0, -1, 0);
        }
        return null;
    }

    @Override
    public Mask copy() {
        return new AdjacentAnyMask(this.mask.copy());
    }
}

