/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.mask;

import com.boydti.fawe.object.mask.CachedMask;
import com.boydti.fawe.object.mask.ResettableMask;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.SolidBlockMask;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector3;
import java.util.Arrays;

public class AngleMask
extends SolidBlockMask
implements ResettableMask {
    public static double ADJACENT_MOD = 0.5;
    public static double DIAGONAL_MOD = 1.0 / Math.sqrt(8.0);
    protected final CachedMask mask;
    protected final double max;
    protected final double min;
    protected final boolean overlay;
    protected final boolean checkFirst;
    protected final int maxY;
    protected final int distance;
    protected transient MutableBlockVector3 mutable = new MutableBlockVector3();
    protected transient int cacheCenZ;
    protected transient int cacheBotX = Integer.MIN_VALUE;
    protected transient int cacheBotZ = Integer.MIN_VALUE;
    protected transient int cacheCenterZ;
    protected transient byte[] cacheHeights;
    protected transient int lastY;
    protected transient int lastX = Integer.MIN_VALUE;
    protected transient int lastZ = Integer.MIN_VALUE;
    protected transient boolean foundY;
    protected transient boolean lastValue;

    public AngleMask(Extent extent, double min, double max, boolean overlay, int distance) {
        super(extent);
        this.mask = new CachedMask(new SolidBlockMask(extent));
        this.min = min;
        this.max = max;
        this.checkFirst = max >= Math.tan(1.5707963267948966);
        this.maxY = extent.getMaximumPoint().getBlockY();
        this.overlay = overlay;
        this.distance = distance;
    }

    @Override
    public void reset() {
        this.mutable = new MutableBlockVector3();
        this.cacheBotX = Integer.MIN_VALUE;
        this.cacheBotZ = Integer.MIN_VALUE;
        this.lastX = Integer.MIN_VALUE;
        this.lastY = Integer.MIN_VALUE;
        if (this.cacheHeights != null) {
            Arrays.fill(this.cacheHeights, (byte)0);
        }
    }

    public int getHeight(Extent extent, int x, int y, int z) {
        try {
            int index;
            int rx = x - this.cacheBotX + 16;
            int rz = z - this.cacheBotZ + 16;
            if ((rx & 0xFF) != rx || (rz & 0xFF) != rz) {
                this.cacheBotX = x - 16;
                this.cacheBotZ = z - 16;
                rx = x - this.cacheBotX + 16;
                rz = z - this.cacheBotZ + 16;
                index = rx + (rz << 8);
                if (this.cacheHeights == null) {
                    this.cacheHeights = new byte[65536];
                } else {
                    Arrays.fill(this.cacheHeights, (byte)0);
                }
            } else {
                index = rx + (rz << 8);
            }
            int result = this.cacheHeights[index] & 0xFF;
            if (y > result) {
                result = this.lastY = extent.getNearestSurfaceTerrainBlock(x, z, this.lastY, 0, this.maxY);
                this.cacheHeights[index] = (byte)this.lastY;
            }
            return result;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected boolean testSlope(Extent extent, int x, int y, int z) {
        this.lastY = y;
        double slope = (double)Math.abs(this.getHeight(extent, x + this.distance, y, z) - this.getHeight(extent, x - this.distance, y, z)) * ADJACENT_MOD;
        if (this.checkFirst) {
            if (slope >= this.min) {
                this.lastValue = true;
                return true;
            }
            slope = Math.max(slope, (double)Math.abs(this.getHeight(extent, x, y, z + this.distance) - this.getHeight(extent, x, y, z - this.distance)) * ADJACENT_MOD);
            slope = Math.max(slope, (double)Math.abs(this.getHeight(extent, x + this.distance, y, z + this.distance) - this.getHeight(extent, x - this.distance, y, z - this.distance)) * DIAGONAL_MOD);
            this.lastValue = (slope = Math.max(slope, (double)Math.abs(this.getHeight(extent, x - this.distance, y, z + this.distance) - this.getHeight(extent, x + this.distance, y, z - this.distance)) * DIAGONAL_MOD)) >= this.min;
            return this.lastValue;
        }
        slope = Math.max(slope, (double)Math.abs(this.getHeight(extent, x, y, z + this.distance) - this.getHeight(extent, x, y, z - this.distance)) * ADJACENT_MOD);
        slope = Math.max(slope, (double)Math.abs(this.getHeight(extent, x + this.distance, y, z + this.distance) - this.getHeight(extent, x - this.distance, y, z - this.distance)) * DIAGONAL_MOD);
        this.lastValue = (slope = Math.max(slope, (double)Math.abs(this.getHeight(extent, x - this.distance, y, z + this.distance) - this.getHeight(extent, x + this.distance, y, z - this.distance)) * DIAGONAL_MOD)) >= this.min && slope <= this.max;
        return this.lastValue;
    }

    public boolean adjacentAir(BlockVector3 v) {
        int z;
        int y;
        int x = v.getBlockX();
        if (!this.mask.test(x + 1, y = v.getBlockY(), z = v.getBlockZ())) {
            return true;
        }
        if (!this.mask.test(x - 1, y, z)) {
            return true;
        }
        if (!this.mask.test(x, y, z + 1)) {
            return true;
        }
        if (!this.mask.test(x, y, z - 1)) {
            return true;
        }
        if (y < 255 && !this.mask.test(x, y + 1, z)) {
            return true;
        }
        return y > 0 && !this.mask.test(x, y - 1, z);
    }

    @Override
    public boolean test(BlockVector3 vector) {
        int height;
        int z;
        int x = vector.getBlockX();
        int y = vector.getBlockY();
        this.lastX = x;
        if (this.lastX == this.lastX & (this.lastZ = (z = vector.getBlockZ())) == this.lastZ && y <= (height = this.getHeight(this.getExtent(), x, y, z))) {
            return this.overlay ? this.lastValue && y == height : this.lastValue;
        }
        if (!this.mask.test(x, y, z)) {
            return false;
        }
        if (this.overlay && y < 255 && !this.adjacentAir(vector)) {
            this.lastValue = false;
            return false;
        }
        return this.testSlope(this.getExtent(), x, y, z);
    }

    @Override
    public Mask copy() {
        return new AngleMask(this.getExtent(), this.min, this.max, this.overlay, this.distance);
    }
}

