/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.mask;

import com.boydti.fawe.object.collection.LocalBlockVectorSet;
import com.boydti.fawe.object.function.mask.AbstractDelegateMask;
import com.boydti.fawe.object.mask.ResettableMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MutableBlockVector3;

public class CachedMask
extends AbstractDelegateMask
implements ResettableMask {
    private transient MutableBlockVector3 mutable = new MutableBlockVector3();
    private transient LocalBlockVectorSet cache_checked = new LocalBlockVectorSet();
    private transient LocalBlockVectorSet cache_results = new LocalBlockVectorSet();

    public CachedMask(Mask mask) {
        super(mask);
        this.cache_checked.setOffset(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.cache_results.setOffset(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static CachedMask cache(Mask mask) {
        if (mask instanceof CachedMask) {
            return (CachedMask)mask;
        }
        return new CachedMask(mask);
    }

    @Override
    public void reset() {
        this.mutable = new MutableBlockVector3();
        this.cache_checked = new LocalBlockVectorSet();
        this.cache_results = new LocalBlockVectorSet();
        this.resetCache();
    }

    private void resetCache() {
        this.cache_checked.clear();
        this.cache_results.clear();
        this.cache_checked.setOffset(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.cache_results.setOffset(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Override
    public boolean test(BlockVector3 vector) {
        return this.test(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public boolean test(int x, int y, int z) {
        try {
            boolean check = this.cache_checked.add(x, y, z);
            if (!check) {
                return this.cache_results.contains(x, y, z);
            }
            boolean result = this.getMask().test(this.mutable.setComponents(x, y, z));
            if (result) {
                this.cache_results.add(x, y, z);
            }
            return result;
        }
        catch (UnsupportedOperationException ignored) {
            boolean result = this.getMask().test(this.mutable.setComponents(x, y, z));
            if (y < 0 || y > 255) {
                return result;
            }
            this.resetCache();
            this.cache_checked.setOffset(x, z);
            this.cache_results.setOffset(x, z);
            this.cache_checked.add(x, y, z);
            if (result) {
                this.cache_results.add(x, y, z);
            }
            return result;
        }
    }

    @Override
    public Mask copy() {
        return new CachedMask(this.getMask().copy());
    }
}

