/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.mask;

import com.boydti.fawe.object.mask.ResettableMask;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector3;

public class PlaneMask
extends AbstractMask
implements ResettableMask {
    private transient int mode = -1;
    private transient int originX = Integer.MAX_VALUE;
    private transient int originY = Integer.MAX_VALUE;
    private transient int originZ = Integer.MAX_VALUE;

    @Override
    public boolean test(BlockVector3 vector) {
        switch (this.mode) {
            case -1: {
                this.originX = vector.getBlockX();
                this.originY = vector.getBlockY();
                this.originZ = vector.getBlockZ();
                this.mode = 0;
                return true;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                int original = this.mode;
                if (this.originX != vector.getBlockX()) {
                    this.mode &= 1;
                }
                if (this.originY != vector.getBlockY()) {
                    this.mode &= 2;
                }
                if (this.originZ != vector.getBlockZ()) {
                    this.mode &= 4;
                }
                if (Integer.bitCount(this.mode) < 3) break;
                this.mode = original;
                return false;
            }
        }
        if (this.originX != vector.getBlockX() && (this.mode & 1) == 0) {
            return false;
        }
        if (this.originZ != vector.getBlockZ() && (this.mode & 4) == 0) {
            return false;
        }
        return this.originY == vector.getBlockY() || (this.mode & 2) != 0;
    }

    @Override
    public void reset() {
        this.mode = -1;
    }

    @Override
    public Mask copy() {
        return new PlaneMask();
    }
}

